/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.query.KafkaStreamsBuilder;
import io.confluent.ksql.query.QueryError;
import io.confluent.ksql.query.QueryErrorClassifier;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.QueryMetadataImpl;
import io.confluent.ksql.util.SharedKafkaStreamsRuntime;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.namedtopology.KafkaStreamsNamedTopologyWrapper;
import org.apache.kafka.streams.processor.internals.namedtopology.NamedTopology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedKafkaStreamsRuntimeImpl
extends SharedKafkaStreamsRuntime {
    private final Logger log = LoggerFactory.getLogger(SharedKafkaStreamsRuntimeImpl.class);
    private final long shutdownTimeout;
    private final QueryErrorClassifier errorClassifier;
    private final int maxQueryErrorsQueueSize;
    private final List<KafkaFuture<Void>> topolgogiesToAdd;

    public SharedKafkaStreamsRuntimeImpl(KafkaStreamsBuilder kafkaStreamsBuilder, QueryErrorClassifier errorClassifier, int maxQueryErrorsQueueSize, long shutdownTimeoutConfig, Map<String, Object> streamsProperties) {
        super(kafkaStreamsBuilder, streamsProperties);
        this.errorClassifier = errorClassifier;
        this.maxQueryErrorsQueueSize = maxQueryErrorsQueueSize;
        this.shutdownTimeout = shutdownTimeoutConfig;
        this.setupAndStartKafkaStreams((KafkaStreams)this.kafkaStreams);
        this.topolgogiesToAdd = new ArrayList<KafkaFuture<Void>>();
    }

    @Override
    public void register(BinPackedPersistentQueryMetadataImpl binpackedPersistentQueryMetadata) {
        QueryId queryId = binpackedPersistentQueryMetadata.getQueryId();
        this.collocatedQueries.put(queryId, binpackedPersistentQueryMetadata);
        this.log.info("Registered query: {}  in {} \nRuntime {} is executing these queries: {}", new Object[]{queryId, this.getApplicationId(), this.getApplicationId(), this.collocatedQueries.keySet().stream().map(QueryId::toString).collect(Collectors.joining(", "))});
    }

    private void setupAndStartKafkaStreams(KafkaStreams kafkaStreams) {
        kafkaStreams.setUncaughtExceptionHandler(this::uncaughtHandler);
        kafkaStreams.setStateListener(this.stateListener());
        kafkaStreams.start();
    }

    public KafkaStreams.StateListener stateListener() {
        return (newState, oldState) -> {
            for (BinPackedPersistentQueryMetadataImpl query : this.collocatedQueries.values()) {
                query.onStateChange(newState, oldState);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse uncaughtHandler(Throwable e) {
        QueryError.Type errorType;
        block13: {
            errorType = QueryError.Type.UNKNOWN;
            try {
                errorType = this.errorClassifier.classify(e);
                if (e.getCause() == null || errorType != QueryError.Type.UNKNOWN) break block13;
                errorType = this.errorClassifier.classify(e.getCause());
            }
            catch (Exception classificationException) {
                try {
                    this.log.error("Error classifying unhandled exception", (Throwable)classificationException);
                }
                catch (Throwable throwable) {
                    QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
                    BinPackedPersistentQueryMetadataImpl queryInError = this.parseException(e);
                    if (queryInError != null) {
                        queryInError.setQueryError(queryError);
                        this.log.error(String.format("Unhandled query exception caught in streams thread %s for query %s. (%s)", Thread.currentThread().getName(), queryInError.getQueryId(), errorType), e);
                    } else {
                        for (BinPackedPersistentQueryMetadataImpl query : this.collocatedQueries.values()) {
                            query.setQueryError(queryError);
                        }
                        this.log.error(String.format("Unhandled runtime exception caught in streams thread %s. (%s)", Thread.currentThread().getName(), errorType), e);
                    }
                    throw throwable;
                }
                QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
                BinPackedPersistentQueryMetadataImpl queryInError = this.parseException(e);
                if (queryInError != null) {
                    queryInError.setQueryError(queryError);
                    this.log.error(String.format("Unhandled query exception caught in streams thread %s for query %s. (%s)", Thread.currentThread().getName(), queryInError.getQueryId(), errorType), e);
                } else {
                    for (BinPackedPersistentQueryMetadataImpl query : this.collocatedQueries.values()) {
                        query.setQueryError(queryError);
                    }
                    this.log.error(String.format("Unhandled runtime exception caught in streams thread %s. (%s)", Thread.currentThread().getName(), errorType), e);
                }
            }
        }
        QueryError queryError = new QueryError(System.currentTimeMillis(), Throwables.getStackTraceAsString((Throwable)e), errorType);
        BinPackedPersistentQueryMetadataImpl queryInError = this.parseException(e);
        if (queryInError != null) {
            queryInError.setQueryError(queryError);
            this.log.error(String.format("Unhandled query exception caught in streams thread %s for query %s. (%s)", Thread.currentThread().getName(), queryInError.getQueryId(), errorType), e);
        } else {
            for (BinPackedPersistentQueryMetadataImpl query : this.collocatedQueries.values()) {
                query.setQueryError(queryError);
            }
            this.log.error(String.format("Unhandled runtime exception caught in streams thread %s. (%s)", Thread.currentThread().getName(), errorType), e);
        }
        return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.REPLACE_THREAD;
    }

    private BinPackedPersistentQueryMetadataImpl parseException(Throwable e) {
        QueryId queryId;
        TaskId task = e instanceof StreamsException && ((StreamsException)e).taskId().isPresent() ? (TaskId)((StreamsException)e).taskId().get() : null;
        QueryId queryId2 = queryId = task != null && task.topologyName() != null ? new QueryId(task.topologyName()) : null;
        if (task != null && task.topologyName() == null) {
            this.log.error("Unhandled exception originated from a task {} without an associated topology name (queryId).", (Object)task);
        } else if (queryId != null && !this.collocatedQueries.containsKey(queryId)) {
            this.log.error("Unhandled exception originated from a task {} with an unrecognized topology name (queryId) {}.", (Object)task, (Object)queryId);
        }
        if (queryId != null && this.collocatedQueries.containsKey(queryId)) {
            return (BinPackedPersistentQueryMetadataImpl)this.collocatedQueries.get(queryId);
        }
        return null;
    }

    @Override
    public QueryMetadataImpl.TimeBoundedQueue getNewQueryErrorQueue() {
        return new QueryMetadataImpl.TimeBoundedQueue(Duration.ofHours(1L), this.maxQueryErrorsQueueSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop(QueryId queryId, boolean resetOffsets) {
        this.log.info("Attempting to stop query: {} in runtime {} with resetOffsets={}", new Object[]{queryId, this.getApplicationId(), resetOffsets});
        if (this.kafkaStreams.getTopologyByName(queryId.toString()).isPresent() != this.collocatedQueries.containsKey(queryId)) {
            this.log.error("Non SandBoxed queries should not be registered and never started.");
        }
        if (this.kafkaStreams.getTopologyByName(queryId.toString()).isPresent()) {
            if (!this.kafkaStreams.state().isRunningOrRebalancing()) throw new IllegalStateException("Streams in not running but is in state " + this.kafkaStreams.state());
            try {
                for (KafkaFuture<Void> kafkaFuture : this.topolgogiesToAdd) {
                    kafkaFuture.get();
                }
                this.topolgogiesToAdd.clear();
                this.kafkaStreams.removeNamedTopology(queryId.toString(), resetOffsets).all().get();
                if (resetOffsets) {
                    this.kafkaStreams.cleanUpNamedTopology(queryId.toString());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable throwable = e.getCause() == null ? e : e.getCause();
                throw new IllegalStateException(String.format("Encountered an error when trying to stop query %s in runtime: %s", queryId, this.getApplicationId()), throwable);
            }
        }
        if (resetOffsets) {
            this.collocatedQueries.remove(queryId);
        }
        this.log.info("Query {} was stopped successfully", (Object)queryId);
    }

    @Override
    public synchronized void close() {
        this.kafkaStreams.close();
        this.kafkaStreams.cleanUp();
    }

    @Override
    public void start(QueryId queryId) {
        this.log.info("Attempting to start query {} in runtime {}", (Object)queryId, (Object)this.getApplicationId());
        if (this.collocatedQueries.containsKey(queryId) && !((BinPackedPersistentQueryMetadataImpl)this.collocatedQueries.get((Object)queryId)).everStarted) {
            if (this.kafkaStreams.getTopologyByName(queryId.toString()).isPresent()) {
                throw new IllegalArgumentException("Cannot start because Streams is not done terminating an older version of query : " + queryId);
            }
        } else {
            throw new IllegalArgumentException("Cannot start because query " + queryId + " was not registered to runtime " + this.getApplicationId());
        }
        KafkaFuture toAdd = this.kafkaStreams.addNamedTopology(((BinPackedPersistentQueryMetadataImpl)this.collocatedQueries.get(queryId)).getTopology()).all();
        this.topolgogiesToAdd.add((KafkaFuture<Void>)toAdd);
        this.log.info("Query {} was started successfully", (Object)queryId);
    }

    @Override
    public void overrideStreamsProperties(Map<String, Object> newProperties) {
        newProperties.put("application.server", this.streamsProperties.get((Object)"application.server"));
        this.streamsProperties = ImmutableMap.copyOf(newProperties);
    }

    @Override
    public void restartStreamsRuntime() {
        KafkaStreamsNamedTopologyWrapper kafkaStreamsNamedTopologyWrapper;
        this.log.info("Restarting runtime {}", (Object)this.getApplicationId());
        Collection liveTopologies = this.kafkaStreams.getAllTopologies();
        this.kafkaStreams.close();
        this.kafkaStreams = kafkaStreamsNamedTopologyWrapper = this.kafkaStreamsBuilder.buildNamedTopologyWrapper((Map<String, Object>)this.streamsProperties);
        this.kafkaStreams.setStateListener(this.stateListener());
        for (NamedTopology topology : liveTopologies) {
            BinPackedPersistentQueryMetadataImpl query = (BinPackedPersistentQueryMetadataImpl)this.collocatedQueries.get(new QueryId(topology.name()));
            query.updateTopology(query.getTopologyCopy(this));
            if (query.getQueryStatus() == KsqlConstants.KsqlQueryStatus.PAUSED) {
                kafkaStreamsNamedTopologyWrapper.pauseNamedTopology(topology.name());
            }
            kafkaStreamsNamedTopologyWrapper.addNamedTopology(query.getTopology());
        }
        this.setupAndStartKafkaStreams((KafkaStreams)kafkaStreamsNamedTopologyWrapper);
    }
}

