/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.x509bundle.X509Bundle;
import io.spiffe.exception.BundleNotFoundException;
import io.spiffe.internal.CertificateUtils;
import io.spiffe.provider.AllowedIdSupplierSpiffeIdVerifier;
import io.spiffe.provider.SpiffeIdVerifier;
import io.spiffe.provider.SpiffeVerificationException;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.svid.x509svid.X509SvidValidator;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import lombok.NonNull;

public final class SpiffeTrustManager
extends X509ExtendedTrustManager {
    private static final SpiffeIdVerifier ALLOW_ANY_SPIFFE_ID_VERIFIER = (spiffeId, verifiedChain) -> {};
    private final BundleSource<X509Bundle> x509BundleSource;
    private final SpiffeIdVerifier spiffeIdVerifier;

    public SpiffeTrustManager(@NonNull BundleSource<X509Bundle> x509BundleSource, @NonNull Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        if (acceptedSpiffeIdsSupplier == null) {
            throw new NullPointerException("acceptedSpiffeIdsSupplier is marked non-null but is null");
        }
        this.x509BundleSource = x509BundleSource;
        this.spiffeIdVerifier = new AllowedIdSupplierSpiffeIdVerifier(acceptedSpiffeIdsSupplier);
    }

    public SpiffeTrustManager(@NonNull BundleSource<X509Bundle> x509BundleSource, @NonNull SpiffeIdVerifier spiffeIdVerifier) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        if (spiffeIdVerifier == null) {
            throw new NullPointerException("spiffeIdVerifier is marked non-null but is null");
        }
        this.x509BundleSource = x509BundleSource;
        this.spiffeIdVerifier = spiffeIdVerifier;
    }

    public SpiffeTrustManager(@NonNull BundleSource<X509Bundle> x509BundleSource) {
        if (x509BundleSource == null) {
            throw new NullPointerException("x509BundleSource is marked non-null but is null");
        }
        this.x509BundleSource = x509BundleSource;
        this.spiffeIdVerifier = ALLOW_ANY_SPIFFE_ID_VERIFIER;
    }

    @Override
    public void checkClientTrusted(@NonNull X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.validatePeerChain(chain);
    }

    @Override
    public void checkServerTrusted(@NonNull X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.validatePeerChain(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(@NonNull X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(@NonNull X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(@NonNull X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(@NonNull X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        this.checkServerTrusted(chain, authType);
    }

    private void validatePeerChain(X509Certificate ... chain) throws CertificateException {
        SpiffeId spiffeId = CertificateUtils.getSpiffeId((X509Certificate)chain[0]);
        try {
            this.spiffeIdVerifier.verify(spiffeId, chain);
        }
        catch (SpiffeVerificationException e) {
            throw new CertificateException(e.getMessage(), e);
        }
        try {
            X509SvidValidator.verifyChain(Arrays.asList(chain), this.x509BundleSource);
        }
        catch (BundleNotFoundException e) {
            throw new CertificateException(e.getMessage(), e);
        }
    }
}

