/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.auth.plain;

import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.RealmCallback;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynamicPlainLoginCallbackHandlerTest {
    private final DynamicPlainLoginCallbackHandler callbackHandler = new DynamicPlainLoginCallbackHandler();
    private final NameCallback nameCallback = new NameCallback("name");
    private final PasswordCallback passwordCallback = new PasswordCallback("password", false);
    private JaasContext jaasContext;

    @BeforeEach
    public void setup() {
        String jaasConfig = "io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=\"test.username\" password_config=\"test.password\";";
        this.jaasContext = JaasContext.loadClientContext(Collections.singletonMap("sasl.jaas.config", new Password(jaasConfig)));
    }

    @Test
    public void testCallbackHandler() throws Exception {
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertNull((Object)this.nameCallback.getName());
        Assertions.assertNull((Object)this.passwordCallback.getPassword());
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-password");
        this.callbackHandler.configure(configs, "PLAIN", this.jaasContext.configurationEntries());
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertEquals((Object)"alice", (Object)this.nameCallback.getName());
        Assertions.assertEquals((Object)"alice-password", (Object)new String(this.passwordCallback.getPassword()));
    }

    @Test
    public void testUnsupportedCallback() {
        Assertions.assertThrows(UnsupportedCallbackException.class, () -> this.callbackHandler.handle(new Callback[]{new RealmCallback("realm")}));
    }

    @Test
    public void testConfigure() throws Exception {
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "GSSAPI", this.jaasContext.configurationEntries()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", Collections.emptyList()));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", Arrays.asList((AppConfigurationEntry)this.jaasContext.configurationEntries().get(0), (AppConfigurationEntry)this.jaasContext.configurationEntries().get(0))));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.configure(Collections.emptyMap(), "PLAIN", this.jaasContext.configurationEntries()));
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertNull((Object)this.nameCallback.getName());
        Assertions.assertNull((Object)this.passwordCallback.getPassword());
    }

    @Test
    public void testReconfigurableConfigs() {
        Assertions.assertEquals(Collections.emptySet(), (Object)this.callbackHandler.reconfigurableConfigs());
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-password");
        this.callbackHandler.configure(configs, "PLAIN", this.jaasContext.configurationEntries());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"test.username", "test.password"}), (Object)this.callbackHandler.reconfigurableConfigs());
    }

    @Test
    public void testValidateReconfiguration() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-password");
        this.callbackHandler.configure(configs, "PLAIN", this.jaasContext.configurationEntries());
        configs.remove("test.username");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.validateReconfiguration(configs));
        configs.put("test.username", "bob");
        configs.put("test.password", null);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.callbackHandler.validateReconfiguration(configs));
    }

    @Test
    public void testReconfigure() throws Exception {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-password");
        this.callbackHandler.configure(configs, "PLAIN", this.jaasContext.configurationEntries());
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertEquals((Object)"alice", (Object)this.nameCallback.getName());
        Assertions.assertEquals((Object)"alice-password", (Object)new String(this.passwordCallback.getPassword()));
        configs.put("test.username", "alice");
        configs.put("test.password", "alice-new-password");
        this.callbackHandler.reconfigure(configs);
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertEquals((Object)"alice", (Object)this.nameCallback.getName());
        Assertions.assertEquals((Object)"alice-new-password", (Object)new String(this.passwordCallback.getPassword()));
        configs.put("test.username", "bob");
        configs.put("test.password", "bob-password");
        this.callbackHandler.reconfigure(configs);
        this.callbackHandler.handle(new Callback[]{this.nameCallback, this.passwordCallback});
        Assertions.assertEquals((Object)"bob", (Object)this.nameCallback.getName());
        Assertions.assertEquals((Object)"bob-password", (Object)new String(this.passwordCallback.getPassword()));
    }
}

