/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.MetadataSnapshot;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataSnapshotTest {
    @Test
    public void testMissingLeaderEndpoint() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, topicPartition, Optional.of(5), Optional.of(10), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        HashMap<Integer, Node> nodesById = new HashMap<Integer, Node>();
        nodesById.put(6, new Node(6, "localhost", 2077));
        nodesById.put(7, new Node(7, "localhost", 2078));
        nodesById.put(8, new Node(8, "localhost", 2079));
        MetadataSnapshot cache = new MetadataSnapshot("clusterId", nodesById, Collections.singleton(partitionMetadata), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Collections.emptyMap());
        Cluster cluster = cache.cluster();
        Assertions.assertNull((Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Map replicas = Arrays.stream(partitionInfo.replicas()).collect(Collectors.toMap(Node::id, Function.identity()));
        Assertions.assertNull((Object)partitionInfo.leader());
        Assertions.assertEquals((int)3, (int)replicas.size());
        Assertions.assertTrue((boolean)((Node)replicas.get(5)).isEmpty());
        Assertions.assertEquals(nodesById.get(6), replicas.get(6));
        Assertions.assertEquals(nodesById.get(7), replicas.get(7));
    }

    @Test
    public void testTopicNamesCacheBuiltFromTopicIds() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("topic1", Uuid.randomUuid());
        topicIds.put("topic2", Uuid.randomUuid());
        MetadataSnapshot cache = new MetadataSnapshot("clusterId", Collections.singletonMap(6, new Node(6, "localhost", 2077)), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, topicIds);
        Map<Uuid, String> expectedNamesCache = topicIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Assertions.assertEquals(expectedNamesCache, (Object)cache.topicNames());
    }

    @Test
    public void testEmptyTopicNamesCacheBuiltFromTopicIds() {
        HashMap topicIds = new HashMap();
        MetadataSnapshot cache = new MetadataSnapshot("clusterId", Collections.singletonMap(6, new Node(6, "localhost", 2077)), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, topicIds);
        Assertions.assertEquals(Collections.emptyMap(), (Object)cache.topicNames());
    }

    @Test
    public void testMergeWithThatPreExistingPartitionIsRetainedPostMerge() {
        String topic1 = "topic1";
        TopicPartition topic1Partition = new TopicPartition(topic1, 1);
        MetadataResponse.PartitionMetadata partitionMetadata1 = new MetadataResponse.PartitionMetadata(Errors.NONE, topic1Partition, Optional.of(5), Optional.of(10), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        HashMap<Integer, Node> nodesById = new HashMap<Integer, Node>();
        nodesById.put(6, new Node(6, "localhost", 2077));
        nodesById.put(7, new Node(7, "localhost", 2078));
        nodesById.put(8, new Node(8, "localhost", 2079));
        HashMap<String, Uuid> topicsIds = new HashMap<String, Uuid>();
        Uuid topic1Id = Uuid.randomUuid();
        topicsIds.put(topic1Partition.topic(), topic1Id);
        MetadataSnapshot cache = new MetadataSnapshot("clusterId", nodesById, Collections.singleton(partitionMetadata1), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, topicsIds);
        Cluster cluster = cache.cluster();
        Assertions.assertEquals((int)1, (int)cluster.topics().size());
        Assertions.assertEquals((Object)topic1Id, (Object)cluster.topicId(topic1));
        Assertions.assertEquals((Object)topic1, (Object)cluster.topicName(topic1Id));
        String topic2 = "topic2";
        TopicPartition topic2Partition = new TopicPartition(topic2, 2);
        MetadataResponse.PartitionMetadata partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, topic2Partition, Optional.of(5), Optional.of(10), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        topicsIds = new HashMap();
        Uuid topic2Id = Uuid.randomUuid();
        topicsIds.put(topic2Partition.topic(), topic2Id);
        cache = cache.mergeWith("clusterId", nodesById, Collections.singleton(partitionMetadata2), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, topicsIds, (topic, retain) -> true);
        cluster = cache.cluster();
        Assertions.assertEquals((int)2, (int)cluster.topics().size());
        Assertions.assertEquals((Object)topic1Id, (Object)cluster.topicId(topic1));
        Assertions.assertEquals((Object)topic1, (Object)cluster.topicName(topic1Id));
        Assertions.assertEquals((Object)topic2Id, (Object)cluster.topicId(topic2));
        Assertions.assertEquals((Object)topic2, (Object)cluster.topicName(topic2Id));
    }

    @Test
    public void testLeaderEpochFor() {
        TopicPartition topicPartition1 = new TopicPartition("topic", 0);
        MetadataResponse.PartitionMetadata partitionMetadata1 = new MetadataResponse.PartitionMetadata(Errors.NONE, topicPartition1, Optional.of(5), Optional.of(10), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        TopicPartition topicPartition2 = new TopicPartition("topic", 1);
        MetadataResponse.PartitionMetadata partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, topicPartition2, Optional.of(5), Optional.empty(), Arrays.asList(5, 6, 7), Arrays.asList(5, 6, 7), Collections.emptyList());
        HashMap<Integer, Node> nodesById = new HashMap<Integer, Node>();
        nodesById.put(5, new Node(5, "localhost", 2077));
        nodesById.put(6, new Node(6, "localhost", 2078));
        nodesById.put(7, new Node(7, "localhost", 2079));
        MetadataSnapshot cache = new MetadataSnapshot("clusterId", nodesById, Arrays.asList(partitionMetadata1, partitionMetadata2), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), null, Collections.emptyMap());
        Assertions.assertEquals((Object)OptionalInt.of(10), (Object)cache.leaderEpochFor(topicPartition1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)cache.leaderEpochFor(topicPartition2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)cache.leaderEpochFor(new TopicPartition("topic_missing", 0)));
    }
}

