/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DeleteConsumerGroupOffsetsHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteConsumerGroupOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId = "group-id";
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final Set<TopicPartition> tps = new HashSet<TopicPartition>(Arrays.asList(this.t0p0, this.t0p1, this.t1p0));

    @Test
    public void testBuildRequest() {
        DeleteConsumerGroupOffsetsHandler handler = new DeleteConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetDeleteRequest request = (OffsetDeleteRequest)handler.buildBatchedRequest(1, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id"))).build();
        Assertions.assertEquals((Object)"group-id", (Object)request.data().groupId());
        Assertions.assertEquals((int)2, (int)request.data().topics().size());
        Assertions.assertEquals((int)2, (int)request.data().topics().find("t0").partitions().size());
        Assertions.assertEquals((int)1, (int)request.data().topics().find("t1").partitions().size());
    }

    @Test
    public void testSuccessfulHandleResponse() {
        Map<TopicPartition, Errors> responseData = Collections.singletonMap(this.t0p0, Errors.NONE);
        this.assertCompleted(this.handleWithGroupError(Errors.NONE), responseData);
    }

    @Test
    public void testUnmappedHandleResponse() {
        this.assertUnmapped(this.handleWithGroupError(Errors.NOT_COORDINATOR));
        this.assertUnmapped(this.handleWithGroupError(Errors.COORDINATOR_NOT_AVAILABLE));
    }

    @Test
    public void testRetriableHandleResponse() {
        this.assertRetriable(this.handleWithGroupError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
    }

    @Test
    public void testFailedHandleResponseWithGroupError() {
        this.assertGroupFailed(GroupAuthorizationException.class, this.handleWithGroupError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertGroupFailed(GroupIdNotFoundException.class, this.handleWithGroupError(Errors.GROUP_ID_NOT_FOUND));
        this.assertGroupFailed(InvalidGroupIdException.class, this.handleWithGroupError(Errors.INVALID_GROUP_ID));
        this.assertGroupFailed(GroupNotEmptyException.class, this.handleWithGroupError(Errors.NON_EMPTY_GROUP));
    }

    @Test
    public void testFailedHandleResponseWithPartitionError() {
        this.assertPartitionFailed(Collections.singletonMap(this.t0p0, Errors.GROUP_SUBSCRIBED_TO_TOPIC), this.handleWithPartitionError(Errors.GROUP_SUBSCRIBED_TO_TOPIC));
        this.assertPartitionFailed(Collections.singletonMap(this.t0p0, Errors.TOPIC_AUTHORIZATION_FAILED), this.handleWithPartitionError(Errors.TOPIC_AUTHORIZATION_FAILED));
        this.assertPartitionFailed(Collections.singletonMap(this.t0p0, Errors.UNKNOWN_TOPIC_OR_PARTITION), this.handleWithPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION));
    }

    private OffsetDeleteResponse buildGroupErrorResponse(Errors error) {
        OffsetDeleteResponse response = new OffsetDeleteResponse(new OffsetDeleteResponseData().setErrorCode(error.code()));
        if (error == Errors.NONE) {
            response.data().setThrottleTimeMs(0).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(this.t0p0.topic()).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(this.t0p0.partition()).setErrorCode(error.code())).iterator()))).iterator()));
        }
        return response;
    }

    private OffsetDeleteResponse buildPartitionErrorResponse(Errors error) {
        OffsetDeleteResponse response = new OffsetDeleteResponse(new OffsetDeleteResponseData().setThrottleTimeMs(0).setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(this.t0p0.topic()).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(Collections.singletonList(new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(this.t0p0.partition()).setErrorCode(error.code())).iterator()))).iterator())));
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> handleWithGroupError(Errors error) {
        DeleteConsumerGroupOffsetsHandler handler = new DeleteConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetDeleteResponse response = this.buildGroupErrorResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> handleWithPartitionError(Errors error) {
        DeleteConsumerGroupOffsetsHandler handler = new DeleteConsumerGroupOffsetsHandler("group-id", this.tps, this.logContext);
        OffsetDeleteResponse response = this.buildPartitionErrorResponse(error);
        return handler.handleResponse(new Node(1, "host", 1234), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result, Map<TopicPartition, Errors> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(key));
    }

    private void assertGroupFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }

    private void assertPartitionFailed(Map<TopicPartition, Errors> expectedResult, AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Collection completeCollection = result.completedKeys.values();
        Assertions.assertEquals((int)1, (int)completeCollection.size());
        Assertions.assertEquals(expectedResult, result.completedKeys.get(key));
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
    }
}

