/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.DescribeConsumerGroupsHandler;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class DescribeConsumerGroupsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId1 = "group-id1";
    private final String groupId2 = "group-id2";
    private final Set<String> groupIds = new LinkedHashSet<String>(Arrays.asList("group-id1", "group-id2"));
    private final Set<CoordinatorKey> keys = new LinkedHashSet<CoordinatorKey>(Arrays.asList(CoordinatorKey.byGroupId((String)"group-id1"), CoordinatorKey.byGroupId((String)"group-id2")));
    private final Node coordinator = new Node(1, "host", 1234);
    private final Set<TopicPartition> tps = new HashSet<TopicPartition>(Arrays.asList(new TopicPartition("foo", 0), new TopicPartition("bar", 1)));

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBuildRequestWithMultipleGroupTypes(boolean includeAuthorizedOperations) {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(includeAuthorizedOperations, this.logContext);
        Collection requestAndKeys = handler.buildRequest(1, this.keys);
        Assertions.assertEquals((int)1, (int)requestAndKeys.size());
        this.assertRequestAndKeys((AdminApiHandler.RequestAndKeys<CoordinatorKey>)((AdminApiHandler.RequestAndKeys)requestAndKeys.iterator().next()), this.keys, (ApiMessage)new ConsumerGroupDescribeRequestData().setGroupIds(new ArrayList<String>(this.groupIds)).setIncludeAuthorizedOperations(includeAuthorizedOperations));
        handler.handleResponse(this.coordinator, this.keys, (AbstractResponse)new ConsumerGroupDescribeResponse(new ConsumerGroupDescribeResponseData().setGroups(Arrays.asList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id1").setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code()), new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id2").setErrorCode(Errors.GROUP_ID_NOT_FOUND.code())))));
        requestAndKeys = handler.buildRequest(1, this.keys);
        Assertions.assertEquals((int)2, (int)requestAndKeys.size(), (String)requestAndKeys.toString());
        Iterator iterator = requestAndKeys.iterator();
        this.assertRequestAndKeys((AdminApiHandler.RequestAndKeys<CoordinatorKey>)((AdminApiHandler.RequestAndKeys)iterator.next()), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (ApiMessage)new ConsumerGroupDescribeRequestData().setGroupIds(Collections.singletonList("group-id1")).setIncludeAuthorizedOperations(includeAuthorizedOperations));
        this.assertRequestAndKeys((AdminApiHandler.RequestAndKeys<CoordinatorKey>)((AdminApiHandler.RequestAndKeys)iterator.next()), Collections.singleton(CoordinatorKey.byGroupId((String)"group-id2")), (ApiMessage)new DescribeGroupsRequestData().setGroups(Collections.singletonList("group-id2")).setIncludeAuthorizedOperations(includeAuthorizedOperations));
    }

    @Test
    public void testInvalidBuildRequest() {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(false, this.logContext);
        Assertions.assertThrows(IllegalArgumentException.class, () -> handler.buildRequest(1, Collections.singleton(CoordinatorKey.byTransactionalId((String)"tId"))));
    }

    @Test
    public void testSuccessfulHandleConsumerGroupResponse() {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(false, this.logContext);
        List<MemberDescription> members = Collections.singletonList(new MemberDescription("memberId", Optional.of("instanceId"), "clientId", "host", new MemberAssignment(Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 1)})), Optional.of(new MemberAssignment(Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 2)})))));
        ConsumerGroupDescription expected = new ConsumerGroupDescription("group-id1", false, members, "range", GroupType.CONSUMER, ConsumerGroupState.STABLE, this.coordinator, Collections.emptySet());
        AdminApiHandler.ApiResult result = handler.handleResponse(this.coordinator, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (AbstractResponse)new ConsumerGroupDescribeResponse(new ConsumerGroupDescribeResponseData().setGroups(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id1").setGroupState("Stable").setGroupEpoch(10).setAssignmentEpoch(10).setAssignorName("range").setAuthorizedOperations(Utils.to32BitField(Collections.emptySet())).setMembers(Collections.singletonList(new ConsumerGroupDescribeResponseData.Member().setMemberId("memberId").setInstanceId("instanceId").setClientHost("host").setClientId("clientId").setMemberEpoch(10).setRackId("rackid").setSubscribedTopicNames(Collections.singletonList("foo")).setSubscribedTopicRegex("regex").setAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("foo").setPartitions(Collections.singletonList(0)), new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("bar").setPartitions(Collections.singletonList(1))))).setTargetAssignment(new ConsumerGroupDescribeResponseData.Assignment().setTopicPartitions(Arrays.asList(new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("foo").setPartitions(Collections.singletonList(1)), new ConsumerGroupDescribeResponseData.TopicPartitions().setTopicId(Uuid.randomUuid()).setTopicName("bar").setPartitions(Collections.singletonList(2)))))))))));
        this.assertCompleted((AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription>)result, expected);
    }

    @Test
    public void testSuccessfulHandleClassicGroupResponse() {
        List<MemberDescription> members = Collections.singletonList(new MemberDescription("memberId", "clientId", "host", new MemberAssignment(this.tps)));
        ConsumerGroupDescription expected = new ConsumerGroupDescription("group-id1", true, members, "assignor", ConsumerGroupState.STABLE, this.coordinator);
        this.assertCompleted(this.handleClassicGroupWithError(Errors.NONE, ""), expected);
    }

    @Test
    public void testUnmappedHandleClassicGroupResponse() {
        this.assertUnmapped(this.handleClassicGroupWithError(Errors.COORDINATOR_NOT_AVAILABLE, ""));
        this.assertUnmapped(this.handleClassicGroupWithError(Errors.NOT_COORDINATOR, ""));
    }

    @Test
    public void testRetriableHandleClassicGroupResponse() {
        this.assertRetriable(this.handleClassicGroupWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS, ""));
    }

    @Test
    public void testFailedHandleClassicGroupResponse() {
        this.assertFailed(UnsupportedVersionException.class, this.handleClassicGroupWithError(Errors.UNSUPPORTED_VERSION, ""));
        this.assertFailed(GroupAuthorizationException.class, this.handleClassicGroupWithError(Errors.GROUP_AUTHORIZATION_FAILED, ""));
        this.assertFailed(GroupIdNotFoundException.class, this.handleClassicGroupWithError(Errors.GROUP_ID_NOT_FOUND, ""));
        this.assertFailed(InvalidGroupIdException.class, this.handleClassicGroupWithError(Errors.INVALID_GROUP_ID, ""));
        this.assertFailed(IllegalArgumentException.class, this.handleClassicGroupWithError(Errors.NONE, "custom-protocol"));
    }

    @Test
    public void testUnmappedHandleConsumerGroupResponse() {
        this.assertUnmapped(this.handleConsumerGroupWithError(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertUnmapped(this.handleConsumerGroupWithError(Errors.NOT_COORDINATOR));
    }

    @Test
    public void testRetriableHandleConsumerGroupResponse() {
        this.assertRetriable(this.handleConsumerGroupWithError(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.assertRetriable(this.handleConsumerGroupWithError(Errors.GROUP_ID_NOT_FOUND));
        this.assertRetriable(this.handleConsumerGroupWithError(Errors.UNSUPPORTED_VERSION));
    }

    @Test
    public void testFailedHandleConsumerGroupResponse() {
        this.assertFailed(GroupAuthorizationException.class, this.handleConsumerGroupWithError(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFailed(InvalidGroupIdException.class, this.handleConsumerGroupWithError(Errors.INVALID_GROUP_ID));
    }

    private ConsumerGroupDescribeResponse buildConsumerGroupDescribeResponse(Errors error) {
        return new ConsumerGroupDescribeResponse(new ConsumerGroupDescribeResponseData().setGroups(Collections.singletonList(new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId("group-id1").setErrorCode(error.code()))));
    }

    private DescribeGroupsResponse buildResponse(Errors error, String protocolType) {
        DescribeGroupsResponse response = new DescribeGroupsResponse(new DescribeGroupsResponseData().setGroups(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroup().setErrorCode(error.code()).setGroupId("group-id1").setGroupState(ConsumerGroupState.STABLE.toString()).setProtocolType(protocolType).setProtocolData("assignor").setAuthorizedOperations(Utils.to32BitField(Collections.emptySet())).setMembers(Collections.singletonList(new DescribeGroupsResponseData.DescribedGroupMember().setClientHost("host").setClientId("clientId").setMemberId("memberId").setMemberAssignment(ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment(new ArrayList<TopicPartition>(this.tps))).array()))))));
        return response;
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> handleClassicGroupWithError(Errors error, String protocolType) {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(true, this.logContext);
        DescribeGroupsResponse response = this.buildResponse(error, protocolType);
        return handler.handleResponse(this.coordinator, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (AbstractResponse)response);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> handleConsumerGroupWithError(Errors error) {
        DescribeConsumerGroupsHandler handler = new DescribeConsumerGroupsHandler(true, this.logContext);
        ConsumerGroupDescribeResponse response = this.buildConsumerGroupDescribeResponse(error);
        return handler.handleResponse(this.coordinator, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id1")), (AbstractResponse)response);
    }

    private void assertUnmapped(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id1")), (Object)result.unmappedKeys);
    }

    private void assertRetriable(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result, ConsumerGroupDescription expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals((Object)expected, result.completedKeys.get(CoordinatorKey.byGroupId((String)"group-id1")));
    }

    private void assertFailed(Class<? extends Throwable> expectedExceptionType, AdminApiHandler.ApiResult<CoordinatorKey, ConsumerGroupDescription> result) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id1");
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.failedKeys.keySet());
        Assertions.assertTrue((boolean)expectedExceptionType.isInstance(result.failedKeys.get(key)));
    }

    private void assertRequestAndKeys(AdminApiHandler.RequestAndKeys<CoordinatorKey> requestAndKeys, Set<CoordinatorKey> expectedKeys, ApiMessage expectedRequest) {
        Assertions.assertEquals(expectedKeys, (Object)requestAndKeys.keys);
        Assertions.assertEquals((Object)expectedRequest, (Object)requestAndKeys.request.build().data());
    }
}

