/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkThread;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerInvoker;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.MembershipManagerImpl;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetCommitCallbackInvoker;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.metrics.RebalanceCallbackMetricsManager;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.mockito.Mockito;

public class ConsumerTestBuilder
implements Closeable {
    static final long DEFAULT_RETRY_BACKOFF_MS = 80L;
    static final long DEFAULT_RETRY_BACKOFF_MAX_MS = 1000L;
    static final int DEFAULT_REQUEST_TIMEOUT_MS = 500;
    static final int DEFAULT_MAX_POLL_INTERVAL_MS = 10000;
    static final String DEFAULT_GROUP_INSTANCE_ID = "group-instance-id";
    static final String DEFAULT_GROUP_ID = "group-id";
    static final int DEFAULT_HEARTBEAT_INTERVAL_MS = 1000;
    static final double DEFAULT_HEARTBEAT_JITTER_MS = 0.0;
    static final String DEFAULT_REMOTE_ASSIGNOR = "uniform";
    final LogContext logContext = new LogContext();
    final Time time;
    public final BlockingQueue<ApplicationEvent> applicationEventQueue;
    public final BlockingQueue<BackgroundEvent> backgroundEventQueue;
    final ConsumerConfig config;
    final long retryBackoffMs;
    final SubscriptionState subscriptions;
    final ConsumerMetadata metadata;
    final FetchConfig fetchConfig;
    final FetchBuffer fetchBuffer;
    final Metrics metrics;
    final Timer pollTimer;
    final FetchMetricsManager metricsManager;
    final NetworkClientDelegate networkClientDelegate;
    final OffsetsRequestManager offsetsRequestManager;
    final Optional<CoordinatorRequestManager> coordinatorRequestManager;
    final Optional<CommitRequestManager> commitRequestManager;
    final Optional<HeartbeatRequestManager> heartbeatRequestManager;
    final Optional<MembershipManager> membershipManager;
    final Optional<HeartbeatRequestManager.HeartbeatState> heartbeatState;
    final Optional<HeartbeatRequestManager.HeartbeatRequestState> heartbeatRequestState;
    final TopicMetadataRequestManager topicMetadataRequestManager;
    final FetchRequestManager fetchRequestManager;
    final RequestManagers requestManagers;
    public final ApplicationEventProcessor applicationEventProcessor;
    public final BackgroundEventHandler backgroundEventHandler;
    public final ConsumerRebalanceListenerInvoker rebalanceListenerInvoker;
    final MockClient client;
    final Optional<GroupInformation> groupInfo;
    final OffsetCommitCallbackInvoker offsetCommitCallbackInvoker;

    public ConsumerTestBuilder(Optional<GroupInformation> groupInfo) {
        this(groupInfo, true, true);
    }

    public ConsumerTestBuilder(Optional<GroupInformation> groupInfo, boolean enableAutoCommit, boolean enableAutoTick) {
        this.groupInfo = groupInfo;
        this.time = enableAutoTick ? new MockTime(1L) : new MockTime();
        this.applicationEventQueue = new LinkedBlockingQueue<ApplicationEvent>();
        this.backgroundEventQueue = new LinkedBlockingQueue<BackgroundEvent>();
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.spy((Object)new BackgroundEventHandler(this.logContext, this.backgroundEventQueue));
        this.offsetCommitCallbackInvoker = (OffsetCommitCallbackInvoker)Mockito.mock(OffsetCommitCallbackInvoker.class);
        GroupRebalanceConfig groupRebalanceConfig = new GroupRebalanceConfig(100, 10000, 1000, (String)groupInfo.map(gi -> gi.groupId).orElse(null), groupInfo.flatMap(gi -> gi.groupInstanceId), 80L, 1000L, true);
        ApiVersions apiVersions = new ApiVersions();
        Properties properties = new Properties();
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.put("retry.backoff.ms", (Object)80L);
        properties.put("request.timeout.ms", (Object)500);
        properties.put("max.poll.interval.ms", (Object)10000);
        if (!enableAutoCommit) {
            properties.put("enable.auto.commit", "false");
        }
        groupInfo.ifPresent(gi -> {
            properties.put("group.id", gi.groupId);
            gi.groupInstanceId.ifPresent(groupInstanceId -> properties.put("group.instance.id", groupInstanceId));
        });
        this.config = new ConsumerConfig(properties);
        this.fetchConfig = new FetchConfig(this.config);
        this.retryBackoffMs = this.config.getLong("retry.backoff.ms");
        long requestTimeoutMs = this.config.getInt("request.timeout.ms").intValue();
        this.metrics = ConsumerUtils.createMetrics((ConsumerConfig)this.config, (Time)this.time);
        this.subscriptions = (SubscriptionState)Mockito.spy((Object)ConsumerUtils.createSubscriptionState((ConsumerConfig)this.config, (LogContext)this.logContext));
        this.metadata = (ConsumerMetadata)Mockito.spy((Object)new ConsumerMetadata(this.config, this.subscriptions, this.logContext, new ClusterResourceListeners()));
        this.metricsManager = ConsumerUtils.createFetchMetricsManager((Metrics)this.metrics);
        this.pollTimer = this.time.timer((long)groupRebalanceConfig.rebalanceTimeoutMs);
        this.client = new MockClient(this.time, (Metadata)this.metadata);
        MetadataResponse metadataResponse = RequestTestUtils.metadataUpdateWith(1, (Map<String, Integer>)new HashMap<String, Integer>(){
            {
                String topic1 = "test1";
                this.put(topic1, 1);
                String topic2 = "test2";
                this.put(topic2, 1);
            }
        });
        this.client.updateMetadata(metadataResponse);
        this.networkClientDelegate = (NetworkClientDelegate)Mockito.spy((Object)new NetworkClientDelegate(this.time, this.config, this.logContext, (KafkaClient)this.client));
        this.offsetsRequestManager = (OffsetsRequestManager)Mockito.spy((Object)new OffsetsRequestManager(this.subscriptions, this.metadata, this.fetchConfig.isolationLevel, this.time, this.retryBackoffMs, requestTimeoutMs, apiVersions, this.networkClientDelegate, this.backgroundEventHandler, this.logContext));
        this.topicMetadataRequestManager = (TopicMetadataRequestManager)Mockito.spy((Object)new TopicMetadataRequestManager(this.logContext, this.config));
        if (groupInfo.isPresent()) {
            GroupInformation gi2 = groupInfo.get();
            CoordinatorRequestManager coordinator = (CoordinatorRequestManager)Mockito.spy((Object)new CoordinatorRequestManager(this.time, this.logContext, 80L, 1000L, this.backgroundEventHandler, gi2.groupId));
            CommitRequestManager commit = (CommitRequestManager)Mockito.spy((Object)new CommitRequestManager(this.time, this.logContext, this.subscriptions, this.config, coordinator, this.offsetCommitCallbackInvoker, gi2.groupId, gi2.groupInstanceId, this.metrics));
            MembershipManager mm = (MembershipManager)Mockito.spy((Object)new MembershipManagerImpl(gi2.groupId, gi2.groupInstanceId, groupRebalanceConfig.rebalanceTimeoutMs, gi2.serverAssignor, this.subscriptions, commit, this.metadata, this.logContext, this.backgroundEventHandler, this.time, Optional.empty()));
            HeartbeatRequestManager.HeartbeatState heartbeatState = (HeartbeatRequestManager.HeartbeatState)Mockito.spy((Object)new HeartbeatRequestManager.HeartbeatState(this.subscriptions, mm, 10000));
            HeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState = (HeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new HeartbeatRequestManager.HeartbeatRequestState(this.logContext, this.time, (long)gi2.heartbeatIntervalMs, this.retryBackoffMs, 1000L, gi2.heartbeatJitterMs));
            HeartbeatRequestManager heartbeat = (HeartbeatRequestManager)Mockito.spy((Object)new HeartbeatRequestManager(this.logContext, this.pollTimer, this.config, coordinator, mm, heartbeatState, heartbeatRequestState, this.backgroundEventHandler, this.metrics));
            this.coordinatorRequestManager = Optional.of(coordinator);
            this.commitRequestManager = Optional.of(commit);
            this.heartbeatRequestManager = Optional.of(heartbeat);
            this.heartbeatState = Optional.of(heartbeatState);
            this.heartbeatRequestState = Optional.of(heartbeatRequestState);
            this.membershipManager = Optional.of(mm);
        } else {
            this.coordinatorRequestManager = Optional.empty();
            this.commitRequestManager = Optional.empty();
            this.heartbeatRequestManager = Optional.empty();
            this.heartbeatState = Optional.empty();
            this.heartbeatRequestState = Optional.empty();
            this.membershipManager = Optional.empty();
        }
        this.fetchBuffer = new FetchBuffer(this.logContext);
        this.fetchRequestManager = (FetchRequestManager)Mockito.spy((Object)new FetchRequestManager(this.logContext, this.time, this.metadata, this.subscriptions, this.fetchConfig, this.fetchBuffer, this.metricsManager, this.networkClientDelegate, apiVersions));
        this.requestManagers = new RequestManagers(this.logContext, this.offsetsRequestManager, this.topicMetadataRequestManager, this.fetchRequestManager, this.coordinatorRequestManager, this.commitRequestManager, this.heartbeatRequestManager, this.membershipManager);
        this.applicationEventProcessor = (ApplicationEventProcessor)Mockito.spy((Object)new ApplicationEventProcessor(this.logContext, this.applicationEventQueue, this.requestManagers, this.metadata));
        this.rebalanceListenerInvoker = new ConsumerRebalanceListenerInvoker(this.logContext, this.subscriptions, this.time, new RebalanceCallbackMetricsManager(this.metrics));
    }

    @Override
    public void close() {
        Utils.closeQuietly((AutoCloseable)this.requestManagers, (String)RequestManagers.class.getSimpleName());
        Utils.closeQuietly((AutoCloseable)this.applicationEventProcessor, (String)ApplicationEventProcessor.class.getSimpleName());
    }

    static Optional<GroupInformation> createDefaultGroupInformation() {
        return Optional.of(new GroupInformation(DEFAULT_GROUP_ID, Optional.empty()));
    }

    public static class GroupInformation {
        final String groupId;
        final Optional<String> groupInstanceId;
        final int heartbeatIntervalMs;
        final double heartbeatJitterMs;
        final Optional<String> serverAssignor;

        public GroupInformation(String groupId, Optional<String> groupInstanceId) {
            this(groupId, groupInstanceId, 1000, 0.0, Optional.of(ConsumerTestBuilder.DEFAULT_REMOTE_ASSIGNOR));
        }

        public GroupInformation(String groupId, Optional<String> groupInstanceId, int heartbeatIntervalMs, double heartbeatJitterMs, Optional<String> serverAssignor) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
            this.heartbeatJitterMs = heartbeatJitterMs;
            this.serverAssignor = serverAssignor;
            this.groupId = groupId;
            this.groupInstanceId = groupInstanceId;
        }
    }

    public static class ConsumerNetworkThreadTestBuilder
    extends ConsumerTestBuilder {
        final ConsumerNetworkThread consumerNetworkThread;

        public ConsumerNetworkThreadTestBuilder() {
            this(ConsumerNetworkThreadTestBuilder.createDefaultGroupInformation());
        }

        public ConsumerNetworkThreadTestBuilder(Optional<GroupInformation> groupInfo) {
            super(groupInfo);
            this.consumerNetworkThread = new ConsumerNetworkThread(this.logContext, this.time, () -> this.applicationEventProcessor, () -> this.networkClientDelegate, () -> this.requestManagers);
        }

        @Override
        public void close() {
            this.consumerNetworkThread.close(Duration.ZERO);
        }
    }
}

