/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.GroupMetadataUpdateEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HeartbeatRequestManagerTest {
    private long retryBackoffMs = 80L;
    private int heartbeatIntervalMs = 1000;
    private int maxPollIntervalMs = 10000;
    private long retryBackoffMaxMs = 1000L;
    private static final String DEFAULT_GROUP_ID = "groupId";
    private static final String CONSUMER_COORDINATOR_METRICS = "consumer-coordinator-metrics";
    private ConsumerTestBuilder testBuilder;
    private Time time;
    private Timer pollTimer;
    private CoordinatorRequestManager coordinatorRequestManager;
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private HeartbeatRequestManager heartbeatRequestManager;
    private MembershipManager membershipManager;
    private HeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState;
    private HeartbeatRequestManager.HeartbeatState heartbeatState;
    private final String memberId = "member-id";
    private final int memberEpoch = 1;
    private BackgroundEventHandler backgroundEventHandler;
    private BlockingQueue<BackgroundEvent> backgroundEventQueue;
    private Metrics metrics;

    @BeforeEach
    public void setUp() {
        this.setUp(ConsumerTestBuilder.createDefaultGroupInformation());
    }

    private void setUp(Optional<ConsumerTestBuilder.GroupInformation> groupInfo) {
        this.testBuilder = new ConsumerTestBuilder(groupInfo, true, false);
        this.time = this.testBuilder.time;
        this.coordinatorRequestManager = this.testBuilder.coordinatorRequestManager.orElseThrow(IllegalStateException::new);
        this.heartbeatRequestManager = this.testBuilder.heartbeatRequestManager.orElseThrow(IllegalStateException::new);
        this.heartbeatRequestState = this.testBuilder.heartbeatRequestState.orElseThrow(IllegalStateException::new);
        this.heartbeatState = this.testBuilder.heartbeatState.orElseThrow(IllegalStateException::new);
        this.backgroundEventHandler = this.testBuilder.backgroundEventHandler;
        this.backgroundEventQueue = this.testBuilder.backgroundEventQueue;
        this.subscriptions = this.testBuilder.subscriptions;
        this.membershipManager = this.testBuilder.membershipManager.orElseThrow(IllegalStateException::new);
        this.metadata = this.testBuilder.metadata;
        this.metrics = new Metrics(this.time);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
    }

    private void resetWithZeroHeartbeatInterval(Optional<String> groupInstanceId) {
        this.cleanup();
        ConsumerTestBuilder.GroupInformation gi = new ConsumerTestBuilder.GroupInformation(DEFAULT_GROUP_ID, groupInstanceId, 0, 0.0, Optional.of("uniform"));
        this.setUp(Optional.of(gi));
    }

    @AfterEach
    public void cleanup() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
        }
    }

    @Test
    public void testHeartbeatOnStartup() {
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.PollResult result2 = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result2.unsentRequests.size());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testFirstHeartbeatIncludesRequiredInfoToJoinGroupAndGetAssignments(short version) {
        this.resetWithZeroHeartbeatInterval(Optional.of("group-instance-id"));
        String topic = "topic1";
        this.subscriptions.subscribe(Collections.singleton(topic), Optional.empty());
        this.membershipManager.onSubscriptionUpdated();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertTrue((boolean)(request.requestBuilder() instanceof ConsumerGroupHeartbeatRequest.Builder));
        ConsumerGroupHeartbeatRequest heartbeatRequest = (ConsumerGroupHeartbeatRequest)request.requestBuilder().build(version);
        Assertions.assertTrue((boolean)heartbeatRequest.data().memberId().isEmpty());
        Assertions.assertEquals((int)0, (int)heartbeatRequest.data().memberEpoch());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)heartbeatRequest.data().subscribedTopicNames());
        Assertions.assertEquals((int)10000, (int)heartbeatRequest.data().rebalanceTimeoutMs());
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)heartbeatRequest.data().groupId());
        Assertions.assertEquals((Object)"group-instance-id", (Object)heartbeatRequest.data().instanceId());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSkippingHeartbeat(boolean shouldSkipHeartbeat) {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)shouldSkipHeartbeat);
        Mockito.when((Object)this.heartbeatRequestState.canSendRequest(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        if (!shouldSkipHeartbeat) {
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)0L, (long)result.timeUntilNextPollMs);
        } else {
            Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        }
    }

    @Test
    public void testTimerNotDue() {
        this.mockStableMember();
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)900L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)900L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.membershipManager.transitionToFatal();
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
    }

    @Test
    public void testHeartbeatOutsideInterval() {
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.shouldHeartbeatNow()).thenReturn((Object)true);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)1000L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatRequestSent();
    }

    @Test
    public void testNetworkTimeout() {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)((Object)new TimeoutException("timeout")));
        this.time.sleep(79L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.time.sleep(1L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
    }

    @Test
    public void testFailureOnFatalException() {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)((Object)new KafkaException("fatal")));
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)ArgumentMatchers.any());
    }

    @Test
    public void testNoCoordinator() {
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.empty());
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testValidateConsumerGroupHeartbeatRequest(short version) {
        this.resetWithZeroHeartbeatInterval(Optional.of("group-instance-id"));
        this.mockStableMember();
        List<String> subscribedTopics = Collections.singletonList("topic");
        this.subscriptions.subscribe(new HashSet<String>(subscribedTopics), Optional.empty());
        ConsumerGroupHeartbeatResponse result = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setMemberId("member-id").setMemberEpoch(1));
        this.membershipManager.onHeartbeatResponseReceived(result.data());
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertTrue((boolean)(request.requestBuilder() instanceof ConsumerGroupHeartbeatRequest.Builder));
        ConsumerGroupHeartbeatRequest heartbeatRequest = (ConsumerGroupHeartbeatRequest)request.requestBuilder().build(version);
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)heartbeatRequest.data().groupId());
        Assertions.assertEquals((Object)"member-id", (Object)heartbeatRequest.data().memberId());
        Assertions.assertEquals((int)1, (int)heartbeatRequest.data().memberEpoch());
        Assertions.assertEquals((int)10000, (int)heartbeatRequest.data().rebalanceTimeoutMs());
        Assertions.assertEquals(subscribedTopics, (Object)heartbeatRequest.data().subscribedTopicNames());
        Assertions.assertEquals((Object)"group-instance-id", (Object)heartbeatRequest.data().instanceId());
        Assertions.assertEquals((Object)"uniform", (Object)heartbeatRequest.data().serverAssignor());
    }

    @Test
    public void testConsumerGroupMetadataFirstUpdate() {
        GroupMetadataUpdateEvent groupMetadataUpdateEvent = this.makeFirstGroupMetadataUpdate("member-id", 1);
        GroupMetadataUpdateEvent expectedGroupMetadataUpdateEvent = new GroupMetadataUpdateEvent(1, "member-id");
        Assertions.assertEquals((Object)expectedGroupMetadataUpdateEvent, (Object)groupMetadataUpdateEvent);
    }

    @Test
    public void testConsumerGroupMetadataUpdateWithSameUpdate() {
        this.makeFirstGroupMetadataUpdate("member-id", 1);
        this.time.sleep(2000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        ClientResponse responseWithSameUpdate = this.createHeartbeatResponse(request, Errors.NONE);
        request.handler().onComplete(responseWithSameUpdate);
        Assertions.assertEquals((int)0, (int)this.backgroundEventQueue.size());
    }

    @Test
    public void testConsumerGroupMetadataUpdateWithMemberIdNullButMemberEpochUpdated() {
        this.makeFirstGroupMetadataUpdate("member-id", 1);
        this.time.sleep(2000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        int updatedMemberEpoch = 2;
        ClientResponse responseWithMemberEpochUpdate = this.createHeartbeatResponseWithMemberIdNull(request, Errors.NONE, 2);
        request.handler().onComplete(responseWithMemberEpochUpdate);
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        BackgroundEvent eventWithUpdatedMemberEpoch = (BackgroundEvent)this.backgroundEventQueue.poll();
        Assertions.assertEquals((Object)BackgroundEvent.Type.GROUP_METADATA_UPDATE, (Object)eventWithUpdatedMemberEpoch.type());
        GroupMetadataUpdateEvent groupMetadataUpdateEvent = (GroupMetadataUpdateEvent)eventWithUpdatedMemberEpoch;
        GroupMetadataUpdateEvent expectedGroupMetadataUpdateEvent = new GroupMetadataUpdateEvent(2, "member-id");
        Assertions.assertEquals((Object)expectedGroupMetadataUpdateEvent, (Object)groupMetadataUpdateEvent);
    }

    @Test
    public void testConsumerGroupMetadataUpdateWithMemberIdUpdatedAndMemberEpochSame() {
        this.makeFirstGroupMetadataUpdate("member-id", 1);
        this.time.sleep(2000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        String updatedMemberId = "updatedMemberId";
        ClientResponse responseWithMemberIdUpdate = this.createHeartbeatResponse(request, Errors.NONE, "updatedMemberId", 1);
        request.handler().onComplete(responseWithMemberIdUpdate);
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        BackgroundEvent eventWithUpdatedMemberEpoch = (BackgroundEvent)this.backgroundEventQueue.poll();
        Assertions.assertEquals((Object)BackgroundEvent.Type.GROUP_METADATA_UPDATE, (Object)eventWithUpdatedMemberEpoch.type());
        GroupMetadataUpdateEvent groupMetadataUpdateEvent = (GroupMetadataUpdateEvent)eventWithUpdatedMemberEpoch;
        GroupMetadataUpdateEvent expectedGroupMetadataUpdateEvent = new GroupMetadataUpdateEvent(1, "updatedMemberId");
        Assertions.assertEquals((Object)expectedGroupMetadataUpdateEvent, (Object)groupMetadataUpdateEvent);
    }

    private GroupMetadataUpdateEvent makeFirstGroupMetadataUpdate(String memberId, int memberEpoch) {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        ClientResponse firstResponse = this.createHeartbeatResponse(request, Errors.NONE, memberId, memberEpoch);
        request.handler().onComplete(firstResponse);
        Assertions.assertEquals((int)1, (int)this.backgroundEventQueue.size());
        BackgroundEvent event = (BackgroundEvent)this.backgroundEventQueue.poll();
        Assertions.assertEquals((Object)BackgroundEvent.Type.GROUP_METADATA_UPDATE, (Object)event.type());
        return (GroupMetadataUpdateEvent)event;
    }

    @ParameterizedTest
    @MethodSource(value={"errorProvider"})
    public void testHeartbeatResponseOnErrorHandling(Errors error, boolean isFatal) {
        this.mockStableMember();
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ClientResponse response = this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0), error);
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onComplete(response);
        ConsumerGroupHeartbeatResponse mockResponse = (ConsumerGroupHeartbeatResponse)response.responseBody();
        switch (error) {
            case NONE: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)ArgumentMatchers.any(GroupMetadataUpdateEvent.class));
                ((MembershipManager)Mockito.verify((Object)this.membershipManager, (VerificationMode)Mockito.times((int)2))).onHeartbeatResponseReceived(mockResponse.data());
                Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestState.nextHeartbeatMs(this.time.milliseconds()));
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                Assertions.assertEquals((long)80L, (long)this.heartbeatRequestState.nextHeartbeatMs(this.time.milliseconds()), (String)"Request should backoff after receiving a coordinator load in progress error. ");
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                ((CoordinatorRequestManager)Mockito.verify((Object)this.coordinatorRequestManager)).markCoordinatorUnknown((String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
                Assertions.assertEquals((long)0L, (long)this.heartbeatRequestState.nextHeartbeatMs(this.time.milliseconds()), (String)"Request should not apply backoff so that the next heartbeat is sent as soon as the new coordinator is discovered.");
                break;
            }
            case UNKNOWN_MEMBER_ID: 
            case FENCED_MEMBER_EPOCH: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                Assertions.assertEquals((long)0L, (long)this.heartbeatRequestState.nextHeartbeatMs(this.time.milliseconds()), (String)"Request should not apply backoff so that the next heartbeat to rejoin is sent as soon as the fenced member releases its assignment.");
                break;
            }
            default: {
                if (isFatal) {
                    this.ensureFatalError();
                    break;
                }
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                Assertions.assertEquals((long)0L, (long)this.heartbeatRequestState.nextHeartbeatMs(this.time.milliseconds()));
            }
        }
        if (!isFatal) {
            this.time.sleep(1000L);
            result = this.heartbeatRequestManager.poll(this.time.milliseconds());
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        }
    }

    @Test
    public void testHeartbeatState() {
        ConsumerGroupHeartbeatRequestData data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)10000, (int)data.rebalanceTimeoutMs());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.subscribedTopicNames());
        Assertions.assertEquals((Object)"uniform", (Object)data.serverAssignor());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)this.membershipManager.state());
        this.mockStableMember();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"member-id", (Object)data.memberId());
        Assertions.assertEquals((int)1, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)-1, (int)data.rebalanceTimeoutMs());
        Assertions.assertNull((Object)data.subscribedTopicNames());
        Assertions.assertNull((Object)data.serverAssignor());
        Assertions.assertNull((Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)this.membershipManager.state());
        String topic = "topic1";
        this.subscriptions.subscribe(Collections.singleton(topic), Optional.empty());
        this.membershipManager.onSubscriptionUpdated();
        this.membershipManager.transitionToFenced();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"member-id", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)-1, (int)data.rebalanceTimeoutMs());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)data.subscribedTopicNames());
        Assertions.assertNull((Object)data.serverAssignor());
        Assertions.assertNull((Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)this.membershipManager.state());
        ConsumerGroupHeartbeatResponseData.TopicPartitions tpTopic1 = new ConsumerGroupHeartbeatResponseData.TopicPartitions();
        Uuid topicId = Uuid.randomUuid();
        tpTopic1.setTopicId(topicId);
        tpTopic1.setPartitions(Collections.singletonList(0));
        ConsumerGroupHeartbeatResponseData.Assignment assignmentTopic1 = new ConsumerGroupHeartbeatResponseData.Assignment();
        assignmentTopic1.setTopicPartitions(Collections.singletonList(tpTopic1));
        ConsumerGroupHeartbeatResponse rs1 = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setHeartbeatIntervalMs(1000).setMemberId("member-id").setMemberEpoch(1).setAssignment(assignmentTopic1));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, "topic1"));
        this.membershipManager.onHeartbeatResponseReceived(rs1.data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)this.membershipManager.state());
    }

    @Test
    public void testPollTimerExpiration() {
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        this.heartbeatState = (HeartbeatRequestManager.HeartbeatState)Mockito.mock(HeartbeatRequestManager.HeartbeatState.class);
        this.heartbeatRequestState = (HeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new HeartbeatRequestManager.HeartbeatRequestState(new LogContext(), this.time, (long)this.heartbeatIntervalMs, this.retryBackoffMs, this.retryBackoffMaxMs, 0.0));
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.STABLE);
        this.time.sleep((long)this.maxPollIntervalMs);
        this.assertHeartbeat(this.heartbeatRequestManager, this.heartbeatIntervalMs);
        ((HeartbeatRequestManager.HeartbeatState)Mockito.verify((Object)this.heartbeatState)).reset();
        ((HeartbeatRequestManager.HeartbeatRequestState)Mockito.verify((Object)this.heartbeatRequestState)).reset();
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToStale();
        this.assertNoHeartbeat(this.heartbeatRequestManager);
        this.heartbeatRequestManager.resetPollTimer(this.time.milliseconds());
        Assertions.assertTrue((boolean)this.pollTimer.notExpired());
        this.assertHeartbeat(this.heartbeatRequestManager, this.heartbeatIntervalMs);
    }

    @Test
    public void testHeartbeatMetrics() {
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        this.heartbeatState = (HeartbeatRequestManager.HeartbeatState)Mockito.mock(HeartbeatRequestManager.HeartbeatState.class);
        this.time = new MockTime();
        this.metrics = new Metrics(this.time);
        this.heartbeatRequestState = new HeartbeatRequestManager.HeartbeatRequestState(new LogContext(), this.time, 0L, this.retryBackoffMs, this.retryBackoffMaxMs, 0.0);
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.STABLE);
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-response-time-max"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-rate"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-total"));
        Assertions.assertNotNull((Object)this.getMetric("last-heartbeat-seconds-ago"));
        this.assertHeartbeat(this.heartbeatRequestManager, 0);
        this.time.sleep((long)this.heartbeatIntervalMs);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Assertions.assertEquals((Object)TimeUnit.MILLISECONDS.toSeconds(this.heartbeatIntervalMs), (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
        this.assertHeartbeat(this.heartbeatRequestManager, this.heartbeatIntervalMs);
        Assertions.assertEquals((double)0.06, (double)((Double)this.getMetric("heartbeat-rate").metricValue()), (double)0.005);
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Random rand = new Random();
        int randomSleepS = rand.nextInt(11);
        this.time.sleep((long)(randomSleepS * 1000));
        Assertions.assertEquals((Object)randomSleepS, (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
    }

    private void assertHeartbeat(HeartbeatRequestManager hrm, int nextPollMs) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        Assertions.assertEquals((long)nextPollMs, (long)pollResult.timeUntilNextPollMs);
        ((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0)).handler().onComplete(this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0), Errors.NONE));
    }

    private void assertNoHeartbeat(HeartbeatRequestManager hrm) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)pollResult.unsentRequests.size());
    }

    private void mockStableMember() {
        this.membershipManager.onSubscriptionUpdated();
        ConsumerGroupHeartbeatResponse rs1 = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setHeartbeatIntervalMs(1000).setMemberId("member-id").setMemberEpoch(1));
        this.membershipManager.onHeartbeatResponseReceived(rs1.data());
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)this.membershipManager.state());
    }

    private void ensureFatalError() {
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)ArgumentMatchers.any());
        this.ensureHeartbeatStopped();
    }

    private void ensureHeartbeatStopped() {
        this.time.sleep(1000L);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)this.membershipManager.state());
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    private static Collection<Arguments> errorProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Errors.NONE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_NOT_AVAILABLE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_LOAD_IN_PROGRESS, false}), Arguments.of((Object[])new Object[]{Errors.NOT_COORDINATOR, false}), Arguments.of((Object[])new Object[]{Errors.GROUP_AUTHORIZATION_FAILED, true}), Arguments.of((Object[])new Object[]{Errors.INVALID_REQUEST, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_MEMBER_ID, false}), Arguments.of((Object[])new Object[]{Errors.FENCED_MEMBER_EPOCH, false}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_ASSIGNOR, true}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_VERSION, true}), Arguments.of((Object[])new Object[]{Errors.UNRELEASED_INSTANCE_ID, true}), Arguments.of((Object[])new Object[]{Errors.GROUP_MAX_SIZE_REACHED, true}));
    }

    private ClientResponse createHeartbeatResponse(NetworkClientDelegate.UnsentRequest request, Errors error) {
        return this.createHeartbeatResponse(request, error, "member-id", 1);
    }

    private ClientResponse createHeartbeatResponseWithMemberIdNull(NetworkClientDelegate.UnsentRequest request, Errors error, int memberEpoch) {
        return this.createHeartbeatResponse(request, error, null, memberEpoch);
    }

    private ClientResponse createHeartbeatResponse(NetworkClientDelegate.UnsentRequest request, Errors error, String memberId, int memberEpoch) {
        ConsumerGroupHeartbeatResponseData data = new ConsumerGroupHeartbeatResponseData().setErrorCode(error.code()).setHeartbeatIntervalMs(1000).setMemberId(memberId).setMemberEpoch(memberEpoch);
        if (error != Errors.NONE) {
            data.setErrorMessage("stubbed error message");
        }
        ConsumerGroupHeartbeatResponse response = new ConsumerGroupHeartbeatResponse(data);
        return new ClientResponse(new RequestHeader(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion(), "client-id", 1), (RequestCompletionHandler)request.handler(), "0", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)response);
    }

    private ConsumerConfig config() {
        Properties prop = new Properties();
        prop.put("key.deserializer", StringDeserializer.class);
        prop.put("value.deserializer", StringDeserializer.class);
        prop.setProperty("bootstrap.servers", "localhost:9999");
        prop.setProperty("max.poll.interval.ms", String.valueOf(this.maxPollIntervalMs));
        prop.setProperty("retry.backoff.ms", String.valueOf(this.retryBackoffMs));
        prop.setProperty("retry.backoff.max.ms", String.valueOf(this.retryBackoffMaxMs));
        prop.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatIntervalMs));
        return new ConsumerConfig(prop);
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, CONSUMER_COORDINATOR_METRICS));
    }

    private HeartbeatRequestManager createHeartbeatRequestManager(CoordinatorRequestManager coordinatorRequestManager, MembershipManager membershipManager, HeartbeatRequestManager.HeartbeatState heartbeatState, HeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler) {
        LogContext logContext = new LogContext();
        this.pollTimer = this.time.timer((long)this.maxPollIntervalMs);
        return new HeartbeatRequestManager(logContext, this.pollTimer, this.config(), coordinatorRequestManager, membershipManager, heartbeatState, heartbeatRequestState, backgroundEventHandler, this.metrics);
    }
}

