/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.LeaveOnCloseApplicationEvent;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ApplicationEventProcessorTest {
    private ApplicationEventProcessor processor;
    private BlockingQueue applicationEventQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
    private RequestManagers requestManagers;
    private ConsumerMetadata metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
    private NetworkClientDelegate networkClientDelegate = (NetworkClientDelegate)Mockito.mock(NetworkClientDelegate.class);
    private OffsetsRequestManager offsetRequestManager;
    private OffsetsRequestManager offsetsRequestManager;
    private TopicMetadataRequestManager topicMetadataRequestManager;
    private FetchRequestManager fetchRequestManager;
    private CoordinatorRequestManager coordinatorRequestManager;
    private CommitRequestManager commitRequestManager;
    private HeartbeatRequestManager heartbeatRequestManager;
    private MembershipManager membershipManager;

    @BeforeEach
    public void setup() {
        LogContext logContext = new LogContext();
        this.offsetRequestManager = (OffsetsRequestManager)Mockito.mock(OffsetsRequestManager.class);
        this.offsetsRequestManager = (OffsetsRequestManager)Mockito.mock(OffsetsRequestManager.class);
        this.topicMetadataRequestManager = (TopicMetadataRequestManager)Mockito.mock(TopicMetadataRequestManager.class);
        this.fetchRequestManager = (FetchRequestManager)Mockito.mock(FetchRequestManager.class);
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.commitRequestManager = (CommitRequestManager)Mockito.mock(CommitRequestManager.class);
        this.heartbeatRequestManager = (HeartbeatRequestManager)Mockito.mock(HeartbeatRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        this.requestManagers = new RequestManagers(logContext, this.offsetsRequestManager, this.topicMetadataRequestManager, this.fetchRequestManager, Optional.of(this.coordinatorRequestManager), Optional.of(this.commitRequestManager), Optional.of(this.heartbeatRequestManager), Optional.of(this.membershipManager));
        this.processor = new ApplicationEventProcessor(new LogContext(), this.applicationEventQueue, this.requestManagers, this.metadata);
    }

    @Test
    public void testPrepClosingCommitEvents() {
        List<NetworkClientDelegate.UnsentRequest> results = this.mockCommitResults();
        ((CommitRequestManager)Mockito.doReturn((Object)new NetworkClientDelegate.PollResult(100L, results)).when((Object)this.commitRequestManager)).pollOnClose();
        this.processor.process((ApplicationEvent)new CommitOnCloseApplicationEvent());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager)).signalClose();
    }

    @Test
    public void testExpirationCalculation() {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.processor.getExpirationTimeForTimeout(Long.MAX_VALUE));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.processor.getExpirationTimeForTimeout(0x7FFFFFFFFFFFFFFEL));
        long timeout = this.processor.getExpirationTimeForTimeout(1000L);
        Assertions.assertTrue((timeout > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((timeout < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    @Test
    public void testPrepClosingLeaveGroupEvent() {
        LeaveOnCloseApplicationEvent event = new LeaveOnCloseApplicationEvent();
        Mockito.when((Object)this.heartbeatRequestManager.membershipManager()).thenReturn((Object)this.membershipManager);
        Mockito.when((Object)this.membershipManager.leaveGroup()).thenReturn(CompletableFuture.completedFuture(null));
        this.processor.process((ApplicationEvent)event);
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).leaveGroup();
        Assertions.assertTrue((boolean)event.future().isDone());
    }

    private List<NetworkClientDelegate.UnsentRequest> mockCommitResults() {
        return Collections.singletonList(Mockito.mock(NetworkClientDelegate.UnsentRequest.class));
    }
}

