/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.internals.metrics.HeartbeatMetricsManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HeartbeatMetricsManagerTest {
    private Time time = new MockTime();
    private Metrics metrics = new Metrics(this.time);

    @Test
    public void testHeartbeatMetrics() {
        HeartbeatMetricsManager heartbeatMetricsManager = new HeartbeatMetricsManager(this.metrics);
        Assertions.assertNotNull((Object)this.metrics.metric(heartbeatMetricsManager.heartbeatResponseTimeMax));
        Assertions.assertNotNull((Object)this.metrics.metric(heartbeatMetricsManager.heartbeatRate));
        Assertions.assertNotNull((Object)this.metrics.metric(heartbeatMetricsManager.heartbeatTotal));
        long currentTimeMs = this.time.milliseconds();
        heartbeatMetricsManager.recordHeartbeatSentMs(currentTimeMs);
        heartbeatMetricsManager.recordRequestLatency(100L);
        heartbeatMetricsManager.recordRequestLatency(103L);
        heartbeatMetricsManager.recordRequestLatency(102L);
        Assertions.assertEquals((Object)103.0, (Object)this.metrics.metric(heartbeatMetricsManager.heartbeatResponseTimeMax).metricValue());
        Assertions.assertEquals((double)0.1, (double)((Double)this.metrics.metric(heartbeatMetricsManager.heartbeatRate).metricValue()), (double)0.01);
        Assertions.assertEquals((Object)3.0, (Object)this.metrics.metric(heartbeatMetricsManager.heartbeatTotal).metricValue());
        Random rand = new Random();
        int randomSleepS = rand.nextInt(10) + 1;
        this.time.sleep(TimeUnit.SECONDS.toMillis(randomSleepS));
        Assertions.assertEquals((Object)randomSleepS, (Object)this.metrics.metric(heartbeatMetricsManager.lastHeartbeatSecondsAgo).metricValue());
    }
}

