/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import org.apache.kafka.clients.consumer.internals.metrics.OffsetCommitMetricsManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OffsetCommitMetricsManagerTest {
    private Time time = new MockTime();
    private Metrics metrics = new Metrics(this.time);

    @Test
    public void testOffsetCommitMetrics() {
        OffsetCommitMetricsManager metricsManager = new OffsetCommitMetricsManager(this.metrics);
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.commitLatencyAvg));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.commitLatencyMax));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.commitRate));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.commitTotal));
        metricsManager.recordRequestLatency(100L);
        metricsManager.recordRequestLatency(102L);
        metricsManager.recordRequestLatency(98L);
        Assertions.assertEquals((Object)100.0, (Object)this.metrics.metric(metricsManager.commitLatencyAvg).metricValue());
        Assertions.assertEquals((Object)102.0, (Object)this.metrics.metric(metricsManager.commitLatencyMax).metricValue());
        Assertions.assertEquals((Object)0.1, (Object)this.metrics.metric(metricsManager.commitRate).metricValue());
        Assertions.assertEquals((Object)3.0, (Object)this.metrics.metric(metricsManager.commitTotal).metricValue());
    }
}

