/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import org.apache.kafka.clients.consumer.internals.metrics.RebalanceCallbackMetricsManager;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RebalanceCallbackMetricsManagerTest {
    private Time time = new MockTime();
    private Metrics metrics = new Metrics(this.time);

    @Test
    public void testRebalanceCallbackMetrics() {
        RebalanceCallbackMetricsManager metricsManager = new RebalanceCallbackMetricsManager(this.metrics);
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionRevokeLatencyAvg));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionRevokeLatencyMax));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionAssignLatencyAvg));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionAssignLatencyMax));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionLostLatencyAvg));
        Assertions.assertNotNull((Object)this.metrics.metric(metricsManager.partitionLostLatencyMax));
        metricsManager.recordPartitionsAssignedLatency(100L);
        metricsManager.recordPartitionsRevokedLatency(101L);
        metricsManager.recordPartitionsLostLatency(102L);
        Assertions.assertEquals((Object)101.0, (Object)this.metrics.metric(metricsManager.partitionRevokeLatencyAvg).metricValue());
        Assertions.assertEquals((Object)101.0, (Object)this.metrics.metric(metricsManager.partitionRevokeLatencyMax).metricValue());
        Assertions.assertEquals((Object)100.0, (Object)this.metrics.metric(metricsManager.partitionAssignLatencyAvg).metricValue());
        Assertions.assertEquals((Object)100.0, (Object)this.metrics.metric(metricsManager.partitionAssignLatencyMax).metricValue());
        Assertions.assertEquals((Object)102.0, (Object)this.metrics.metric(metricsManager.partitionLostLatencyAvg).metricValue());
        Assertions.assertEquals((Object)102.0, (Object)this.metrics.metric(metricsManager.partitionLostLatencyMax).metricValue());
    }
}

