/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicPartitionTest {
    private String topicName = "mytopic";
    private String fileName = "serializedData/topicPartitionSerializedfile";
    private int partNum = 5;

    private void checkValues(TopicPartition deSerTP) {
        Assertions.assertEquals((int)this.partNum, (int)deSerTP.partition(), (String)("partition number should be " + this.partNum + " but got " + deSerTP.partition()));
        Assertions.assertEquals((Object)this.topicName, (Object)deSerTP.topic(), (String)("topic should be " + this.topicName + " but got " + deSerTP.topic()));
    }

    @Test
    public void testSerializationRoundtrip() throws IOException, ClassNotFoundException {
        TopicPartition origTp = new TopicPartition(this.topicName, this.partNum);
        byte[] byteArray = Serializer.serialize(origTp);
        Object deserializedObject = Serializer.deserialize(byteArray);
        Assertions.assertTrue((boolean)(deserializedObject instanceof TopicPartition));
        this.checkValues((TopicPartition)deserializedObject);
    }

    @Test
    public void testTopicPartitionSerializationCompatibility() throws IOException, ClassNotFoundException {
        Object deserializedObject = Serializer.deserialize(this.fileName);
        Assertions.assertTrue((boolean)(deserializedObject instanceof TopicPartition));
        this.checkValues((TopicPartition)deserializedObject);
    }

    @Test
    public void testTopicPartitionFromString() {
        TopicPartition tp = TopicPartition.fromString((String)"mytopic-5");
        Assertions.assertEquals((Object)tp.topic(), (Object)"mytopic");
        Assertions.assertEquals((int)tp.partition(), (int)5);
        Assertions.assertThrows(IllegalArgumentException.class, () -> TopicPartition.fromString((String)"invalidtp5"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> TopicPartition.fromString((String)"mytopic-"));
    }
}

