/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.header.internals;

import java.io.IOException;
import java.util.Iterator;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecordHeadersTest {
    @Test
    public void testAdd() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Header header = (Header)headers.iterator().next();
        RecordHeadersTest.assertHeader("key", "value", header);
        headers.add((Header)new RecordHeader("key2", "value2".getBytes()));
        RecordHeadersTest.assertHeader("key2", "value2", headers.lastHeader("key2"));
        Assertions.assertEquals((int)2, (int)this.getCount((Headers)headers));
    }

    @Test
    public void testRemove() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Assertions.assertTrue((boolean)headers.iterator().hasNext());
        headers.remove("key");
        Assertions.assertFalse((boolean)headers.iterator().hasNext());
    }

    @Test
    public void testAddRemoveInterleaved() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key2", "value2".getBytes()));
        Assertions.assertTrue((boolean)headers.iterator().hasNext());
        headers.remove("key");
        Assertions.assertEquals((int)1, (int)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key3", "value3".getBytes()));
        Assertions.assertNull((Object)headers.lastHeader("key"));
        RecordHeadersTest.assertHeader("key2", "value2", headers.lastHeader("key2"));
        RecordHeadersTest.assertHeader("key3", "value3", headers.lastHeader("key3"));
        Assertions.assertEquals((int)2, (int)this.getCount((Headers)headers));
        headers.remove("key2");
        Assertions.assertNull((Object)headers.lastHeader("key"));
        Assertions.assertNull((Object)headers.lastHeader("key2"));
        RecordHeadersTest.assertHeader("key3", "value3", headers.lastHeader("key3"));
        Assertions.assertEquals((int)1, (int)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key3", "value4".getBytes()));
        RecordHeadersTest.assertHeader("key3", "value4", headers.lastHeader("key3"));
        Assertions.assertEquals((int)2, (int)this.getCount((Headers)headers));
        headers.add((Header)new RecordHeader("key", "valueNew".getBytes()));
        Assertions.assertEquals((int)3, (int)this.getCount((Headers)headers));
        RecordHeadersTest.assertHeader("key", "valueNew", headers.lastHeader("key"));
        headers.remove("key3");
        Assertions.assertEquals((int)1, (int)this.getCount((Headers)headers));
        Assertions.assertNull((Object)headers.lastHeader("key2"));
        headers.remove("key");
        Assertions.assertFalse((boolean)headers.iterator().hasNext());
    }

    @Test
    public void testLastHeader() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key", "value2".getBytes()));
        headers.add((Header)new RecordHeader("key", "value3".getBytes()));
        RecordHeadersTest.assertHeader("key", "value3", headers.lastHeader("key"));
        Assertions.assertEquals((int)3, (int)this.getCount((Headers)headers));
    }

    @Test
    public void testReadOnly() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        Iterator headerIteratorBeforeClose = headers.iterator();
        headers.setReadOnly();
        try {
            headers.add((Header)new RecordHeader("key", "value".getBytes()));
            Assertions.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            headers.remove("key");
            Assertions.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Iterator headerIterator = headers.iterator();
            headerIterator.next();
            headerIterator.remove();
            Assertions.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            headerIteratorBeforeClose.next();
            headerIteratorBeforeClose.remove();
            Assertions.fail((String)"IllegalStateException expected as headers are closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaders() throws IOException {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.add((Header)new RecordHeader("key1", "key1value".getBytes()));
        headers.add((Header)new RecordHeader("key", "value2".getBytes()));
        headers.add((Header)new RecordHeader("key2", "key2value".getBytes()));
        Iterator keyHeaders = headers.headers("key").iterator();
        RecordHeadersTest.assertHeader("key", "value", (Header)keyHeaders.next());
        RecordHeadersTest.assertHeader("key", "value2", (Header)keyHeaders.next());
        Assertions.assertFalse((boolean)keyHeaders.hasNext());
        keyHeaders = headers.headers("key1").iterator();
        RecordHeadersTest.assertHeader("key1", "key1value", (Header)keyHeaders.next());
        Assertions.assertFalse((boolean)keyHeaders.hasNext());
        keyHeaders = headers.headers("key2").iterator();
        RecordHeadersTest.assertHeader("key2", "key2value", (Header)keyHeaders.next());
        Assertions.assertFalse((boolean)keyHeaders.hasNext());
    }

    @Test
    public void testNew() {
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("key", "value".getBytes()));
        headers.setReadOnly();
        RecordHeaders newHeaders = new RecordHeaders((Iterable)headers);
        newHeaders.add((Header)new RecordHeader("key", "value2".getBytes()));
        RecordHeadersTest.assertHeader("key", "value", headers.lastHeader("key"));
        Assertions.assertEquals((int)1, (int)this.getCount((Headers)headers));
        RecordHeadersTest.assertHeader("key", "value2", newHeaders.lastHeader("key"));
        Assertions.assertEquals((int)2, (int)this.getCount((Headers)newHeaders));
    }

    @Test
    public void shouldThrowNpeWhenAddingNullHeader() {
        RecordHeaders recordHeaders = new RecordHeaders();
        Assertions.assertThrows(NullPointerException.class, () -> recordHeaders.add(null));
    }

    @Test
    public void shouldThrowNpeWhenAddingCollectionWithNullHeader() {
        Assertions.assertThrows(NullPointerException.class, () -> new RecordHeaders(new Header[1]));
    }

    private int getCount(Headers headers) {
        int count = 0;
        Iterator headerIterator = headers.iterator();
        while (headerIterator.hasNext()) {
            headerIterator.next();
            ++count;
        }
        return count;
    }

    static void assertHeader(String key, String value, Header actual) {
        Assertions.assertEquals((Object)key, (Object)actual.key());
        Assertions.assertArrayEquals((byte[])value.getBytes(), (byte[])actual.value());
    }
}

