/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.compress.ZstdFactory;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.PartialDefaultRecord;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ChunkedBytesStream;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultRecordBatchTest {
    private static final Random RANDOM = new Random(20231025L);

    @Test
    public void testWriteEmptyHeader() {
        long producerId = 23423L;
        short producerEpoch = 145;
        int baseSequence = 983;
        long baseOffset = 15L;
        long lastOffset = 37L;
        int partitionLeaderEpoch = 15;
        long timestamp = System.currentTimeMillis();
        for (TimestampType timestampType : Arrays.asList(TimestampType.CREATE_TIME, TimestampType.LOG_APPEND_TIME)) {
            for (boolean isTransactional : Arrays.asList(true, false)) {
                for (boolean isControlBatch : Arrays.asList(true, false)) {
                    ByteBuffer buffer = ByteBuffer.allocate(2048);
                    DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)producerId, (short)producerEpoch, (int)baseSequence, (long)baseOffset, (long)lastOffset, (int)partitionLeaderEpoch, (TimestampType)timestampType, (long)timestamp, (boolean)isTransactional, (boolean)isControlBatch);
                    buffer.flip();
                    DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
                    Assertions.assertEquals((long)producerId, (long)batch.producerId());
                    Assertions.assertEquals((short)producerEpoch, (short)batch.producerEpoch());
                    Assertions.assertEquals((int)baseSequence, (int)batch.baseSequence());
                    Assertions.assertEquals((int)(baseSequence + (int)(lastOffset - baseOffset)), (int)batch.lastSequence());
                    Assertions.assertEquals((long)baseOffset, (long)batch.baseOffset());
                    Assertions.assertEquals((long)lastOffset, (long)batch.lastOffset());
                    Assertions.assertEquals((int)partitionLeaderEpoch, (int)batch.partitionLeaderEpoch());
                    Assertions.assertEquals((Object)isTransactional, (Object)batch.isTransactional());
                    Assertions.assertEquals((Object)timestampType, (Object)batch.timestampType());
                    Assertions.assertEquals((long)timestamp, (long)batch.maxTimestamp());
                    Assertions.assertEquals((long)-1L, (long)batch.baseTimestamp());
                    Assertions.assertEquals((Object)isControlBatch, (Object)batch.isControlBatch());
                }
            }
        }
    }

    @Test
    public void buildDefaultRecordBatch() {
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        for (MutableRecordBatch batch : records.batches()) {
            Assertions.assertTrue((boolean)batch.isValid());
            Assertions.assertEquals((long)1234567L, (long)batch.baseOffset());
            Assertions.assertEquals((long)1234568L, (long)batch.lastOffset());
            Assertions.assertEquals((long)2L, (long)batch.maxTimestamp());
            Assertions.assertEquals((long)-1L, (long)batch.producerId());
            Assertions.assertEquals((short)-1, (short)batch.producerEpoch());
            Assertions.assertEquals((int)-1, (int)batch.baseSequence());
            Assertions.assertEquals((int)-1, (int)batch.lastSequence());
            for (Record record : batch) {
                record.ensureValid();
            }
        }
    }

    @Test
    public void buildDefaultRecordBatchWithProducerId() {
        long pid = 23423L;
        short epoch = 145;
        int baseSequence = 983;
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L, (long)-1L, (long)pid, (short)epoch, (int)baseSequence);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        for (MutableRecordBatch batch : records.batches()) {
            Assertions.assertTrue((boolean)batch.isValid());
            Assertions.assertEquals((long)1234567L, (long)batch.baseOffset());
            Assertions.assertEquals((long)1234568L, (long)batch.lastOffset());
            Assertions.assertEquals((long)2L, (long)batch.maxTimestamp());
            Assertions.assertEquals((long)pid, (long)batch.producerId());
            Assertions.assertEquals((short)epoch, (short)batch.producerEpoch());
            Assertions.assertEquals((int)baseSequence, (int)batch.baseSequence());
            Assertions.assertEquals((int)(baseSequence + 1), (int)batch.lastSequence());
            for (Record record : batch) {
                record.ensureValid();
            }
        }
    }

    @Test
    public void buildDefaultRecordBatchWithSequenceWrapAround() {
        long pid = 23423L;
        short epoch = 145;
        int baseSequence = 0x7FFFFFFE;
        ByteBuffer buffer = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1234567L, (long)-1L, (long)pid, (short)epoch, (int)baseSequence);
        builder.appendWithOffset(1234567L, 1L, "a".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234568L, 2L, "b".getBytes(), "v".getBytes());
        builder.appendWithOffset(1234569L, 3L, "c".getBytes(), "v".getBytes());
        MemoryRecords records = builder.build();
        List batches = TestUtils.toList(records.batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        RecordBatch batch = (RecordBatch)batches.get(0);
        Assertions.assertEquals((long)pid, (long)batch.producerId());
        Assertions.assertEquals((short)epoch, (short)batch.producerEpoch());
        Assertions.assertEquals((int)baseSequence, (int)batch.baseSequence());
        Assertions.assertEquals((int)0, (int)batch.lastSequence());
        List allRecords = TestUtils.toList(batch);
        Assertions.assertEquals((int)3, (int)allRecords.size());
        Assertions.assertEquals((int)0x7FFFFFFE, (int)((Record)allRecords.get(0)).sequence());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)((Record)allRecords.get(1)).sequence());
        Assertions.assertEquals((int)0, (int)((Record)allRecords.get(2)).sequence());
    }

    @Test
    public void testSizeInBytes() {
        Header[] headers = new Header[]{new RecordHeader("foo", "value".getBytes()), new RecordHeader("bar", (byte[])null)};
        long timestamp = System.currentTimeMillis();
        SimpleRecord[] records = new SimpleRecord[]{new SimpleRecord(timestamp, "key".getBytes(), "value".getBytes()), new SimpleRecord(timestamp + 30000L, null, "value".getBytes()), new SimpleRecord(timestamp + 60000L, "key".getBytes(), null), new SimpleRecord(timestamp + 60000L, "key".getBytes(), "value".getBytes(), headers)};
        int actualSize = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])records).sizeInBytes();
        Assertions.assertEquals((int)actualSize, (int)DefaultRecordBatch.sizeInBytes(Arrays.asList(records)));
    }

    @Test
    public void testInvalidRecordSize() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        ByteBuffer buffer = records.buffer();
        buffer.putInt(8, 10);
        DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
        Assertions.assertFalse((boolean)batch.isValid());
        Assertions.assertThrows(CorruptRecordException.class, () -> ((DefaultRecordBatch)batch).ensureValid());
    }

    @Test
    public void testInvalidRecordCountTooManyNonCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.NONE, 5);
        Assertions.assertThrows(InvalidRecordException.class, () -> batch.forEach(Record::ensureValid));
    }

    @Test
    public void testInvalidRecordCountTooLittleNonCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.NONE, 2);
        Assertions.assertThrows(InvalidRecordException.class, () -> batch.forEach(Record::ensureValid));
    }

    @Test
    public void testInvalidRecordCountTooManyCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.GZIP, 5);
        Assertions.assertThrows(InvalidRecordException.class, () -> batch.forEach(Record::ensureValid));
    }

    @Test
    public void testInvalidRecordCountTooLittleCompressedV2() {
        long now = System.currentTimeMillis();
        DefaultRecordBatch batch = DefaultRecordBatchTest.recordsWithInvalidRecordCount((byte)2, now, CompressionType.GZIP, 2);
        Assertions.assertThrows(InvalidRecordException.class, () -> batch.forEach(Record::ensureValid));
    }

    @Test
    public void testInvalidCrc() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        ByteBuffer buffer = records.buffer();
        buffer.putInt(23, 23);
        DefaultRecordBatch batch = new DefaultRecordBatch(buffer);
        Assertions.assertFalse((boolean)batch.isValid());
        Assertions.assertThrows(CorruptRecordException.class, () -> ((DefaultRecordBatch)batch).ensureValid());
    }

    @Test
    public void testSetLastOffset() {
        SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())};
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])simpleRecords);
        long lastOffset = 500L;
        long firstOffset = lastOffset - (long)simpleRecords.length + 1L;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setLastOffset(lastOffset);
        Assertions.assertEquals((long)lastOffset, (long)batch.lastOffset());
        Assertions.assertEquals((long)firstOffset, (long)batch.baseOffset());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)lastOffset, (long)((MutableRecordBatch)recordBatches.get(0)).lastOffset());
        long offset = firstOffset;
        for (Record record : records.records()) {
            Assertions.assertEquals((long)offset++, (long)record.offset());
        }
    }

    @Test
    public void testSetPartitionLeaderEpoch() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        int leaderEpoch = 500;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setPartitionLeaderEpoch(leaderEpoch);
        Assertions.assertEquals((int)leaderEpoch, (int)batch.partitionLeaderEpoch());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((int)leaderEpoch, (int)((MutableRecordBatch)recordBatches.get(0)).partitionLeaderEpoch());
    }

    @Test
    public void testSetLogAppendTime() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        long logAppendTime = 15L;
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, logAppendTime);
        Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)batch.timestampType());
        Assertions.assertEquals((long)logAppendTime, (long)batch.maxTimestamp());
        Assertions.assertTrue((boolean)batch.isValid());
        List recordBatches = Utils.toList(records.batches().iterator());
        Assertions.assertEquals((int)1, (int)recordBatches.size());
        Assertions.assertEquals((long)logAppendTime, (long)((MutableRecordBatch)recordBatches.get(0)).maxTimestamp());
        Assertions.assertEquals((Object)TimestampType.LOG_APPEND_TIME, (Object)((MutableRecordBatch)recordBatches.get(0)).timestampType());
        for (Record record : records.records()) {
            Assertions.assertEquals((long)logAppendTime, (long)record.timestamp());
        }
    }

    @Test
    public void testSetNoTimestampTypeNotAllowed() {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        Assertions.assertThrows(IllegalArgumentException.class, () -> batch.setMaxTimestamp(TimestampType.NO_TIMESTAMP_TYPE, -1L));
    }

    @Test
    public void testReadAndWriteControlBatch() {
        long producerId = 1L;
        short producerEpoch = 0;
        int coordinatorEpoch = 15;
        ByteBuffer buffer = ByteBuffer.allocate(128);
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, CompressionType.NONE, TimestampType.CREATE_TIME, 0L, -1L, producerId, producerEpoch, -1, true, true, -1, buffer.remaining());
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        builder.appendEndTxnMarker(System.currentTimeMillis(), marker);
        MemoryRecords records = builder.build();
        List batches = TestUtils.toList(records.batches());
        Assertions.assertEquals((int)1, (int)batches.size());
        MutableRecordBatch batch = (MutableRecordBatch)batches.get(0);
        Assertions.assertTrue((boolean)batch.isControlBatch());
        List logRecords = TestUtils.toList(records.records());
        Assertions.assertEquals((int)1, (int)logRecords.size());
        Record commitRecord = (Record)logRecords.get(0);
        Assertions.assertEquals((Object)marker, (Object)EndTransactionMarker.deserialize((Record)commitRecord));
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void testStreamingIteratorConsistency(CompressionType compressionType) {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), "2".getBytes()), new SimpleRecord(3L, "c".getBytes(), "3".getBytes())});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        try (CloseableIterator streamingIterator = batch.streamingIterator(BufferSupplier.create());){
            TestUtils.checkEquals(streamingIterator, batch.iterator());
        }
    }

    @EnumSource(value=CompressionType.class)
    public void testSkipKeyValueIteratorCorrectness(CompressionType compressionType) {
        Header[] headers = new Header[]{new RecordHeader("k1", "v1".getBytes()), new RecordHeader("k2", null)};
        byte[] largeRecordValue = new byte[204800];
        RANDOM.nextBytes(largeRecordValue);
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, "a".getBytes(), "1".getBytes()), new SimpleRecord(2L, "b".getBytes(), null), new SimpleRecord(3L, null, "3".getBytes()), new SimpleRecord(4L, null, (byte[])null), new SimpleRecord(1000L, "abc".getBytes(), largeRecordValue), new SimpleRecord(9999L, "abc".getBytes(), "0".getBytes(), headers)});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        try (BufferSupplier bufferSupplier = BufferSupplier.create();
             CloseableIterator skipKeyValueIterator = batch.skipKeyValueIterator(bufferSupplier);){
            if (CompressionType.NONE == compressionType) {
                Assertions.assertTrue((boolean)(skipKeyValueIterator instanceof DefaultRecordBatch.RecordIterator));
                Assertions.assertEquals((int)Utils.toList((Iterable)records.records()).size(), (int)Utils.toList((Iterator)skipKeyValueIterator).size());
            } else {
                Assertions.assertTrue((boolean)(skipKeyValueIterator instanceof DefaultRecordBatch.StreamRecordIterator));
                Assertions.assertIterableEquals(Arrays.asList(new PartialDefaultRecord(9, 0, 0L, 1L, -1, 1, 1), new PartialDefaultRecord(8, 0, 1L, 2L, -1, 1, -1), new PartialDefaultRecord(8, 0, 2L, 3L, -1, -1, 1), new PartialDefaultRecord(7, 0, 3L, 4L, -1, -1, -1), new PartialDefaultRecord(15 + largeRecordValue.length, 0, 4L, 1000L, -1, 3, largeRecordValue.length), new PartialDefaultRecord(23, 0, 5L, 9999L, -1, 3, 1)), (Iterable)Utils.toList((Iterator)skipKeyValueIterator));
            }
        }
    }

    @MethodSource
    public void testBufferReuseInSkipKeyValueIterator(CompressionType compressionType, int expectedNumBufferAllocations, byte[] recordValue) {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)compressionType, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1000L, "a".getBytes(), "0".getBytes()), new SimpleRecord(9999L, "b".getBytes(), recordValue)});
        DefaultRecordBatch batch = new DefaultRecordBatch(records.buffer());
        try (BufferSupplier bufferSupplier = (BufferSupplier)Mockito.spy((Object)BufferSupplier.create());
             CloseableIterator streamingIterator = batch.skipKeyValueIterator(bufferSupplier);){
            Utils.toList((Iterator)streamingIterator);
            streamingIterator.close();
            ((BufferSupplier)Mockito.verify((Object)bufferSupplier, (VerificationMode)Mockito.times((int)expectedNumBufferAllocations))).get(ArgumentMatchers.anyInt());
            ((BufferSupplier)Mockito.verify((Object)bufferSupplier, (VerificationMode)Mockito.times((int)expectedNumBufferAllocations))).release((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        }
    }

    private static Stream<Arguments> testBufferReuseInSkipKeyValueIterator() {
        byte[] smallRecordValue = "1".getBytes();
        byte[] largeRecordValue = new byte[524288];
        RANDOM.nextBytes(largeRecordValue);
        return Stream.of(Arguments.of((Object[])new Object[]{CompressionType.GZIP, 1, smallRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.GZIP, 1, largeRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.SNAPPY, 1, smallRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.SNAPPY, 1, largeRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.LZ4, 2, smallRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.LZ4, 2, largeRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.ZSTD, 2, smallRecordValue}), Arguments.of((Object[])new Object[]{CompressionType.ZSTD, 2, largeRecordValue}));
    }

    @MethodSource
    public void testZstdJniForSkipKeyValueIterator(int expectedJniCalls, byte[] recordValue) throws IOException {
        MemoryRecords records = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.ZSTD, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(9L, "hakuna-matata".getBytes(), recordValue)});
        ByteBuffer compressedBuf = records.buffer();
        DefaultRecordBatch batch = (DefaultRecordBatch)Mockito.spy((Object)new DefaultRecordBatch(compressedBuf.duplicate()));
        CompressionType mockCompression = (CompressionType)Mockito.mock(CompressionType.ZSTD.getClass());
        ((DefaultRecordBatch)Mockito.doReturn((Object)mockCompression).when((Object)batch)).compressionType();
        ByteBuffer recordsBuffer = compressedBuf.duplicate();
        recordsBuffer.position(61);
        try (BufferSupplier bufferSupplier = BufferSupplier.create();
             InputStream zstdStream = (InputStream)Mockito.spy((Object)ZstdFactory.wrapForInput((ByteBuffer)recordsBuffer, (byte)batch.magic(), (BufferSupplier)bufferSupplier));
             ChunkedBytesStream chunkedStream = new ChunkedBytesStream(zstdStream, bufferSupplier, 16384, false);){
            Mockito.when((Object)mockCompression.wrapForInput((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), ArgumentMatchers.anyByte(), (BufferSupplier)ArgumentMatchers.any(BufferSupplier.class))).thenReturn((Object)chunkedStream);
            try (CloseableIterator streamingIterator = batch.skipKeyValueIterator(bufferSupplier);){
                Assertions.assertNotNull((Object)streamingIterator);
                Utils.toList((Iterator)streamingIterator);
                ((InputStream)Mockito.verify((Object)zstdStream, (VerificationMode)Mockito.times((int)expectedJniCalls))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
                ((InputStream)Mockito.verify((Object)zstdStream, (VerificationMode)Mockito.never())).skip(ArgumentMatchers.anyLong());
            }
        }
    }

    private static Stream<Arguments> testZstdJniForSkipKeyValueIterator() {
        byte[] smallRecordValue = "1".getBytes();
        byte[] largeRecordValue = new byte[40960];
        RANDOM.nextBytes(largeRecordValue);
        return Stream.of(Arguments.of((Object[])new Object[]{2, smallRecordValue}), Arguments.of((Object[])new Object[]{4, largeRecordValue}));
    }

    @Test
    public void testIncrementSequence() {
        Assertions.assertEquals((int)10, (int)DefaultRecordBatch.incrementSequence((int)5, (int)5));
        Assertions.assertEquals((int)0, (int)DefaultRecordBatch.incrementSequence((int)Integer.MAX_VALUE, (int)1));
        Assertions.assertEquals((int)4, (int)DefaultRecordBatch.incrementSequence((int)0x7FFFFFFA, (int)10));
    }

    @Test
    public void testDecrementSequence() {
        Assertions.assertEquals((int)0, (int)DefaultRecordBatch.decrementSequence((int)5, (int)5));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)DefaultRecordBatch.decrementSequence((int)0, (int)1));
    }

    private static DefaultRecordBatch recordsWithInvalidRecordCount(Byte magicValue, long timestamp, CompressionType codec, int invalidCount) {
        ByteBuffer buf = ByteBuffer.allocate(512);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        MemoryRecords records = builder.build();
        ByteBuffer buffer = records.buffer();
        buffer.position(0);
        buffer.putInt(57, invalidCount);
        buffer.position(0);
        return new DefaultRecordBatch(buffer);
    }
}

