/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.LazyDownConversionRecords;
import org.apache.kafka.common.record.LazyDownConversionRecordsSend;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordValidationStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.RecordsSend;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyDownConversionRecordsSendTest {
    @Test
    public void testRecordsReleasedSend() throws IOException {
        MockReleasableRecords records = new MockReleasableRecords();
        TopicPartition topicPartition = new TopicPartition("foo", 1);
        LazyDownConversionRecords lazyDownConversionRecords = new LazyDownConversionRecords(topicPartition, (Records)records, 0, 0L, (Time)new MockTime());
        LazyDownConversionRecordsSend send = new LazyDownConversionRecordsSend(lazyDownConversionRecords);
        ByteBufferChannel channel = new ByteBufferChannel(1024L);
        send.writeTo((TransferableChannel)channel);
        send.release();
        Assertions.assertTrue((boolean)records.released, (String)"expected a released send to also release the backing records");
    }

    class MockReleasableRecords
    implements Records {
        boolean released = false;

        MockReleasableRecords() {
        }

        public int writeTo(TransferableChannel channel, int position, int length) {
            return 0;
        }

        public Iterable<? extends RecordBatch> batches() {
            return Collections.emptyList();
        }

        public AbstractIterator<? extends RecordBatch> batchIterator() {
            return new AbstractIterator<RecordBatch>(){

                public boolean hasNext() {
                    return false;
                }

                protected RecordBatch makeNext() {
                    return null;
                }
            };
        }

        public boolean hasMatchingMagic(byte magic) {
            return false;
        }

        public ConvertedRecords<? extends Records> downConvert(byte toMagic, long firstOffset, Time time) {
            return new ConvertedRecords((Records)MemoryRecords.EMPTY, new RecordValidationStats());
        }

        public Iterable<Record> records() {
            return Collections.emptyList();
        }

        public void release() {
            this.released = true;
        }

        public int sizeInBytes() {
            return 0;
        }

        public RecordsSend<MockReleasableRecords> toSend() {
            return null;
        }

        public Optional<RecordBatch> lastBatch() {
            return Optional.empty();
        }
    }
}

