/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UpdateMetadataRequestTest {
    @Test
    public void testUnsupportedVersion() {
        UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder((short)(ApiKeys.UPDATE_METADATA.latestVersion() + 1), 0, 0, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), false);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((UpdateMetadataRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        Iterator iterator = ApiKeys.UPDATE_METADATA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder(version, 0, 0, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), false);
            UpdateMetadataRequest request = (UpdateMetadataRequest)builder.build();
            UpdateMetadataResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }

    @Test
    public void testVersionLogic() {
        String topic0 = "topic0";
        String topic1 = "topic1";
        Iterator iterator = ApiKeys.UPDATE_METADATA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            List<Object> brokerHealthStates = Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState().setBrokerId(2).setDegradedComponents(Collections.singletonList((byte)0)));
            if (version < 7) {
                brokerHealthStates = Collections.emptyList();
            }
            List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(2).setLeader(0).setLeaderEpoch(10).setIsr(Arrays.asList(0, 1)).setZkVersion(10).setReplicas(Arrays.asList(0, 1, 2)).setOfflineReplicas(Arrays.asList(2)).setObservers(Arrays.asList(2)), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(2).setLeader(1).setLeaderEpoch(11).setIsr(Arrays.asList(1, 2, 3)).setZkVersion(11).setReplicas(Arrays.asList(1, 2, 3)).setOfflineReplicas(Collections.emptyList()), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(2).setLeader(2).setLeaderEpoch(11).setIsr(Arrays.asList(2, 3)).setZkVersion(11).setReplicas(Arrays.asList(2, 3, 4)).setOfflineReplicas(Collections.emptyList()));
            ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> broker0Endpoints = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>();
            broker0Endpoints.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9090).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id));
            if (version >= 1) {
                broker0Endpoints.add(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9091).setSecurityProtocol(SecurityProtocol.SSL.id));
            }
            if (version >= 3) {
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)broker0Endpoints.get(0)).setListener("listener0");
                ((UpdateMetadataRequestData.UpdateMetadataEndpoint)broker0Endpoints.get(1)).setListener("listener1");
            }
            List<UpdateMetadataRequestData.UpdateMetadataBroker> liveBrokers = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack0").setEndpoints(broker0Endpoints).setTags(Arrays.asList(new UpdateMetadataRequestData.Tag().setName("a1").setValue("v1"), new UpdateMetadataRequestData.Tag().setName("a2").setValue("v2"))), new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints(Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9090).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener("PLAINTEXT"))).setTags(Arrays.asList(new UpdateMetadataRequestData.Tag().setName("b1").setValue("v1"), new UpdateMetadataRequestData.Tag().setName("b2").setValue("v2"))));
            HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
            topicIds.put(topic0, Uuid.randomUuid());
            topicIds.put(topic1, Uuid.randomUuid());
            List<UpdateMetadataRequestData.UpdateMetadataCell> cells = Arrays.asList(new UpdateMetadataRequestData.UpdateMetadataCell().setCellId(0).setBrokers(Arrays.asList(0, 1, 2)), new UpdateMetadataRequestData.UpdateMetadataCell().setCellId(1).setBrokers(Arrays.asList(3, 4, 5)));
            UpdateMetadataRequest request = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 1, 2, 3L, brokerHealthStates, partitionStates, liveBrokers, topicIds, cells, false).build();
            Assertions.assertEquals(new HashSet<UpdateMetadataRequestData.UpdateMetadataPartitionState>(partitionStates), this.iterableToSet(request.partitionStates()));
            Assertions.assertEquals(liveBrokers, (Object)request.liveBrokers());
            Assertions.assertEquals((int)1, (int)request.controllerId());
            Assertions.assertEquals((int)2, (int)request.controllerEpoch());
            Assertions.assertEquals((long)3L, (long)request.brokerEpoch());
            ByteBuffer byteBuffer = request.serialize();
            UpdateMetadataRequest deserializedRequest = UpdateMetadataRequest.parse((ByteBuffer)byteBuffer, (short)version, (MessageContext)MessageContext.IDENTITY);
            if (version < 2) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : liveBrokers) {
                    liveBroker.setRack("");
                }
            }
            if (version < 3) {
                for (UpdateMetadataRequestData.UpdateMetadataBroker liveBroker : liveBrokers) {
                    for (UpdateMetadataRequestData.UpdateMetadataEndpoint endpoint : liveBroker.endpoints()) {
                        SecurityProtocol securityProtocol = SecurityProtocol.forId((short)endpoint.securityProtocol());
                        endpoint.setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value());
                    }
                }
            }
            if (version < 4) {
                partitionStates.get(0).setOfflineReplicas(Collections.emptyList());
            }
            if (version < 6) {
                partitionStates.get(0).setObservers(Collections.emptyList());
                liveBrokers.forEach(broker -> broker.setTags(Collections.emptyList()));
            }
            Assertions.assertEquals(new HashSet<UpdateMetadataRequestData.UpdateMetadataPartitionState>(partitionStates), this.iterableToSet(deserializedRequest.partitionStates()));
            Assertions.assertEquals(liveBrokers, (Object)deserializedRequest.liveBrokers());
            Assertions.assertEquals((int)1, (int)deserializedRequest.controllerId());
            Assertions.assertEquals((int)2, (int)deserializedRequest.controllerEpoch());
            if (version >= 5) {
                Assertions.assertEquals((long)3L, (long)deserializedRequest.brokerEpoch());
            } else {
                Assertions.assertEquals((long)-1L, (long)deserializedRequest.brokerEpoch());
            }
            long topicIdCount = deserializedRequest.data().topicStates().stream().map(UpdateMetadataRequestData.UpdateMetadataTopicState::topicId).filter(topicId -> !Uuid.ZERO_UUID.equals(topicId)).count();
            Assertions.assertEquals(brokerHealthStates, (Object)deserializedRequest.brokerHealthStates());
            if (version >= 7) {
                Assertions.assertEquals((long)2L, (long)topicIdCount);
                Assertions.assertEquals(cells, (Object)deserializedRequest.cells());
                continue;
            }
            Assertions.assertEquals((long)0L, (long)topicIdCount);
            Assertions.assertEquals(Collections.emptyList(), (Object)deserializedRequest.cells());
        }
    }

    @Test
    public void testTopicPartitionGroupingSizeReduction() {
        Set<TopicPartition> tps = TestUtils.generateRandomTopicPartitions(10, 10);
        ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>();
        for (TopicPartition tp : tps) {
            partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()));
        }
        UpdateMetadataRequest.Builder builder = new UpdateMetadataRequest.Builder(5, 0, 0, 0L, Collections.emptyList(), partitionStates, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), false);
        Assertions.assertTrue((builder.build((short)5).sizeInBytes() < builder.build((short)4).sizeInBytes() ? 1 : 0) != 0);
    }

    @Test
    public void testIsKRaftControllerField() {
        IntStream.range(0, ApiKeys.UPDATE_METADATA.latestVersion() + 1).forEach(version -> {
            UpdateMetadataRequest.Builder builder1 = new UpdateMetadataRequest.Builder((short)version, 0, 0, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), true);
            UpdateMetadataRequest request1 = (UpdateMetadataRequest)builder1.build();
            Assertions.assertEquals((Object)(version >= 8 ? 1 : 0), (Object)request1.isKRaftController());
            UpdateMetadataRequest.Builder builder2 = new UpdateMetadataRequest.Builder((short)version, 0, 0, 0L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), false, Collections.emptyList(), true, AbstractControlRequest.Type.UNKNOWN);
            UpdateMetadataRequest request2 = (UpdateMetadataRequest)builder2.build();
            Assertions.assertEquals((Object)(version >= 8 ? 1 : 0), (Object)request2.isKRaftController());
        });
    }

    private <T> Set<T> iterableToSet(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toSet());
    }
}

