/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import io.confluent.kafka.security.auth.plain.DynamicPlainClientCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.FileBasedDynamicPlainLoginCallbackHandler;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.Login;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.AbstractLogin;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.DefaultLogin;
import org.apache.kafka.common.security.authenticator.DelayableValidateCallbackHandler;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.authenticator.SaslClientAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.TestDigestLoginModule;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.authenticator.TestPP2PlainSaslServerProvider;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.FileWatchService;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class SaslAuthenticatorTest {
    private static final long CONNECTIONS_MAX_REAUTH_MS_VALUE = 100L;
    private static final int BUFFER_SIZE = 4096;
    private static Time time = Time.SYSTEM;
    private NioEchoServer server;
    private Selector selector;
    private ChannelBuilder channelBuilder;
    private CertStores serverCertStores;
    private CertStores clientCertStores;
    private Map<String, Object> saslClientConfigs;
    private Map<String, Object> saslServerConfigs;
    private CredentialCache credentialCache;
    private int nextCorrelationId;
    private SaslAuthenticateRequestCallback saslAuthenticateRequestCallback;
    private static Map<String, Object> pp2ValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PUBLIC_IP_NLB);
    private static Map<String, Object> pp2NoValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PRIVATE_LINK_NLB);

    protected CertStores getCertStores(boolean server, String hostName) throws Exception {
        return new CertStores(server, hostName);
    }

    protected CertStores getCertStores(boolean server, String commonName, InetAddress hostAddress) throws Exception {
        return new CertStores(false, "client", InetAddress.getByName("127.0.0.1"));
    }

    @BeforeEach
    public void setup() throws Exception {
        LoginManager.closeAll();
        time = Time.SYSTEM;
        this.serverCertStores = this.getCertStores(true, "localhost");
        this.clientCertStores = this.getCertStores(false, "localhost");
        this.saslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.saslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.saslServerConfigs.put("ssl.engine.factory.class", DefaultSslEngineFactory.class);
        this.saslClientConfigs.put("ssl.engine.factory.class", DefaultSslEngineFactory.class);
        this.credentialCache = new CredentialCache();
        TestLogin.loginCount.set(0);
        this.saslAuthenticateRequestCallback = new SaslAuthenticateRequestCallback();
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
        if (this.selector != null) {
            this.selector.close();
        }
        FileWatchService.resetSensitivity();
    }

    @Test
    public void testValidSaslPlainOverSsl() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.checkAuthenticationAndReauthentication(securityProtocol, node, "PLAIN");
    }

    @Test
    public void testValidSaslPlainOverPlaintext() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.checkAuthenticationAndReauthentication(securityProtocol, node, "PLAIN");
    }

    @Test
    public void testValidProxyProtocol2TrafficHeaderAuth() throws Exception {
        try {
            TestPP2PlainSaslServerProvider.initialize();
            this.saslAuthenticateWithPP2Headers(pp2ValidateTrafficHeader);
            String serverId = "0";
            NetworkTestUtils.checkClientConnection(this.selector, serverId, 100, 10);
            this.server.verifyAuthenticationMetrics(1, 0);
        }
        finally {
            TestPP2PlainSaslServerProvider.destroy();
            this.closeClientConnectionIfNecessary();
        }
    }

    @Test
    public void testNoValidateProxyProtocol2TrafficHeaderAuth() throws Exception {
        this.testInvalidProxyProtocol2HeaderAuth(pp2NoValidateTrafficHeader);
    }

    @Test
    public void testInvalidProxyProtocol2TrafficHeaderAuth() throws Exception {
        this.testInvalidProxyProtocol2HeaderAuth(Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidProxyProtocol2HeaderAuth(Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        try {
            TestPP2PlainSaslServerProvider.initialize();
            this.saslAuthenticateWithPP2Headers(pp2TlvConfigsOverrides);
            String serverId = "0";
            ChannelState finalState = NetworkTestUtils.waitForChannelClose(this.selector, serverId, ChannelState.State.AUTHENTICATION_FAILED);
            AuthenticationException exception = finalState.exception();
            Assertions.assertEquals(SaslAuthenticationException.class, ((Object)((Object)exception)).getClass());
            this.server.verifyAuthenticationMetrics(0, 1);
        }
        finally {
            TestPP2PlainSaslServerProvider.destroy();
            this.closeClientConnectionIfNecessary();
        }
    }

    private void saslAuthenticateWithPP2Headers(Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), options);
        jaasConfig.setClientOptions("PLAIN", "TestServerCallbackHandler-user", "TestServerCallbackHandler-password");
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("PLAIN");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", TestServerCallbackHandler.class.getName());
        this.server = this.createPp2EchoServer(securityProtocol);
        this.createPp2ClientConnection(securityProtocol, "0", pp2TlvConfigsOverrides);
    }

    private void createPp2ClientConnection(SecurityProtocol securityProtocol, String node, Map<String, Object> pp2TlvConfigsOverrides) throws IOException {
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(this.saslClientConfigs);
        clientConfigs.put("confluent.proxy.protocol.client.address", "1.1.1.1");
        clientConfigs.put("confluent.proxy.protocol.client.port", 1111);
        clientConfigs.put("confluent.proxy.protocol.client.mode", ConfluentConfigs.PROXY_PROTOCOL_CLIENT_MODE_DEFAULT);
        clientConfigs.putAll(pp2TlvConfigsOverrides);
        ProxyProtocolEngineFactory clientPPEF = new ProxyProtocolEngineFactory(ProxyProtocol.V2, clientConfigs, Mode.CLIENT, new LogContext());
        this.createSelector(securityProtocol, clientConfigs, clientPPEF);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelState createAndCheckPp2ClientConnectionFailure(SecurityProtocol securityProtocol, String node, Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        try {
            ChannelState finalState;
            this.createPp2ClientConnection(securityProtocol, node, pp2TlvConfigsOverrides);
            ChannelState channelState = finalState = NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
            return channelState;
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    private NioEchoServer createPp2EchoServer(SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, 100, time, new DelegationTokenCache(ScramMechanism.mechanismNames()), new ProxyProtocolEngineFactory(ProxyProtocol.V2));
    }

    @Test
    public void testSaslAuthenticationMaxReceiveSize() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        this.saslServerConfigs.put("sasl.server.max.receive.size", "1024");
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "valid";
        this.checkAuthenticationAndReauthentication(securityProtocol, node1, "PLAIN");
        byte[] bytes = new byte[1024];
        new Random().nextBytes(bytes);
        String mechanism = new String(bytes, StandardCharsets.UTF_8);
        String node2 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node2);
        SaslHandshakeRequest handshakeRequest = this.buildSaslHandshakeRequest(mechanism, ApiKeys.SASL_HANDSHAKE.latestVersion());
        RequestHeader header = new RequestHeader(ApiKeys.SASL_HANDSHAKE, handshakeRequest.version(), "someclient", this.nextCorrelationId++);
        NetworkSend send = new NetworkSend(node2, handshakeRequest.toSend(header));
        this.selector.send(send);
        NetworkTestUtils.waitForChannelClose(this.selector, node2, ChannelState.READY.state());
        this.selector.close();
        String node3 = "invalid2";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node3);
        this.sendHandshakeRequestReceiveResponse(node3, ApiKeys.SASL_HANDSHAKE.latestVersion());
        String authString = "\u0000myuser\u0000" + new String(bytes, StandardCharsets.UTF_8);
        ByteBuffer authBuf = ByteBuffer.wrap(Utils.utf8((String)authString));
        SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(authBuf.array());
        SaslAuthenticateRequest request = (SaslAuthenticateRequest)new SaslAuthenticateRequest.Builder(data).build();
        header = new RequestHeader(ApiKeys.SASL_AUTHENTICATE, request.version(), "someclient", this.nextCorrelationId++);
        send = new NetworkSend(node3, request.toSend(header));
        this.selector.send(send);
        NetworkTestUtils.waitForChannelClose(this.selector, node3, ChannelState.READY.state());
        this.server.verifyAuthenticationMetrics(1, 2);
    }

    @Test
    public void testAuthConfiguredSaslMechanismMaxReceiveSize() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        String listenerMechanismPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("PLAIN");
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "valid1";
        this.checkAuthenticationAndReauthentication(securityProtocol, node1, "PLAIN");
        this.server.verifyAuthenticationMetrics(1, 0);
        this.saslServerConfigs.put(listenerMechanismPrefix + "sasl.server.max.receive.size", "1024");
        this.server = this.createEchoServer(securityProtocol);
        String node2 = "valid2";
        this.checkAuthenticationAndReauthentication(securityProtocol, node2, "PLAIN");
        this.server.verifyAuthenticationMetrics(1, 0);
        this.saslServerConfigs.put(listenerMechanismPrefix + "sasl.server.max.receive.size", "16");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "invaliduser", "invalidpassword"));
        this.server = this.createEchoServer(securityProtocol);
        String node3 = "invalid1";
        this.createClientConnection(securityProtocol, node3);
        NetworkTestUtils.waitForChannelClose(this.selector, node3, ChannelState.State.AUTHENTICATE);
        this.server.verifyAuthenticationMetrics(0, 1);
        this.saslServerConfigs.put(listenerMechanismPrefix + "sasl.server.max.receive.size", "2048");
        this.saslServerConfigs.put("sasl.server.max.receive.size", "16");
        this.saslServerConfigs.put("sasl.handshake.sasl.server.max.receive.size", "1024");
        this.server = this.createEchoServer(securityProtocol);
        String node4 = "invalid2";
        this.createClientConnection(securityProtocol, node4);
        NetworkTestUtils.waitForChannelClose(this.selector, node4, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testAuthConfiguredSaslHandshakeMaxReceiveSize() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        this.saslServerConfigs.put("sasl.handshake.sasl.server.max.receive.size", "1024");
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "valid";
        this.checkAuthenticationAndReauthentication(securityProtocol, node1, "PLAIN");
        byte[] bytes = new byte[1024];
        new Random().nextBytes(bytes);
        String mechanism = new String(bytes, StandardCharsets.UTF_8);
        String node2 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node2);
        SaslHandshakeRequest handshakeRequest = this.buildSaslHandshakeRequest(mechanism, ApiKeys.SASL_HANDSHAKE.latestVersion());
        RequestHeader header = new RequestHeader(ApiKeys.SASL_HANDSHAKE, handshakeRequest.version(), "someclient", this.nextCorrelationId++);
        NetworkSend send = new NetworkSend(node2, handshakeRequest.toSend(header));
        this.selector.send(send);
        NetworkTestUtils.waitForChannelClose(this.selector, node2, ChannelState.READY.state());
        this.selector.close();
        this.server.verifyAuthenticationMetrics(1, 1);
        this.saslServerConfigs.put("sasl.handshake.sasl.server.max.receive.size", "2048");
        this.saslServerConfigs.put("sasl.server.max.receive.size", "16");
        this.server = this.createEchoServer(securityProtocol);
        String node3 = "valid2";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node3);
        this.sendHandshakeRequestReceiveResponse(node3, ApiKeys.SASL_HANDSHAKE.latestVersion());
    }

    @Test
    public void testInvalidPasswordSaslPlain() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "myuser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "PLAIN", "Authentication failed: Invalid username or password");
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "PLAIN");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testInvalidUsernameSaslPlain() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "invaliduser", "mypassword");
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "PLAIN", "Authentication failed: Invalid username or password");
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "PLAIN");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testMissingUsernameSaslPlain() throws Exception {
        String node = "0";
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", null, "mypassword");
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.server = this.createEchoServer(securityProtocol);
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        try {
            this.selector.connect(node, addr, 4096, 4096);
            Assertions.fail((String)"SASL/PLAIN channel created without username");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)this.selector.channels().isEmpty(), (String)"Channels not closed");
            for (SelectionKey key : this.selector.keys()) {
                Assertions.assertFalse((boolean)key.isValid(), (String)"Key not cancelled");
            }
        }
    }

    @Test
    public void testMissingPasswordSaslPlain() throws Exception {
        String node = "0";
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "myuser", null);
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.server = this.createEchoServer(securityProtocol);
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        try {
            this.selector.connect(node, addr, 4096, 4096);
            Assertions.fail((String)"SASL/PLAIN channel created without password");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSaslPlainClientCredentialUpdate() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", null, null);
        this.saslClientConfigs.put("sasl.login.callback.handler.class", DynamicPlainLoginCallbackHandler.class);
        this.saslClientConfigs.put("sasl.client.callback.handler.class", DynamicPlainClientCallbackHandler.class);
        String saslJaasConfig = "io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=test.username password_config=test.password;";
        this.saslClientConfigs.put("sasl.jaas.config", new Password(saslJaasConfig));
        this.saslClientConfigs.put("test.username", "some-name");
        this.saslClientConfigs.put("test.password", "some-password");
        this.server = this.createEchoServer(securityProtocol);
        this.createSelector(securityProtocol, this.saslClientConfigs);
        this.selector.connect("1", new InetSocketAddress("localhost", this.server.port()), 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, "1", ChannelState.State.AUTHENTICATION_FAILED);
        this.saslClientConfigs.put("test.username", "myuser");
        this.saslClientConfigs.put("test.password", "mypassword");
        Map clientConfigs = new TestSecurityConfig(this.saslClientConfigs).values();
        LoginManager loginManager = LoginManager.acquireLoginManager((JaasContext)JaasContext.loadClientContext((Map)clientConfigs), (String)"PLAIN", DefaultLogin.class, (Map)clientConfigs);
        loginManager.reconfigure(this.saslClientConfigs);
        this.selector.connect("2", new InetSocketAddress("localhost", this.server.port()), 4096, 4096);
        this.checkClientConnection("2");
    }

    @Test
    public void testPropsFileBasedSaslPlainClientCredentialUpdate() throws Exception {
        File credentialsFile = TestUtils.tempFile();
        this.verifyFileBasedSaslPlainClientCredentialUpdate("test.username=%s\ntest.password=%s\n", credentialsFile, "", credential -> this.updateCredential(credentialsFile, (String)credential));
    }

    @Test
    public void testJsonFileBasedSaslPlainClientCredentialUpdate() throws Exception {
        File credentialsFile = TestUtils.tempFile();
        this.verifyFileBasedSaslPlainClientCredentialUpdate("{ \"test.username\" : \"%s\", \"test.password\" : \"%s\"}", credentialsFile, "", credential -> this.updateCredential(credentialsFile, (String)credential));
    }

    @Test
    public void testSymLinkedFileBasedSaslPlainClientCredentialUpdate() throws Exception {
        File tmpDir = TestUtils.tempDirectory();
        File symLinkDir = TestUtils.tempDirectory(tmpDir.toPath(), "secrets");
        File dataDir = new File(symLinkDir, "..data");
        File credentialsFile = new File(symLinkDir, "credential.props");
        Files.createSymbolicLink(Paths.get(symLinkDir.getAbsolutePath(), credentialsFile.getName()), Paths.get(dataDir.getAbsolutePath(), credentialsFile.getName()), new FileAttribute[0]);
        AtomicInteger dirIndex = new AtomicInteger();
        this.verifyFileBasedSaslPlainClientCredentialUpdate("test.username=%s\ntest.password=%s\n", credentialsFile, "watch_path=\"" + dataDir.getAbsolutePath() + "\"", credential -> this.updateSymLinkedCredential(symLinkDir, dataDir, credentialsFile, (String)credential, dirIndex));
    }

    private void updateSymLinkedCredential(File symLinkDir, File dataDir, File credentialsFile, String credential, AtomicInteger dirIndex) {
        try {
            File oldDir = new File(symLinkDir, ".." + dirIndex.get());
            File newDir = new File(symLinkDir, ".." + dirIndex.incrementAndGet());
            Files.createDirectories(newDir.toPath(), new FileAttribute[0]);
            TestUtils.writeToFile(Paths.get(newDir.getAbsolutePath(), credentialsFile.getName()).toFile(), credential);
            Utils.delete((File)dataDir);
            Files.createSymbolicLink(dataDir.toPath(), newDir.toPath(), new FileAttribute[0]);
            Utils.delete((File)oldDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCredential(File credentialsFile, String credential) {
        try {
            TestUtils.writeToFile(credentialsFile, credential);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void verifyFileBasedSaslPlainClientCredentialUpdate(String credentialFormat, File credentialsFile, String watchConfig, Consumer<String> updateCredential) throws Exception {
        FileWatchService.useHighSensitivity();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", null, null);
        String invalidCredentials = String.format(credentialFormat, "invaliduser", "invalidpassword");
        updateCredential.accept(invalidCredentials);
        this.saslClientConfigs.put("sasl.login.callback.handler.class", FileBasedDynamicPlainLoginCallbackHandler.class);
        this.saslClientConfigs.put("sasl.client.callback.handler.class", DynamicPlainClientCallbackHandler.class);
        String saslJaasConfig = String.format("io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule required username_config=test.username password_config=test.password credentials_path=\"%s\" %s;", credentialsFile.getAbsolutePath(), watchConfig);
        this.saslClientConfigs.put("sasl.jaas.config", new Password(saslJaasConfig));
        this.server = this.createEchoServer(securityProtocol);
        this.createSelector(securityProtocol, this.saslClientConfigs);
        this.selector.connect("1", new InetSocketAddress("localhost", this.server.port()), 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, "1", ChannelState.State.AUTHENTICATION_FAILED);
        String validCredentials = String.format(credentialFormat, "myuser", "mypassword");
        Utils.sleep((long)FileWatchService.MIN_WATCH_INTERVAL.toMillis());
        updateCredential.accept(validCredentials);
        AtomicInteger nextId = new AtomicInteger(1);
        TestUtils.waitForCondition(() -> {
            String nodeId = String.valueOf(nextId.incrementAndGet());
            this.selector.connect(nodeId, new InetSocketAddress("localhost", this.server.port()), 4096, 4096);
            while (!this.selector.isChannelReady(nodeId)) {
                this.selector.poll(1000L);
                if (!this.selector.disconnected().containsKey(nodeId)) continue;
                return false;
            }
            return this.selector.isChannelReady(nodeId);
        }, "Authentication did not succeed within timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientExceptionDoesNotContainSensitiveData() throws Exception {
        InvalidScramServerCallbackHandler.reset();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("SCRAM-SHA-256");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", InvalidScramServerCallbackHandler.class.getName());
        this.server = this.createEchoServer(securityProtocol);
        try {
            InvalidScramServerCallbackHandler.sensitiveException = new IOException("Could not connect to password database localhost:8000");
            this.createAndCheckClientAuthenticationFailure(securityProtocol, "1", "SCRAM-SHA-256", null);
            InvalidScramServerCallbackHandler.sensitiveException = new SaslException("Password for existing user TestServerCallbackHandler-user is invalid");
            this.createAndCheckClientAuthenticationFailure(securityProtocol, "1", "SCRAM-SHA-256", null);
            InvalidScramServerCallbackHandler.reset();
            InvalidScramServerCallbackHandler.clientFriendlyException = new SaslAuthenticationException("Credential verification failed");
            this.createAndCheckClientAuthenticationFailure(securityProtocol, "1", "SCRAM-SHA-256", InvalidScramServerCallbackHandler.clientFriendlyException.getMessage());
        }
        finally {
            InvalidScramServerCallbackHandler.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLogMessageWithAuthenticationFailure() throws Exception {
        InvalidScramServerCallbackHandler.reset();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Collections.singletonList("SCRAM-SHA-256"));
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("SCRAM-SHA-256");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", InvalidScramServerCallbackHandler.class.getName());
        this.server = this.createEchoServer(securityProtocol, 200);
        try {
            InvalidScramServerCallbackHandler.sensitiveException = new IOException("Could not connect to password database locahost:8000");
            this.createClientConnection(securityProtocol, "1");
            String errorMessage = "Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256";
            String logMessage = "errorMessage=Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256 caused by Authentication failed: Credentials could not be obtained";
            NetworkTestUtils.waitTillServerConnectionWithAuthFailure(this.server.selector(), this.selector, errorMessage, logMessage, false);
        }
        finally {
            InvalidScramServerCallbackHandler.reset();
        }
    }

    @Test
    public void testMechanismPluggability() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("DIGEST-MD5", Arrays.asList("DIGEST-MD5"));
        this.configureDigestMd5ServerCallback(securityProtocol);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleServerMechanisms() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("DIGEST-MD5", Arrays.asList("DIGEST-MD5", "PLAIN", "SCRAM-SHA-256"));
        this.configureDigestMd5ServerCallback(securityProtocol);
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        String node1 = "1";
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.createAndCheckClientConnection(securityProtocol, node1);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "PLAIN");
        Selector selector2 = null;
        Selector selector3 = null;
        try {
            String node2 = "2";
            this.saslClientConfigs.put("sasl.mechanism", "DIGEST-MD5");
            this.createSelector(securityProtocol, this.saslClientConfigs);
            selector2 = this.selector;
            InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
            this.selector.connect(node2, addr, 4096, 4096);
            NetworkTestUtils.checkClientConnection(this.selector, node2, 100, 10);
            this.selector = null;
            this.server.verifyAuthenticationMetrics(2, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, "DIGEST-MD5");
            String node3 = "3";
            this.saslClientConfigs.put("sasl.mechanism", "SCRAM-SHA-256");
            this.createSelector(securityProtocol, this.saslClientConfigs);
            selector3 = this.selector;
            this.selector.connect(node3, new InetSocketAddress("localhost", this.server.port()), 4096, 4096);
            NetworkTestUtils.checkClientConnection(this.selector, node3, 100, 10);
            this.server.verifyAuthenticationMetrics(3, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, "SCRAM-SHA-256");
            SaslAuthenticatorTest.delay(110L);
            this.server.verifyReauthenticationMetrics(0, 0);
            NetworkTestUtils.checkClientConnection(selector2, node2, 100, 10);
            this.server.verifyReauthenticationMetrics(1, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, "DIGEST-MD5", EnumSet.of(NioEchoServer.MetricType.RATE));
            NetworkTestUtils.checkClientConnection(selector3, node3, 100, 10);
            this.server.verifyReauthenticationMetrics(2, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, "SCRAM-SHA-256", EnumSet.of(NioEchoServer.MetricType.RATE));
        }
        finally {
            if (selector2 != null) {
                selector2.close();
            }
            if (selector3 != null) {
                selector3.close();
            }
        }
    }

    @Test
    public void testValidSaslScramSha256() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        this.checkAuthenticationAndReauthentication(securityProtocol, "0", "SCRAM-SHA-256");
    }

    @Test
    public void testValidSaslScramMechanisms() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("SCRAM-SHA-256", new ArrayList<String>(ScramMechanism.mechanismNames()));
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        for (String mechanism : ScramMechanism.mechanismNames()) {
            this.saslClientConfigs.put("sasl.mechanism", mechanism);
            this.createAndCheckClientConnection(securityProtocol, "node-" + mechanism);
        }
    }

    @Test
    public void testInvalidPasswordSaslScram() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("username", "myuser");
        options.put("password", "invalidpassword");
        jaasConfig.createOrUpdateEntry("KafkaClient", ScramLoginModule.class.getName(), options);
        String node = "0";
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "SCRAM-SHA-256", null);
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "SCRAM-SHA-256");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testUnknownUserSaslScram() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("username", "unknownUser");
        options.put("password", "mypassword");
        jaasConfig.createOrUpdateEntry("KafkaClient", ScramLoginModule.class.getName(), options);
        String node = "0";
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "SCRAM-SHA-256", null);
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "SCRAM-SHA-256");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testUserCredentialsUnavailableForScramMechanism() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("SCRAM-SHA-256", new ArrayList<String>(ScramMechanism.mechanismNames()));
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        this.server.credentialCache().cache(ScramMechanism.SCRAM_SHA_256.mechanismName(), ScramCredential.class).remove("myuser");
        String node = "1";
        this.saslClientConfigs.put("sasl.mechanism", "SCRAM-SHA-256");
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "SCRAM-SHA-256", null);
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "SCRAM-SHA-256");
        this.saslClientConfigs.put("sasl.mechanism", "SCRAM-SHA-512");
        this.createAndCheckClientConnection(securityProtocol, "2");
        this.server.verifyAuthenticationMetrics(1, 1);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "SCRAM-SHA-512");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testScramUsernameWithSpecialCharacters() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        String username = "special user= test,scram";
        String password = username + "-password";
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("username", username);
        options.put("password", password);
        jaasConfig.createOrUpdateEntry("KafkaClient", ScramLoginModule.class.getName(), options);
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache(username, password);
        this.createAndCheckClientConnection(securityProtocol, "0");
    }

    @Test
    public void testTokenAuthenticationOverSaslScram() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        String tokenId = "token1";
        String tokenHmac = "abcdefghijkl";
        options.put("username", tokenId);
        options.put("password", tokenHmac);
        options.put("tokenauth", "true");
        jaasConfig.createOrUpdateEntry("KafkaClient", ScramLoginModule.class.getName(), options);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnectionFailure(securityProtocol, "0");
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "SCRAM-SHA-256");
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:Owner");
        KafkaPrincipal renewer = SecurityUtils.parseKafkaPrincipal((String)"User:Renewer1");
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, Collections.singleton(renewer), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        this.server.tokenCache().addToken(tokenId, tokenInfo);
        this.createAndCheckClientConnectionFailure(securityProtocol, "0");
        this.server.verifyAuthenticationMetrics(0, 2);
        this.server.verifyAuthenticationMetricsForMechanism(0, 2, "SCRAM-SHA-256");
        this.updateTokenCredentialCache(tokenId, tokenHmac);
        this.createAndCheckClientConnection(securityProtocol, "0");
        this.server.verifyAuthenticationMetrics(1, 2);
        this.server.verifyAuthenticationMetricsForMechanism(1, 2, "SCRAM-SHA-256");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    @Test
    public void testTokenReauthenticationOverSaslScram() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        String tokenId = "token1";
        String tokenHmac = "abcdefghijkl";
        options.put("username", tokenId);
        options.put("password", tokenHmac);
        options.put("tokenauth", "true");
        jaasConfig.createOrUpdateEntry("KafkaClient", ScramLoginModule.class.getName(), options);
        this.saslServerConfigs.put("connections.max.reauth.ms", Long.MAX_VALUE);
        final Function<Integer, Long> tokenLifetime = callNum -> (long)(10 * callNum) * 100L;
        DelegationTokenCache tokenCache = new DelegationTokenCache(ScramMechanism.mechanismNames()){
            int callNum;
            {
                super(x0);
                this.callNum = 0;
            }

            public TokenInformation token(String tokenId) {
                TokenInformation baseTokenInfo = super.token(tokenId);
                long thisLifetimeMs = System.currentTimeMillis() + (Long)tokenLifetime.apply(++this.callNum);
                TokenInformation retvalTokenInfo = new TokenInformation(baseTokenInfo.tokenId(), baseTokenInfo.owner(), baseTokenInfo.renewers(), baseTokenInfo.issueTimestamp(), thisLifetimeMs, thisLifetimeMs);
                return retvalTokenInfo;
            }
        };
        this.server = this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, tokenCache);
        KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)"User:Owner");
        KafkaPrincipal renewer = SecurityUtils.parseKafkaPrincipal((String)"User:Renewer1");
        TokenInformation tokenInfo = new TokenInformation(tokenId, owner, Collections.singleton(renewer), System.currentTimeMillis(), System.currentTimeMillis(), System.currentTimeMillis());
        this.server.tokenCache().addToken(tokenId, tokenInfo);
        this.updateTokenCredentialCache(tokenId, tokenHmac);
        this.createClientConnection(securityProtocol, "0");
        this.checkClientConnection("0");
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "SCRAM-SHA-256");
        this.server.verifyReauthenticationMetrics(0, 0);
        SaslAuthenticatorTest.delay(tokenLifetime.apply(1));
        this.checkClientConnection("0");
        this.server.verifyReauthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "SCRAM-SHA-256", EnumSet.of(NioEchoServer.MetricType.RATE));
    }

    @Test
    public void testUnauthenticatedApiVersionsRequestOverPlaintextHandshakeVersion0() throws Exception {
        this.testUnauthenticatedApiVersionsRequest(SecurityProtocol.SASL_PLAINTEXT, (short)0);
    }

    @Test
    public void testUnauthenticatedApiVersionsRequestOverPlaintextHandshakeVersion1() throws Exception {
        this.testUnauthenticatedApiVersionsRequest(SecurityProtocol.SASL_PLAINTEXT, (short)1);
    }

    @Test
    public void testUnauthenticatedApiVersionsRequestOverSslHandshakeVersion0() throws Exception {
        this.testUnauthenticatedApiVersionsRequest(SecurityProtocol.SASL_SSL, (short)0);
    }

    @Test
    public void testUnauthenticatedApiVersionsRequestOverSslHandshakeVersion1() throws Exception {
        this.testUnauthenticatedApiVersionsRequest(SecurityProtocol.SASL_SSL, (short)1);
    }

    @Test
    public void testApiVersionsRequestWithServerUnsupportedVersion() throws Exception {
        short handshakeVersion = ApiKeys.SASL_HANDSHAKE.latestVersion();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node = "1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node);
        RequestHeader header = new RequestHeader(new RequestHeaderData().setRequestApiKey(ApiKeys.API_VERSIONS.id).setRequestApiVersion((short)Short.MAX_VALUE).setClientId("someclient").setCorrelationId(1), 2);
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        this.selector.send(new NetworkSend(node, request.toSend(header)));
        ByteBuffer responseBuffer = this.waitForResponse();
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion((short)0));
        ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)responseBuffer, (short)0, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)response.data().errorCode());
        ApiVersionsResponseData.ApiVersion apiVersion = response.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertNotNull((Object)apiVersion);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
        this.sendVersionRequestReceiveResponse(node);
        this.sendHandshakeRequestReceiveResponse(node, handshakeVersion);
        this.authenticateUsingSaslPlainAndCheckConnection(node, handshakeVersion > 0);
    }

    @Test
    public void testSaslUnsupportedClientVersions() throws Exception {
        this.configureMechanisms("SCRAM-SHA-512", Arrays.asList("SCRAM-SHA-512"));
        this.server = this.startServerApiVersionsUnsupportedByClient(SecurityProtocol.SASL_SSL, "SCRAM-SHA-512");
        this.updateScramCredentialCache("myuser", "mypassword");
        String node = "0";
        this.createClientConnection(SecurityProtocol.SASL_SSL, "SCRAM-SHA-512", node, true);
        NetworkTestUtils.checkClientConnection(this.selector, "0", 100, 10);
    }

    @Test
    public void testInvalidApiVersionsRequest() throws Exception {
        short handshakeVersion = ApiKeys.SASL_HANDSHAKE.latestVersion();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node = "1";
        short version = ApiKeys.API_VERSIONS.latestVersion();
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node);
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, version, "someclient", 1);
        ApiVersionsRequest request = new ApiVersionsRequest(new ApiVersionsRequestData().setClientSoftwareName("  ").setClientSoftwareVersion("   "), version);
        this.selector.send(new NetworkSend(node, request.toSend(header)));
        ByteBuffer responseBuffer = this.waitForResponse();
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(version));
        ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)responseBuffer, (short)version, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)response.data().errorCode());
        Assertions.assertEquals((int)0, (int)this.saslAuthenticateRequestCallback.callCount.get());
        this.sendVersionRequestReceiveResponse(node);
        this.sendHandshakeRequestReceiveResponse(node, handshakeVersion);
        this.authenticateUsingSaslPlainAndCheckConnection(node, handshakeVersion > 0);
        Assertions.assertEquals((int)0, (int)this.saslAuthenticateRequestCallback.callCount.get());
    }

    @Test
    public void testForBrokenSaslHandshakeVersionBump() {
        Assertions.assertEquals((int)1, (int)ApiKeys.SASL_HANDSHAKE.latestVersion(), (String)"It is not possible to easily bump SASL_HANDSHAKE schema due to improper version negotiation in clients < 2.5. Please see https://issues.apache.org/jira/browse/KAFKA-9577");
    }

    @Test
    public void testValidApiVersionsRequest() throws Exception {
        short handshakeVersion = ApiKeys.SASL_HANDSHAKE.latestVersion();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node = "1";
        short version = ApiKeys.API_VERSIONS.latestVersion();
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node);
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, version, "someclient", 1);
        ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
        this.selector.send(new NetworkSend(node, request.toSend(header)));
        ByteBuffer responseBuffer = this.waitForResponse();
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(version));
        ApiVersionsResponse response = ApiVersionsResponse.parse((ByteBuffer)responseBuffer, (short)version, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        this.sendHandshakeRequestReceiveResponse(node, handshakeVersion);
        this.authenticateUsingSaslPlainAndCheckConnection(node, handshakeVersion > 0);
    }

    @Test
    public void testSaslHandshakeRequestWithUnsupportedVersion() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node1);
        SaslHandshakeRequest request = this.buildSaslHandshakeRequest("PLAIN", ApiKeys.SASL_HANDSHAKE.latestVersion());
        RequestHeader header = new RequestHeader(ApiKeys.SASL_HANDSHAKE, Short.MAX_VALUE, "someclient", 2);
        this.selector.send(new NetworkSend(node1, request.toSend(header)));
        NetworkTestUtils.waitForChannelClose(this.selector, node1, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good1");
    }

    @Test
    public void testInvalidSaslPacket() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node1);
        this.sendHandshakeRequestReceiveResponse(node1, (short)1);
        Random random = new Random();
        byte[] bytes = new byte[1024];
        random.nextBytes(bytes);
        this.selector.send(new NetworkSend(node1, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(bytes))));
        NetworkTestUtils.waitForChannelClose(this.selector, node1, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good1");
        String node2 = "invalid2";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node2);
        random.nextBytes(bytes);
        this.selector.send(new NetworkSend(node2, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(bytes))));
        NetworkTestUtils.waitForChannelClose(this.selector, node2, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good2");
    }

    @Test
    public void testInvalidApiVersionsRequestSequence() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node1);
        this.sendHandshakeRequestReceiveResponse(node1, (short)1);
        ApiVersionsRequest request = this.createApiVersionsRequestV0();
        RequestHeader versionsHeader = new RequestHeader(ApiKeys.API_VERSIONS, request.version(), "someclient", 2);
        this.selector.send(new NetworkSend(node1, request.toSend(versionsHeader)));
        NetworkTestUtils.waitForChannelClose(this.selector, node1, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good1");
    }

    @Test
    public void testPacketSizeTooBig() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node1);
        this.sendHandshakeRequestReceiveResponse(node1, (short)1);
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.putInt(Integer.MAX_VALUE);
        buffer.put(new byte[buffer.capacity() - 4]);
        buffer.rewind();
        this.selector.send(new NetworkSend(node1, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)buffer)));
        NetworkTestUtils.waitForChannelClose(this.selector, node1, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good1");
        String node2 = "invalid2";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node2);
        buffer.clear();
        buffer.putInt(Integer.MAX_VALUE);
        buffer.put(new byte[buffer.capacity() - 4]);
        buffer.rewind();
        this.selector.send(new NetworkSend(node2, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)buffer)));
        NetworkTestUtils.waitForChannelClose(this.selector, node2, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good2");
    }

    @Test
    public void testDisallowedKafkaRequestsBeforeAuthentication() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node1 = "invalid1";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node1);
        MetadataRequest metadataRequest1 = (MetadataRequest)new MetadataRequest.Builder(Collections.singletonList("sometopic"), true).build();
        RequestHeader metadataRequestHeader1 = new RequestHeader(ApiKeys.METADATA, metadataRequest1.version(), "someclient", 1);
        this.selector.send(new NetworkSend(node1, metadataRequest1.toSend(metadataRequestHeader1)));
        NetworkTestUtils.waitForChannelClose(this.selector, node1, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good1");
        String node2 = "invalid2";
        this.createClientConnection(SecurityProtocol.PLAINTEXT, node2);
        this.sendHandshakeRequestReceiveResponse(node2, (short)1);
        MetadataRequest metadataRequest2 = (MetadataRequest)new MetadataRequest.Builder(Collections.singletonList("sometopic"), true).build();
        RequestHeader metadataRequestHeader2 = new RequestHeader(ApiKeys.METADATA, metadataRequest2.version(), "someclient", 2);
        this.selector.send(new NetworkSend(node2, metadataRequest2.toSend(metadataRequestHeader2)));
        NetworkTestUtils.waitForChannelClose(this.selector, node2, ChannelState.READY.state());
        this.selector.close();
        this.createAndCheckClientConnection(securityProtocol, "good2");
    }

    @Test
    public void testInvalidLoginModule() throws Exception {
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        jaasConfig.createOrUpdateEntry("KafkaClient", "InvalidLoginModule", TestJaasConfig.defaultClientOptions());
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.server = this.createEchoServer(securityProtocol);
        try {
            this.createSelector(securityProtocol, this.saslClientConfigs);
            Assertions.fail((String)"SASL/PLAIN channel created without valid login module");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
    }

    @Test
    public void testClientAuthenticateCallbackHandler() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        this.saslClientConfigs.put("sasl.client.callback.handler.class", TestClientCallbackHandler.class.getName());
        jaasConfig.setClientOptions("PLAIN", "", "");
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("user_TestClientCallbackHandler-user", "TestClientCallbackHandler-password");
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), options);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, "good");
        options.clear();
        options.put("user_TestClientCallbackHandler-user", "invalid-password");
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), options);
        this.createAndCheckClientConnectionFailure(securityProtocol, "invalid");
    }

    @Test
    public void testServerAuthenticateCallbackHandler() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("PLAIN");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", TestServerCallbackHandler.class.getName());
        this.server = this.createEchoServer(securityProtocol);
        jaasConfig.setClientOptions("PLAIN", "TestServerCallbackHandler-user", "TestServerCallbackHandler-password");
        this.createAndCheckClientConnection(securityProtocol, "good");
        jaasConfig.setClientOptions("PLAIN", "myuser", "invalid-password");
        this.createAndCheckClientConnectionFailure(securityProtocol, "invalid");
    }

    @Test
    public void testAuthenticateCallbackHandlerMechanisms() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("DIGEST-MD5", Arrays.asList("DIGEST-MD5", "PLAIN"));
        this.saslServerConfigs.put("plain.sasl.server.callback.handler.class", TestServerCallbackHandler.class);
        this.saslServerConfigs.put("digest-md5.sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnectionFailure(securityProtocol, "invalid");
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.remove("plain.sasl.server.callback.handler.class");
        this.saslServerConfigs.remove("digest-md5.sasl.server.callback.handler.class");
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("plain") + "sasl.server.callback.handler.class", TestServerCallbackHandler.class);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("digest-md5") + "sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class);
        this.server.close();
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, "good-digest-md5");
        jaasConfig.setClientOptions("PLAIN", "TestServerCallbackHandler-user", "TestServerCallbackHandler-password");
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.createAndCheckClientConnection(securityProtocol, "good-plain");
    }

    @Test
    public void testClientLoginOverride() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.setClientOptions("PLAIN", "invaliduser", "invalidpassword");
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("sasl.login.class", TestLogin.class.getName());
        this.createAndCheckClientConnection(securityProtocol, "1");
        Assertions.assertEquals((int)1, (int)TestLogin.loginCount.get());
        this.saslClientConfigs.remove("sasl.login.class");
        this.createAndCheckClientConnectionFailure(securityProtocol, "invalid");
        Assertions.assertEquals((int)1, (int)TestLogin.loginCount.get());
    }

    @Test
    public void testServerLoginOverride() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        String prefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("PLAIN");
        this.saslServerConfigs.put(prefix + "sasl.login.class", TestLogin.class.getName());
        this.server = this.createEchoServer(securityProtocol);
        Assertions.assertEquals((int)1, (int)TestLogin.loginCount.get());
        this.createAndCheckClientConnection(securityProtocol, "1");
        Assertions.assertEquals((int)1, (int)TestLogin.loginCount.get());
    }

    @Test
    public void testClientLoginCallbackOverride() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.createOrUpdateEntry("KafkaClient", TestPlainLoginModule.class.getName(), Collections.emptyMap());
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("sasl.login.callback.handler.class", TestLoginCallbackHandler.class.getName());
        this.createAndCheckClientConnection(securityProtocol, "1");
        this.saslClientConfigs.remove("sasl.login.callback.handler.class");
        try {
            this.createClientConnection(securityProtocol, "invalid");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof LoginException), (String)("Unexpected exception " + e.getCause()));
        }
    }

    @Test
    public void testServerLoginCallbackOverride() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.createOrUpdateEntry("KafkaServer", TestPlainLoginModule.class.getName(), Collections.emptyMap());
        jaasConfig.setClientOptions("PLAIN", "TestServerCallbackHandler-user", "TestServerCallbackHandler-password");
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        String prefix = listenerName.saslMechanismConfigPrefix("PLAIN");
        this.saslServerConfigs.put(prefix + "sasl.server.callback.handler.class", TestServerCallbackHandler.class);
        Class<TestLoginCallbackHandler> loginCallback = TestLoginCallbackHandler.class;
        try {
            this.createEchoServer(securityProtocol);
            Assertions.fail((String)"Should have failed to create server with default login handler");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
        try {
            this.saslServerConfigs.put("sasl.login.callback.handler.class", loginCallback);
            this.createEchoServer(securityProtocol);
            Assertions.fail((String)"Should have failed to create server with login handler config without listener+mechanism prefix");
        }
        catch (KafkaException e) {
            this.saslServerConfigs.remove("sasl.login.callback.handler.class");
        }
        try {
            this.saslServerConfigs.put("plain.sasl.login.callback.handler.class", loginCallback);
            this.createEchoServer(securityProtocol);
            Assertions.fail((String)"Should have failed to create server with login handler config without listener prefix");
        }
        catch (KafkaException e) {
            this.saslServerConfigs.remove("plain.sasl.login.callback.handler.class");
        }
        try {
            this.saslServerConfigs.put(listenerName.configPrefix() + "sasl.login.callback.handler.class", loginCallback);
            this.createEchoServer(securityProtocol);
            Assertions.fail((String)"Should have failed to create server with login handler config without mechanism prefix");
        }
        catch (KafkaException e) {
            this.saslServerConfigs.remove("plain.sasl.login.callback.handler.class");
        }
        this.saslServerConfigs.put(prefix + "sasl.login.callback.handler.class", loginCallback);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, "1");
    }

    @Test
    public void testDisabledMechanism() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Arrays.asList("DIGEST-MD5"));
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnectionFailure(securityProtocol, node);
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "DEFAULT");
        this.server.verifyReauthenticationMetrics(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidMechanism() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.saslClientConfigs.put("sasl.mechanism", "INVALID");
        this.server = this.createEchoServer(securityProtocol);
        try {
            this.createAndCheckClientConnectionFailure(securityProtocol, node);
            Assertions.fail((String)"Did not generate exception prior to creating channel");
        }
        catch (IOException expected) {
            this.server.verifyAuthenticationMetrics(0, 0);
            this.server.verifyAuthenticationMetricsForMechanism(0, 0, "PLAIN");
            this.server.verifyReauthenticationMetrics(0, 0);
            Throwable underlyingCause = expected.getCause().getCause().getCause();
            Assertions.assertEquals(SaslAuthenticationException.class, underlyingCause.getClass());
            Assertions.assertEquals((Object)"Failed to create SaslClient with mechanism INVALID", (Object)underlyingCause.getMessage());
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    @Test
    public void testClientDynamicJaasConfiguration() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.saslServerConfigs.put("sasl.enabled.mechanisms", Arrays.asList("PLAIN"));
        HashMap<String, Object> serverOptions = new HashMap<String, Object>();
        serverOptions.put("user_user1", "user1-secret");
        serverOptions.put("user_user2", "user2-secret");
        TestJaasConfig staticJaasConfig = new TestJaasConfig();
        staticJaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), serverOptions);
        staticJaasConfig.setClientOptions("PLAIN", "user1", "invalidpassword");
        Configuration.setConfiguration(staticJaasConfig);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnectionFailure(securityProtocol, "1");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "user1", "user1-secret"));
        this.createAndCheckClientConnection(securityProtocol, "2");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "user1", "user2-secret"));
        this.createAndCheckClientConnectionFailure(securityProtocol, "3");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "user2", "user2-secret"));
        this.createAndCheckClientConnection(securityProtocol, "4");
        String module1 = TestJaasConfig.jaasConfigProperty("PLAIN", "user1", "user1-secret").value();
        String module2 = TestJaasConfig.jaasConfigProperty("PLAIN", "user2", "user2-secret").value();
        this.saslClientConfigs.put("sasl.jaas.config", new Password(module1 + " " + module2));
        try {
            this.createClientConnection(securityProtocol, "1");
            Assertions.fail((String)"Connection created with multiple login modules in sasl.jaas.config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testServerDynamicJaasConfiguration() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.saslServerConfigs.put("sasl.enabled.mechanisms", Arrays.asList("PLAIN"));
        HashMap<String, Object> serverOptions = new HashMap<String, Object>();
        serverOptions.put("user_user1", "user1-secret");
        serverOptions.put("user_user2", "user2-secret");
        this.saslServerConfigs.put("listener.name.sasl_ssl.plain.sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", serverOptions));
        TestJaasConfig staticJaasConfig = new TestJaasConfig();
        staticJaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), Collections.emptyMap());
        staticJaasConfig.setClientOptions("PLAIN", "user1", "user1-secret");
        Configuration.setConfiguration(staticJaasConfig);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, "1");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "user2", "user2-secret"));
        this.createAndCheckClientConnection(securityProtocol, "2");
    }

    @Test
    public void testJaasConfigurationForListener() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.saslClientConfigs.put("sasl.mechanism", "PLAIN");
        this.saslServerConfigs.put("sasl.enabled.mechanisms", Arrays.asList("PLAIN"));
        TestJaasConfig staticJaasConfig = new TestJaasConfig();
        HashMap<String, Object> globalServerOptions = new HashMap<String, Object>();
        globalServerOptions.put("user_global1", "gsecret1");
        globalServerOptions.put("user_global2", "gsecret2");
        staticJaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), globalServerOptions);
        HashMap<String, Object> clientListenerServerOptions = new HashMap<String, Object>();
        clientListenerServerOptions.put("user_client1", "csecret1");
        clientListenerServerOptions.put("user_client2", "csecret2");
        String clientJaasEntryName = "client.KafkaServer";
        staticJaasConfig.createOrUpdateEntry(clientJaasEntryName, PlainLoginModule.class.getName(), clientListenerServerOptions);
        Configuration.setConfiguration(staticJaasConfig);
        this.server = this.createEchoServer(new ListenerName("client"), securityProtocol);
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "client1", "csecret1"));
        this.createAndCheckClientConnection(securityProtocol, "1");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "global1", "gsecret1"));
        this.createAndCheckClientConnectionFailure(securityProtocol, "2");
        this.server.close();
        this.server = this.createEchoServer(new ListenerName("other"), securityProtocol);
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "global1", "gsecret1"));
        this.createAndCheckClientConnection(securityProtocol, "3");
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("PLAIN", "client1", "csecret1"));
        this.createAndCheckClientConnectionFailure(securityProtocol, "4");
    }

    @Test
    public void oldSaslPlainPlaintextServerWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(false, true, SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
    }

    @Test
    public void oldSaslPlainPlaintextClientWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(true, false, SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
    }

    @Test
    public void oldSaslScramPlaintextServerWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(false, true, SecurityProtocol.SASL_PLAINTEXT, "SCRAM-SHA-256");
    }

    @Test
    public void oldSaslScramPlaintextClientWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(true, false, SecurityProtocol.SASL_PLAINTEXT, "SCRAM-SHA-256");
    }

    @Test
    public void oldSaslPlainSslServerWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(false, true, SecurityProtocol.SASL_SSL, "PLAIN");
    }

    @Test
    public void oldSaslPlainSslClientWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(true, false, SecurityProtocol.SASL_SSL, "PLAIN");
    }

    @Test
    public void oldSaslScramSslServerWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(false, true, SecurityProtocol.SASL_SSL, "SCRAM-SHA-512");
    }

    @Test
    public void oldSaslScramSslClientWithoutSaslAuthenticateHeader() throws Exception {
        this.verifySaslAuthenticateHeaderInterop(true, false, SecurityProtocol.SASL_SSL, "SCRAM-SHA-512");
    }

    @Test
    public void oldSaslPlainPlaintextServerWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(false, true, SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
    }

    @Test
    public void oldSaslPlainPlaintextClientWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(true, false, SecurityProtocol.SASL_PLAINTEXT, "PLAIN");
    }

    @Test
    public void oldSaslScramPlaintextServerWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(false, true, SecurityProtocol.SASL_PLAINTEXT, "SCRAM-SHA-256");
    }

    @Test
    public void oldSaslScramPlaintextClientWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(true, false, SecurityProtocol.SASL_PLAINTEXT, "SCRAM-SHA-256");
    }

    @Test
    public void oldSaslPlainSslServerWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(false, true, SecurityProtocol.SASL_SSL, "PLAIN");
    }

    @Test
    public void oldSaslPlainSslClientWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(true, false, SecurityProtocol.SASL_SSL, "PLAIN");
    }

    @Test
    public void oldSaslScramSslServerWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(false, true, SecurityProtocol.SASL_SSL, "SCRAM-SHA-512");
    }

    @Test
    public void oldSaslScramSslClientWithoutSaslAuthenticateHeaderFailure() throws Exception {
        this.verifySaslAuthenticateHeaderInteropWithFailure(true, false, SecurityProtocol.SASL_SSL, "SCRAM-SHA-512");
    }

    @Test
    public void testValidSaslOauthBearerMechanism() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("OAUTHBEARER", Arrays.asList("OAUTHBEARER"));
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, node);
    }

    @Test
    public void testCannotReauthenticateWithDifferentPrincipal() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.saslClientConfigs.put("sasl.login.callback.handler.class", AlternateLoginCallbackHandler.class.getName());
        this.configureMechanisms("OAUTHBEARER", Arrays.asList("OAUTHBEARER"));
        this.server = this.createEchoServer(securityProtocol);
        this.createClientConnection(securityProtocol, node);
        this.checkClientConnection(node);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyReauthenticationMetrics(0, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "OAUTHBEARER");
        SaslAuthenticatorTest.delay(1000L);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.checkClientConnection(node));
        this.server.verifyReauthenticationMetrics(0, 1);
    }

    @Test
    public void testAsyncAuthDelayInSynchronous() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("OAUTHBEARER", Collections.singletonList("OAUTHBEARER"));
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("OAUTHBEARER") + "sasl.server.callback.handler.class", DelayableValidateCallbackHandler.class);
        this.saslServerConfigs.put("delayMs", "500");
        this.saslServerConfigs.put("interruptBehavior", DelayableValidateCallbackHandler.InterruptBehavior.ignore.toString());
        this.server = this.createEchoServer(securityProtocol);
        String node = "0";
        this.createClientConnection(securityProtocol, node);
        this.checkClientConnection(node);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "OAUTHBEARER");
    }

    @Test
    public void testAsyncAuthDelay() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("OAUTHBEARER", Collections.singletonList("OAUTHBEARER"));
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("OAUTHBEARER") + "sasl.server.callback.handler.class", DelayableValidateCallbackHandler.class);
        this.saslServerConfigs.put("sasl.server.authn.async.enable", true);
        this.saslServerConfigs.put("interruptBehavior", DelayableValidateCallbackHandler.InterruptBehavior.ignore.toString());
        this.saslServerConfigs.put("delayMs", "500");
        this.server = this.createEchoServer(securityProtocol);
        String node = "0";
        this.createClientConnection(securityProtocol, node);
        this.checkClientConnection(node);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "OAUTHBEARER");
    }

    @Test
    @Disabled(value="KSECURITY-1592")
    public void testAsyncAuthTimeout() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.configureMechanisms("OAUTHBEARER", Collections.singletonList("OAUTHBEARER"));
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix("OAUTHBEARER") + "sasl.server.callback.handler.class", DelayableValidateCallbackHandler.class);
        this.saslServerConfigs.put("sasl.server.authn.async.enable", true);
        this.saslServerConfigs.put("sasl.server.authn.async.timeout.ms", 250L);
        this.saslServerConfigs.put("delayMs", "500");
        this.saslServerConfigs.put("interruptBehavior", DelayableValidateCallbackHandler.InterruptBehavior.error.toString());
        this.server = this.createEchoServer(securityProtocol);
        String node = "0";
        this.createAndCheckClientAuthenticationFailure(securityProtocol, node, "OAUTHBEARER", "Interrupted while communicating with external auth system");
        this.server.verifyAuthenticationMetrics(0, 1);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "OAUTHBEARER");
        this.server.waitForMetrics("timed-out-authentication", 1.0, EnumSet.of(NioEchoServer.MetricType.TOTAL, NioEchoServer.MetricType.RATE));
    }

    @Test
    public void testAsyncAuthBadCredentials() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        String mechanism = "OAUTHBEARER";
        TestJaasConfig jaasConfig = this.configureMechanisms(mechanism, Collections.singletonList(mechanism));
        jaasConfig.setClientOptions(mechanism, "myuser", "invalidpassword");
        ListenerName listener = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        this.saslServerConfigs.put(listener.saslMechanismConfigPrefix(mechanism) + "sasl.server.callback.handler.class", DelayableValidateCallbackHandler.class);
        this.saslServerConfigs.put("sasl.server.authn.async.enable", true);
        this.saslServerConfigs.put("delayMs", "500");
        this.server = this.createEchoServer(securityProtocol);
        String node = "0";
        ChannelState finalState = this.createAndCheckClientConnectionFailure(securityProtocol, node);
        AuthenticationException exception = finalState.exception();
        Assertions.assertTrue((boolean)(exception instanceof SaslAuthenticationException), (String)("Invalid exception class " + ((Object)((Object)exception)).getClass()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("No OAuth Bearer tokens in Subject's private credentials"));
    }

    @Test
    public void testCorrelationId() {
        SaslClientAuthenticator authenticator = new SaslClientAuthenticator(Collections.emptyMap(), null, "node", null, null, null, "plain", false, null, null, new LogContext(), null){

            SaslClient createSaslClient() {
                return null;
            }
        };
        int count = 14;
        Set<Integer> ids = IntStream.range(0, count).mapToObj(i -> authenticator.nextCorrelationId()).collect(Collectors.toSet());
        Assertions.assertEquals((int)8, (int)ids.size());
        ids.forEach(id -> {
            Assertions.assertTrue((id >= 0x7FFFFFF8 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)SaslClientAuthenticator.isReserved((int)id));
        });
    }

    @Test
    public void testConvertListOffsetResponseToSaslHandshakeResponse() {
        ListOffsetsResponseData data = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setPartitionIndex(0).setOffset(0L).setTimestamp(0L)))));
        ListOffsetsResponse response = new ListOffsetsResponse(data);
        ByteBuffer buffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)response, ApiKeys.LIST_OFFSETS.latestVersion(), 0);
        RequestHeader header0 = new RequestHeader(ApiKeys.LIST_OFFSETS, ApiKeys.LIST_OFFSETS.latestVersion(), "id", 0x7FFFFFF8);
        Assertions.assertThrows(SchemaException.class, () -> NetworkClient.parseResponse((ByteBuffer)buffer.duplicate(), (RequestHeader)header0, (ClientInterceptor)NetworkClient.DEFAULT_INTERCEPTOR, (long)0L, (long)0L));
        RequestHeader header1 = new RequestHeader(ApiKeys.LIST_OFFSETS, ApiKeys.LIST_OFFSETS.latestVersion(), "id", 1);
        Assertions.assertThrows(IllegalStateException.class, () -> NetworkClient.parseResponse((ByteBuffer)buffer.duplicate(), (RequestHeader)header1, (ClientInterceptor)NetworkClient.DEFAULT_INTERCEPTOR, (long)0L, (long)0L));
    }

    @Test
    public void testCannotReauthenticateWithDifferentMechanism() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("DIGEST-MD5", Arrays.asList("DIGEST-MD5", "PLAIN"));
        this.configureDigestMd5ServerCallback(securityProtocol);
        this.server = this.createEchoServer(securityProtocol);
        String saslMechanism = (String)this.saslClientConfigs.get("sasl.mechanism");
        Map configs = new TestSecurityConfig(this.saslClientConfigs).values();
        this.channelBuilder = new AlternateSaslChannelBuilder(Mode.CLIENT, Collections.singletonMap(saslMechanism, JaasContext.loadClientContext((Map)configs)), securityProtocol, null, false, saslMechanism, true, this.credentialCache, null, time);
        this.channelBuilder.configure(configs);
        this.selector = NetworkTestUtils.createSelector(this.channelBuilder, time);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        this.checkClientConnection(node);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "DIGEST-MD5");
        this.server.verifyReauthenticationMetrics(0, 0);
        SaslAuthenticatorTest.delay(110L);
        Assertions.assertThrows(AssertionFailedError.class, () -> this.checkClientConnection(node));
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(0, 1, "DEFAULT");
        this.server.verifyReauthenticationMetrics(0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCannotReauthenticateAgainFasterThanOneSecond() throws Exception {
        String node = "0";
        time = new MockTime();
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("OAUTHBEARER", Arrays.asList("OAUTHBEARER"));
        this.server = this.createEchoServer(securityProtocol);
        try {
            this.createClientConnection(securityProtocol, node);
            this.checkClientConnection(node);
            this.server.verifyAuthenticationMetrics(1, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, "OAUTHBEARER");
            this.server.verifyReauthenticationMetrics(0, 0);
            time.sleep(110L);
            this.checkClientConnection(node);
            this.server.verifyAuthenticationMetrics(1, 0);
            this.server.verifyAuthenticationMetricsForMechanism(2, 0, "OAUTHBEARER");
            this.server.verifyReauthenticationMetrics(1, 0);
            time.sleep(110L);
            AssertionFailedError exception = (AssertionFailedError)Assertions.assertThrows(AssertionFailedError.class, () -> NetworkTestUtils.checkClientConnection(this.selector, node, 1, 1));
            String expectedResponseTextRegex = "\\w-" + node;
            String receivedResponseTextRegex = ".*OAUTHBEARER";
            Assertions.assertTrue((boolean)exception.getMessage().matches(".*<" + expectedResponseTextRegex + ">.*<" + receivedResponseTextRegex + ".*?>"), (String)("Should have received the SaslHandshakeRequest bytes back since we re-authenticated too quickly, but instead we got our generated message echoed back, implying re-auth succeeded when it should not have: " + exception));
            this.server.verifyReauthenticationMetrics(1, 0);
        }
        finally {
            this.selector.close();
            this.selector = null;
        }
    }

    @Test
    public void testRepeatedValidSaslPlainOverSsl() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.saslServerConfigs.put("connections.max.reauth.ms", Double.valueOf(1294.1176470588236).longValue());
        this.server = this.createEchoServer(securityProtocol);
        this.createClientConnection(securityProtocol, node);
        this.checkClientConnection(node);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "PLAIN");
        this.server.verifyReauthenticationMetrics(0, 0);
        double successfulReauthentications = 0.0;
        int desiredNumReauthentications = 5;
        long startMs = Time.SYSTEM.milliseconds();
        long timeoutMs = startMs + 15000L;
        while (successfulReauthentications < (double)desiredNumReauthentications && Time.SYSTEM.milliseconds() < timeoutMs) {
            this.checkClientConnection(node);
            successfulReauthentications = this.server.metricValue("successful-reauthentication-total");
        }
        this.server.verifyReauthenticationMetrics(desiredNumReauthentications, 0);
    }

    @Test
    public void testValidSaslOauthBearerMechanismWithoutServerTokens() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.saslClientConfigs.put("sasl.mechanism", "OAUTHBEARER");
        this.saslServerConfigs.put("sasl.enabled.mechanisms", Arrays.asList("OAUTHBEARER"));
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("OAUTHBEARER", Collections.singletonMap("unsecuredLoginStringClaim_sub", "myuser")));
        this.saslServerConfigs.put("listener.name.sasl_ssl.oauthbearer.sasl.jaas.config", TestJaasConfig.jaasConfigProperty("OAUTHBEARER", Collections.emptyMap()));
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientConnection(securityProtocol, node);
        this.saslClientConfigs.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty("OAUTHBEARER", Collections.emptyMap()));
        this.createAndCheckClientConnectionFailure(securityProtocol, node);
        this.saslServerConfigs.put("listener.name.sasl_ssl.oauthbearer.sasl.jaas.config", TestJaasConfig.jaasConfigProperty("OAUTHBEARER", Collections.singletonMap("unsecuredLoginExtension_test", "something")));
        try {
            this.createEchoServer(securityProtocol);
            Assertions.fail((String)"Server created with invalid login config containing extensions without a token");
        }
        catch (Throwable e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof LoginException), (String)("Unexpected exception " + Utils.stackTrace((Throwable)e)));
        }
    }

    @Test
    public void testInsufficientScopeSaslOauthBearerMechanism() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        TestJaasConfig jaasConfig = this.configureMechanisms("OAUTHBEARER", Arrays.asList("OAUTHBEARER"));
        Map<String, Object> serverJaasConfigOptionsMap = TestJaasConfig.defaultServerOptions("OAUTHBEARER");
        serverJaasConfigOptionsMap.put("unsecuredValidatorRequiredScope", "LOGIN_TO_KAFKA");
        jaasConfig.createOrUpdateEntry("KafkaServer", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", serverJaasConfigOptionsMap);
        this.server = this.createEchoServer(securityProtocol);
        this.createAndCheckClientAuthenticationFailure(securityProtocol, "node-OAUTHBEARER", "OAUTHBEARER", "{\"status\":\"insufficient_scope\", \"scope\":\"[LOGIN_TO_KAFKA]\"}");
    }

    @Test
    public void testValidEndpointIdentificationSanDns() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
        Assertions.assertEquals((int)1, (int)this.saslAuthenticateRequestCallback.callCount.get());
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(1, 0, "PLAIN");
    }

    @Test
    public void testValidEndpointIdentificationSanIp() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.serverCertStores = this.getCertStores(true, "server", InetAddress.getByName("127.0.0.1"));
        this.clientCertStores = this.getCertStores(false, "client", InetAddress.getByName("127.0.0.1"));
        this.saslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.saslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testValidEndpointIdentificationCN() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.serverCertStores = this.getCertStores(true, "localhost");
        this.clientCertStores = this.getCertStores(false, "localhost");
        this.saslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.saslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testEndpointIdentificationNoReverseLookup() throws Exception {
        String node = "0";
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        this.saslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
    }

    @Test
    public void testPrincipalBuilderException() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("SCRAM-SHA-256", Arrays.asList("SCRAM-SHA-256"));
        this.saslServerConfigs.put("principal.builder.class", BadPrincipalBuilder.class.getName());
        this.server = this.createEchoServer(securityProtocol);
        this.updateScramCredentialCache("myuser", "mypassword");
        String node = "0";
        this.createClientConnection(securityProtocol, node);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.READY);
        this.server.verifyAuthenticationMetrics(1, 0);
        this.server.verifyAuthenticationMetricsForMechanism(0, 0, "DEFAULT");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channels());
    }

    @Test
    public void testPublicCredential() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        this.saslServerConfigs.remove("connections.max.reauth.ms");
        this.server = this.createEchoServer(securityProtocol);
        String node = "0";
        this.createClientConnection(securityProtocol, node);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        PublicCredential credential = PublicCredential.authenticatedCredential((String)"myuser", Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        KafkaChannel channel = (KafkaChannel)this.server.selector().channels().get(0);
        NetworkTestUtils.waitForChannelReady(this.server.selector(), channel.id());
        Assertions.assertEquals((Object)credential, (Object)channel.publicCredential());
        Assertions.assertEquals(Collections.singletonList(channel), (Object)this.server.selector().channelsWithCredential(credential));
        PublicCredential anyCredential = PublicCredential.credential(null, null, null);
        Assertions.assertEquals(Collections.singletonList(channel), (Object)this.server.selector().channelsWithCredential(anyCredential));
        PublicCredential anySaslPlainCredential = PublicCredential.saslCredential(null, (String)"PLAIN");
        Assertions.assertEquals(Collections.singletonList(channel), (Object)this.server.selector().channelsWithCredential(anySaslPlainCredential));
        PublicCredential anySaslGssapiCredential = PublicCredential.saslCredential(null, (String)"GSSAPI");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channelsWithCredential(anySaslGssapiCredential));
        PublicCredential anySslCredential = PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SSL, null);
        Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channelsWithCredential(anySslCredential));
        PublicCredential anotherCredential = PublicCredential.authenticatedCredential((String)"another", Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channelsWithCredential(anotherCredential));
        PublicCredential networkCredential = PublicCredential.saslNetworkIdCredential((String)"networkId1", (String)"PLAIN");
        Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channelsWithCredential(networkCredential));
        this.checkClientConnection(node);
    }

    @Test
    public void testSslClientAuthDisabledForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.NONE);
    }

    @Test
    public void testSslClientAuthRequestedForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUESTED);
    }

    @Test
    public void testSslClientAuthRequiredForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUIRED);
    }

    @Test
    public void testSslClientAuthRequestedOverriddenForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(false, SslClientAuth.REQUESTED);
    }

    @Test
    public void testSslClientAuthRequiredOverriddenForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(false, SslClientAuth.REQUIRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSidePendingSendDuringReauthentication() throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        TestJaasConfig jaasConfig = this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        jaasConfig.createOrUpdateEntry("KafkaServer", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        jaasConfig.setClientOptions("PLAIN", "TestServerCallbackHandler-user", "TestServerCallbackHandler-password");
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("PLAIN");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", TestServerCallbackHandler.class.getName());
        this.server = this.createEchoServer(securityProtocol);
        String node = "node1";
        try {
            this.createClientConnection(securityProtocol, node);
            NetworkTestUtils.waitForChannelReady(this.selector, node);
            this.server.verifyAuthenticationMetrics(1, 0);
            SaslAuthenticatorTest.delay(110L);
            this.server.verifyReauthenticationMetrics(0, 0);
            TestServerCallbackHandler.sem.acquire();
            String prefix = TestUtils.randomString(100);
            this.selector.send(new NetworkSend(node, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap((prefix + "-0").getBytes(StandardCharsets.UTF_8)))));
            TestUtils.waitForCondition(() -> {
                this.selector.poll(10L);
                return TestServerCallbackHandler.sem.hasQueuedThreads();
            }, 5000L, "Reauthentication is not blocked");
            TestUtils.setFieldValue(this.selector.channel(node), "send", null);
            String channelId = ((KafkaChannel)this.server.selector().channels().get(0)).id();
            String payload = prefix + "-1";
            this.server.selector().send(new NetworkSend(channelId, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)ByteBuffer.wrap(payload.getBytes(StandardCharsets.UTF_8)))));
            TestServerCallbackHandler.sem.release();
            TestUtils.waitForCondition(() -> {
                this.selector.poll(10L);
                Iterator iterator = this.selector.completedReceives().iterator();
                if (iterator.hasNext()) {
                    NetworkReceive receive = (NetworkReceive)iterator.next();
                    Assertions.assertEquals((Object)payload, (Object)new String(Utils.toArray((ByteBuffer)receive.payload()), StandardCharsets.UTF_8));
                    return true;
                }
                return false;
            }, 5000L, "Failed Receive the server send after reauthentication");
            this.server.verifyReauthenticationMetrics(1, 0);
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    private void verifySslClientAuthForSaslSslListener(boolean useListenerPrefix, SslClientAuth configuredClientAuth) throws Exception {
        SslClientAuth expectedClientAuth = useListenerPrefix ? configuredClientAuth : SslClientAuth.NONE;
        this.verifySslClientAuthForSaslSslListener(useListenerPrefix, configuredClientAuth, expectedClientAuth, false, Collections.emptyMap());
    }

    @Test
    public void testPp2ValidateSslClientAuthDisabledForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.NONE, SslClientAuth.REQUIRED, true, pp2ValidateTrafficHeader);
    }

    @Test
    public void testPp2NoValidateSslClientAuthDisabledForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.NONE, SslClientAuth.NONE, true, pp2NoValidateTrafficHeader);
    }

    @Test
    public void testPp2ValidateSslClientAuthRequestedForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUESTED, SslClientAuth.REQUIRED, true, pp2ValidateTrafficHeader);
    }

    @Test
    public void testPp2NoValidateSslClientAuthRequestedForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUESTED, SslClientAuth.REQUESTED, true, pp2NoValidateTrafficHeader);
    }

    @Test
    public void testPp2ValidateSslClientAuthRequiredForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUIRED, SslClientAuth.REQUIRED, true, pp2ValidateTrafficHeader);
    }

    @Test
    public void testPp2NoValidateSslClientAuthRequiredForSaslSslListener() throws Exception {
        this.verifySslClientAuthForSaslSslListener(true, SslClientAuth.REQUIRED, SslClientAuth.REQUIRED, true, pp2NoValidateTrafficHeader);
    }

    private void verifySslClientAuthForSaslSslListener(boolean useListenerPrefix, SslClientAuth configuredClientAuth, SslClientAuth expectedClientAuth, boolean useProxyProtocolV2, Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        String listenerPrefix = useListenerPrefix ? ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).configPrefix() : "";
        this.saslServerConfigs.put(listenerPrefix + "ssl.client.auth", configuredClientAuth.name());
        this.saslServerConfigs.put("principal.builder.class", SaslSslPrincipalBuilder.class.getName());
        this.server = useProxyProtocolV2 ? this.createPp2EchoServer(securityProtocol) : this.createEchoServer(securityProtocol);
        String certDn = "O=A client,CN=localhost";
        KafkaPrincipal principalWithMutualTls = SaslSslPrincipalBuilder.saslSslPrincipal("myuser", certDn);
        KafkaPrincipal principalWithOneWayTls = SaslSslPrincipalBuilder.saslSslPrincipal("myuser", "ANONYMOUS");
        this.createAndCheckClientConnectionAndPrincipal(securityProtocol, "0", expectedClientAuth == SslClientAuth.NONE ? principalWithOneWayTls : principalWithMutualTls, useProxyProtocolV2, pp2TlvConfigsOverrides);
        this.removeClientSslKeystore();
        if (expectedClientAuth != SslClientAuth.REQUIRED) {
            this.createAndCheckClientConnectionAndPrincipal(securityProtocol, "1", principalWithOneWayTls, useProxyProtocolV2, pp2TlvConfigsOverrides);
        } else {
            this.createAndCheckSslAuthenticationFailure(securityProtocol, "1", useProxyProtocolV2, pp2TlvConfigsOverrides);
        }
        CertStores newStore = this.getCertStores(false, "localhost");
        newStore.keyStoreProps().forEach((k, v) -> this.saslClientConfigs.put((String)k, v));
        if (expectedClientAuth == SslClientAuth.NONE) {
            this.createAndCheckClientConnectionAndPrincipal(securityProtocol, "2", principalWithOneWayTls, useProxyProtocolV2, pp2TlvConfigsOverrides);
        } else {
            this.createAndCheckSslAuthenticationFailure(securityProtocol, "2", useProxyProtocolV2, pp2TlvConfigsOverrides);
        }
    }

    private void removeClientSslKeystore() {
        this.saslClientConfigs.remove("ssl.keystore.location");
        this.saslClientConfigs.remove("ssl.keystore.password");
        this.saslClientConfigs.remove("ssl.key.password");
    }

    private void verifySaslAuthenticateHeaderInterop(boolean enableHeaderOnServer, boolean enableHeaderOnClient, SecurityProtocol securityProtocol, String saslMechanism) throws Exception {
        this.configureMechanisms(saslMechanism, Collections.singletonList(saslMechanism));
        this.createServer(securityProtocol, saslMechanism, enableHeaderOnServer);
        String node = "0";
        this.createClientConnection(securityProtocol, saslMechanism, node, enableHeaderOnClient);
        NetworkTestUtils.checkClientConnection(this.selector, "0", 100, 10);
    }

    private void verifySaslAuthenticateHeaderInteropWithFailure(boolean enableHeaderOnServer, boolean enableHeaderOnClient, SecurityProtocol securityProtocol, String saslMechanism) throws Exception {
        TestJaasConfig jaasConfig = this.configureMechanisms(saslMechanism, Collections.singletonList(saslMechanism));
        jaasConfig.setClientOptions(saslMechanism, "myuser", "invalidpassword");
        this.createServer(securityProtocol, saslMechanism, enableHeaderOnServer);
        String node = "0";
        this.createClientConnection(securityProtocol, saslMechanism, node, enableHeaderOnClient);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATE);
    }

    private void createServer(SecurityProtocol securityProtocol, String saslMechanism, boolean enableSaslAuthenticateHeader) throws Exception {
        this.server = enableSaslAuthenticateHeader ? this.createEchoServer(securityProtocol) : this.startServerWithoutSaslAuthenticateHeader(securityProtocol, saslMechanism);
        this.updateScramCredentialCache("myuser", "mypassword");
    }

    private void createClientConnection(SecurityProtocol securityProtocol, String saslMechanism, String node, boolean enableSaslAuthenticateHeader) throws Exception {
        if (enableSaslAuthenticateHeader) {
            this.createClientConnection(securityProtocol, node);
        } else {
            this.createClientConnectionWithoutSaslAuthenticateHeader(securityProtocol, saslMechanism, node);
        }
    }

    private NioEchoServer startServerApiVersionsUnsupportedByClient(SecurityProtocol securityProtocol, String saslMechanism) throws Exception {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Map configs = Collections.emptyMap();
        JaasContext jaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)saslMechanism, configs);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap(saslMechanism, jaasContext);
        boolean isScram = ScramMechanism.isScram((String)saslMechanism);
        if (isScram) {
            ScramCredentialUtils.createCache((CredentialCache)this.credentialCache, Collections.singletonList(saslMechanism));
        }
        Supplier<ApiVersionsResponse> apiVersionSupplier = () -> {
            ApiVersionsResponseData.ApiVersionCollection versionCollection = new ApiVersionsResponseData.ApiVersionCollection(2);
            versionCollection.add((ImplicitLinkedHashCollection.Element)new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.SASL_HANDSHAKE.id).setMinVersion((short)0).setMaxVersion((short)100));
            versionCollection.add((ImplicitLinkedHashCollection.Element)new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.SASL_AUTHENTICATE.id).setMinVersion((short)0).setMaxVersion((short)100));
            return new ApiVersionsResponse(new ApiVersionsResponseData().setApiKeys(versionCollection));
        };
        SaslChannelBuilder serverChannelBuilder = new SaslChannelBuilder(Mode.SERVER, jaasContexts, securityProtocol, listenerName, false, saslMechanism, true, this.credentialCache, null, null, time, new LogContext(), apiVersionSupplier, (RequestCallback)new DefaultRequestCallbackManager(), new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        serverChannelBuilder.configure(this.saslServerConfigs);
        this.server = new NioEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), "localhost", (ChannelBuilder)serverChannelBuilder, this.credentialCache, time);
        this.server.start();
        return this.server;
    }

    private NioEchoServer startServerWithoutSaslAuthenticateHeader(final SecurityProtocol securityProtocol, String saslMechanism) throws Exception {
        final ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Map configs = Collections.emptyMap();
        JaasContext jaasContext = JaasContext.loadServerContext((ListenerName)listenerName, (String)saslMechanism, configs);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap(saslMechanism, jaasContext);
        boolean isScram = ScramMechanism.isScram((String)saslMechanism);
        if (isScram) {
            ScramCredentialUtils.createCache((CredentialCache)this.credentialCache, Arrays.asList(saslMechanism));
        }
        final Supplier<ApiVersionsResponse> apiVersionSupplier = () -> {
            ApiVersionsResponse defaultApiVersionResponse = TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER);
            ApiVersionsResponseData.ApiVersionCollection apiVersions = new ApiVersionsResponseData.ApiVersionCollection();
            for (ApiVersionsResponseData.ApiVersion apiVersion : defaultApiVersionResponse.data().apiKeys()) {
                if (apiVersion.apiKey() == ApiKeys.SASL_AUTHENTICATE.id) continue;
                apiVersions.add((ImplicitLinkedHashCollection.Element)apiVersion.duplicate());
            }
            ApiVersionsResponseData data = new ApiVersionsResponseData().setErrorCode(Errors.NONE.code()).setThrottleTimeMs(0).setApiKeys(apiVersions);
            return new ApiVersionsResponse(data);
        };
        final DefaultRequestCallbackManager defaultRequestCallbackManager = new DefaultRequestCallbackManager();
        SaslChannelBuilder serverChannelBuilder = new SaslChannelBuilder(Mode.SERVER, jaasContexts, securityProtocol, listenerName, false, saslMechanism, true, this.credentialCache, null, null, time, new LogContext(), apiVersionSupplier, (RequestCallback)defaultRequestCallbackManager, new ProxyProtocolEngineFactory(ProxyProtocol.NONE)){

            protected SaslServerAuthenticator buildServerAuthenticator(Map<String, ?> configs, Map<String, AuthenticateCallbackHandler> callbackHandlers, String id, long serverId, TransportLayer transportLayer, Map<String, Subject> subjects, Map<String, Long> connectionsMaxReauthMsByMechanism, Map<String, Boolean> asyncAuthEnabledByMechanism, Map<String, Long> asyncAuthTimeoutByMechanism, Map<String, Integer> saslServerMaxReceiveSizeByMechanism, AsyncAuthExecutor asyncAuthExecutor, ChannelMetadataRegistry metadataRegistry) {
                return new SaslServerAuthenticator(configs, callbackHandlers, id, -1L, subjects, null, listenerName, false, securityProtocol, transportLayer, connectionsMaxReauthMsByMechanism, asyncAuthEnabledByMechanism, asyncAuthTimeoutByMechanism, saslServerMaxReceiveSizeByMechanism, asyncAuthExecutor, metadataRegistry, time, apiVersionSupplier, (RequestCallback)defaultRequestCallbackManager){

                    protected void enableKafkaSaslAuthenticateHeaders(boolean flag) {
                    }
                };
            }
        };
        serverChannelBuilder.configure(this.saslServerConfigs);
        this.server = new NioEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), "localhost", (ChannelBuilder)serverChannelBuilder, this.credentialCache, time);
        this.server.start();
        return this.server;
    }

    private void createClientConnectionWithoutSaslAuthenticateHeader(SecurityProtocol securityProtocol, final String saslMechanism, String node) throws Exception {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        Map configs = Collections.emptyMap();
        JaasContext jaasContext = JaasContext.loadClientContext(configs);
        Map<String, JaasContext> jaasContexts = Collections.singletonMap(saslMechanism, jaasContext);
        SaslChannelBuilder clientChannelBuilder = new SaslChannelBuilder(Mode.CLIENT, jaasContexts, securityProtocol, listenerName, false, saslMechanism, true, null, null, null, time, new LogContext(), null, null, new ProxyProtocolEngineFactory(ProxyProtocol.NONE)){

            protected SaslClientAuthenticator buildClientAuthenticator(Map<String, ?> configs, AuthenticateCallbackHandler callbackHandler, String id, String serverHost, String servicePrincipal, TransportLayer transportLayer, Subject subject) {
                return new SaslClientAuthenticator(configs, callbackHandler, id, subject, servicePrincipal, serverHost, saslMechanism, true, transportLayer, time, new LogContext(), null){

                    protected SaslHandshakeRequest createSaslHandshakeRequest(short version) {
                        return SaslAuthenticatorTest.this.buildSaslHandshakeRequest(saslMechanism, (short)0);
                    }

                    protected void setSaslAuthenticateAndHandshakeVersions(ApiVersionsResponse apiVersionsResponse) {
                    }
                };
            }
        };
        clientChannelBuilder.configure(this.saslClientConfigs);
        this.selector = NetworkTestUtils.createSelector((ChannelBuilder)clientChannelBuilder, time);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
    }

    private void testUnauthenticatedApiVersionsRequest(SecurityProtocol securityProtocol, short saslHandshakeVersion) throws Exception {
        SecurityProtocol clientProtocol;
        this.configureMechanisms("PLAIN", Arrays.asList("PLAIN"));
        this.server = this.createEchoServer(securityProtocol);
        String node = "1";
        switch (securityProtocol) {
            case SASL_PLAINTEXT: {
                clientProtocol = SecurityProtocol.PLAINTEXT;
                break;
            }
            case SASL_SSL: {
                clientProtocol = SecurityProtocol.SSL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Server protocol " + securityProtocol + " is not SASL");
            }
        }
        this.createClientConnection(clientProtocol, node);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        ApiVersionsResponse versionsResponse = this.sendVersionRequestReceiveResponse(node);
        Assertions.assertEquals((short)ApiKeys.SASL_HANDSHAKE.oldestVersion(), (short)versionsResponse.apiVersion(ApiKeys.SASL_HANDSHAKE.id).minVersion());
        Assertions.assertEquals((short)ApiKeys.SASL_HANDSHAKE.latestVersion(), (short)versionsResponse.apiVersion(ApiKeys.SASL_HANDSHAKE.id).maxVersion());
        Assertions.assertEquals((short)ApiKeys.SASL_AUTHENTICATE.oldestVersion(), (short)versionsResponse.apiVersion(ApiKeys.SASL_AUTHENTICATE.id).minVersion());
        Assertions.assertEquals((short)ApiKeys.SASL_AUTHENTICATE.latestVersion(), (short)versionsResponse.apiVersion(ApiKeys.SASL_AUTHENTICATE.id).maxVersion());
        SaslHandshakeResponse handshakeResponse = this.sendHandshakeRequestReceiveResponse(node, saslHandshakeVersion);
        Assertions.assertEquals(Collections.singletonList("PLAIN"), (Object)handshakeResponse.enabledMechanisms());
        this.authenticateUsingSaslPlainAndCheckConnection(node, saslHandshakeVersion > 0);
    }

    private void authenticateUsingSaslPlainAndCheckConnection(String node, boolean enableSaslAuthenticateHeader) throws Exception {
        String authString = "\u0000myuser\u0000mypassword";
        ByteBuffer authBuf = ByteBuffer.wrap(Utils.utf8((String)authString));
        if (enableSaslAuthenticateHeader) {
            SaslAuthenticateRequestData data = new SaslAuthenticateRequestData().setAuthBytes(authBuf.array());
            SaslAuthenticateRequest request = (SaslAuthenticateRequest)new SaslAuthenticateRequest.Builder(data).build();
            this.sendKafkaRequestReceiveResponse(node, ApiKeys.SASL_AUTHENTICATE, (AbstractRequest)request);
        } else {
            this.selector.send(new NetworkSend(node, (Send)ByteBufferSend.sizePrefixed((ByteBuffer)authBuf)));
            this.waitForResponse();
        }
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    private TestJaasConfig configureMechanisms(String clientMechanism, List<String> serverMechanisms) {
        this.saslClientConfigs.put("sasl.mechanism", clientMechanism);
        this.saslServerConfigs.put("sasl.enabled.mechanisms", serverMechanisms);
        this.saslServerConfigs.put("connections.max.reauth.ms", 100L);
        if (serverMechanisms.contains("DIGEST-MD5")) {
            this.saslServerConfigs.put("digest-md5.sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class.getName());
        }
        return TestJaasConfig.createConfiguration(clientMechanism, serverMechanisms);
    }

    private void configureDigestMd5ServerCallback(SecurityProtocol securityProtocol) {
        String callbackPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).saslMechanismConfigPrefix("DIGEST-MD5");
        this.saslServerConfigs.put(callbackPrefix + "sasl.server.callback.handler.class", TestDigestLoginModule.DigestServerCallbackHandler.class);
    }

    private void createSelector(SecurityProtocol securityProtocol, Map<String, Object> clientConfigs) {
        this.createSelector(securityProtocol, clientConfigs, null);
    }

    private void createSelector(SecurityProtocol securityProtocol, Map<String, Object> clientConfigs, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        if (this.selector != null) {
            this.selector.close();
            this.selector = null;
        }
        String saslMechanism = (String)this.saslClientConfigs.get("sasl.mechanism");
        this.channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig(clientConfigs), null, (String)saslMechanism, (Time)time, (boolean)true, (LogContext)new LogContext(), (RequestCallback)this.saslAuthenticateRequestCallback, (ProxyProtocolEngineFactory)proxyProtocolEngineFactory);
        this.selector = NetworkTestUtils.createSelector(this.channelBuilder, time);
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol) throws Exception {
        return this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, time);
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol, DelegationTokenCache tokenCache) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, 100, time, tokenCache, null);
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol, int failedAuthenticationDelayMs) throws Exception {
        return NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, (AbstractConfig)new TestSecurityConfig(this.saslServerConfigs), this.credentialCache, failedAuthenticationDelayMs, time);
    }

    private void createClientConnection(SecurityProtocol securityProtocol, String node) throws Exception {
        this.createSelector(securityProtocol, this.saslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
    }

    private void checkClientConnection(String node) throws Exception {
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    private void closeClientConnectionIfNecessary() throws Exception {
        if (this.selector != null) {
            this.selector.close();
            this.selector = null;
        }
    }

    private void createAndCheckClientConnection(SecurityProtocol securityProtocol, String node) throws Exception {
        try {
            this.createClientConnection(securityProtocol, node);
            this.checkClientConnection(node);
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    private void createAndCheckClientAuthenticationFailure(SecurityProtocol securityProtocol, String node, String mechanism, String expectedErrorMessage) throws Exception {
        ChannelState finalState = this.createAndCheckClientConnectionFailure(securityProtocol, node);
        AuthenticationException exception = finalState.exception();
        Assertions.assertTrue((boolean)(exception instanceof SaslAuthenticationException), (String)("Invalid exception class " + ((Object)((Object)exception)).getClass()));
        String expectedExceptionMessage = expectedErrorMessage != null ? expectedErrorMessage : "Authentication failed during authentication due to invalid credentials with SASL mechanism " + mechanism;
        Assertions.assertEquals((Object)expectedExceptionMessage, (Object)exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelState createAndCheckClientConnectionFailure(SecurityProtocol securityProtocol, String node) throws Exception {
        try {
            ChannelState finalState;
            this.createClientConnection(securityProtocol, node);
            ChannelState channelState = finalState = NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
            return channelState;
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndCheckClientConnectionAndPrincipal(SecurityProtocol securityProtocol, String node, KafkaPrincipal expectedPrincipal, boolean useProxyProtocolV2, Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        try {
            Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channels());
            if (useProxyProtocolV2) {
                this.createPp2ClientConnection(securityProtocol, node, pp2TlvConfigsOverrides);
            } else {
                this.createClientConnection(securityProtocol, node);
            }
            NetworkTestUtils.waitForChannelReady(this.selector, node);
            Assertions.assertEquals((Object)expectedPrincipal, (Object)((KafkaChannel)this.server.selector().channels().get(0)).principal());
            this.checkClientConnection(node);
        }
        finally {
            this.closeClientConnectionIfNecessary();
            TestUtils.waitForCondition(() -> this.server.selector().channels().isEmpty(), "Channel not removed after disconnection");
        }
    }

    private void createAndCheckSslAuthenticationFailure(SecurityProtocol securityProtocol, String node, boolean useProxyProtocolV2, Map<String, Object> pp2TlvConfigsOverrides) throws Exception {
        ChannelState finalState = useProxyProtocolV2 ? this.createAndCheckPp2ClientConnectionFailure(securityProtocol, node, pp2TlvConfigsOverrides) : this.createAndCheckClientConnectionFailure(securityProtocol, node);
        AuthenticationException exception = finalState.exception();
        Assertions.assertEquals(SslAuthenticationException.class, ((Object)((Object)exception)).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuthenticationAndReauthentication(SecurityProtocol securityProtocol, String node, String mechanism) throws Exception {
        try {
            this.createClientConnection(securityProtocol, node);
            this.checkClientConnection(node);
            this.server.verifyAuthenticationMetrics(1, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, mechanism, EnumSet.of(NioEchoServer.MetricType.TOTAL, NioEchoServer.MetricType.RATE));
            SaslAuthenticatorTest.delay(110L);
            this.server.verifyReauthenticationMetrics(0, 0);
            this.checkClientConnection(node);
            this.server.verifyReauthenticationMetrics(1, 0);
            this.server.verifyAuthenticationMetricsForMechanism(1, 0, mechanism, EnumSet.of(NioEchoServer.MetricType.RATE));
        }
        finally {
            this.closeClientConnectionIfNecessary();
        }
    }

    private AbstractResponse sendKafkaRequestReceiveResponse(String node, ApiKeys apiKey, AbstractRequest request) throws IOException {
        RequestHeader header = new RequestHeader(apiKey, request.version(), "someclient", this.nextCorrelationId++);
        NetworkSend send = new NetworkSend(node, request.toSend(header));
        this.selector.send(send);
        ByteBuffer responseBuffer = this.waitForResponse();
        return NetworkClient.parseResponse((ByteBuffer)responseBuffer, (RequestHeader)header, (ClientInterceptor)NetworkClient.DEFAULT_INTERCEPTOR, (long)0L, (long)0L);
    }

    private SaslHandshakeResponse sendHandshakeRequestReceiveResponse(String node, short version) throws Exception {
        SaslHandshakeRequest handshakeRequest = this.buildSaslHandshakeRequest("PLAIN", version);
        SaslHandshakeResponse response = (SaslHandshakeResponse)this.sendKafkaRequestReceiveResponse(node, ApiKeys.SASL_HANDSHAKE, (AbstractRequest)handshakeRequest);
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error());
        return response;
    }

    private ApiVersionsResponse sendVersionRequestReceiveResponse(String node) throws Exception {
        ApiVersionsRequest handshakeRequest = this.createApiVersionsRequestV0();
        ApiVersionsResponse response = (ApiVersionsResponse)this.sendKafkaRequestReceiveResponse(node, ApiKeys.API_VERSIONS, (AbstractRequest)handshakeRequest);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        return response;
    }

    private ByteBuffer waitForResponse() throws IOException {
        int waitSeconds = 10;
        do {
            this.selector.poll(1000L);
        } while (this.selector.completedReceives().isEmpty() && waitSeconds-- > 0);
        Assertions.assertEquals((int)1, (int)this.selector.completedReceives().size());
        return ((NetworkReceive)this.selector.completedReceives().iterator().next()).payload();
    }

    private SaslHandshakeRequest buildSaslHandshakeRequest(String mechanism, short version) {
        return new SaslHandshakeRequest.Builder(new SaslHandshakeRequestData().setMechanism(mechanism)).build(version);
    }

    private void updateScramCredentialCache(String username, String password) throws NoSuchAlgorithmException {
        for (String mechanism : (List)this.saslServerConfigs.get("sasl.enabled.mechanisms")) {
            ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
            if (scramMechanism == null) continue;
            ScramFormatter formatter = new ScramFormatter(scramMechanism);
            ScramCredential credential = formatter.generateCredential(password, 4096);
            this.credentialCache.cache(scramMechanism.mechanismName(), ScramCredential.class).put(username, (Object)credential);
        }
    }

    private ApiVersionsRequest createApiVersionsRequestV0() {
        return (ApiVersionsRequest)new ApiVersionsRequest.Builder(0).build();
    }

    private void updateTokenCredentialCache(String username, String password) throws NoSuchAlgorithmException {
        for (String mechanism : (List)this.saslServerConfigs.get("sasl.enabled.mechanisms")) {
            ScramMechanism scramMechanism = ScramMechanism.forMechanismName((String)mechanism);
            if (scramMechanism == null) continue;
            ScramFormatter formatter = new ScramFormatter(scramMechanism);
            ScramCredential credential = formatter.generateCredential(password, 4096);
            this.server.tokenCache().credentialCache(scramMechanism.mechanismName()).put(username, (Object)credential);
        }
    }

    private static void delay(long delayMillis) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < delayMillis) {
            Thread.sleep(20L);
        }
    }

    public static class SaslSslPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            String sslPrincipal;
            SaslAuthenticationContext saslContext = (SaslAuthenticationContext)context;
            Assertions.assertTrue((boolean)saslContext.sslSession().isPresent());
            try {
                sslPrincipal = ((SSLSession)saslContext.sslSession().get()).getPeerPrincipal().getName();
            }
            catch (SSLPeerUnverifiedException e) {
                sslPrincipal = KafkaPrincipal.ANONYMOUS.getName();
            }
            String saslPrincipal = saslContext.server().getAuthorizationID();
            return SaslSslPrincipalBuilder.saslSslPrincipal(saslPrincipal, sslPrincipal);
        }

        public static KafkaPrincipal saslSslPrincipal(String saslPrincipal, String sslPrincipal) {
            return new KafkaPrincipal("User", saslPrincipal + ":" + sslPrincipal);
        }
    }

    public static class BadPrincipalBuilder
    implements KafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            throw new RuntimeException("Test exception");
        }
    }

    private static class AlternateSaslChannelBuilder
    extends SaslChannelBuilder {
        private int numInvocations = 0;

        public AlternateSaslChannelBuilder(Mode mode, Map<String, JaasContext> jaasContexts, SecurityProtocol securityProtocol, ListenerName listenerName, boolean isInterBrokerListener, String clientSaslMechanism, boolean handshakeRequestEnable, CredentialCache credentialCache, DelegationTokenCache tokenCache, Time time) {
            super(mode, jaasContexts, securityProtocol, listenerName, isInterBrokerListener, clientSaslMechanism, handshakeRequestEnable, credentialCache, tokenCache, null, time, new LogContext(), () -> TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER), (RequestCallback)new DefaultRequestCallbackManager(), new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        }

        protected SaslClientAuthenticator buildClientAuthenticator(Map<String, ?> configs, AuthenticateCallbackHandler callbackHandler, String id, String serverHost, String servicePrincipal, TransportLayer transportLayer, Subject subject) {
            if (++this.numInvocations == 1) {
                return new SaslClientAuthenticator(configs, callbackHandler, id, subject, servicePrincipal, serverHost, "DIGEST-MD5", true, transportLayer, time, new LogContext(), null);
            }
            return new SaslClientAuthenticator(configs, callbackHandler, id, subject, servicePrincipal, serverHost, "PLAIN", true, transportLayer, time, new LogContext(), null){

                protected SaslHandshakeRequest createSaslHandshakeRequest(short version) {
                    return new SaslHandshakeRequest.Builder(new SaslHandshakeRequestData().setMechanism("PLAIN")).build(version);
                }
            };
        }
    }

    public static class AlternateLoginCallbackHandler
    implements AuthenticateCallbackHandler {
        private static final OAuthBearerUnsecuredLoginCallbackHandler DELEGATE = new OAuthBearerUnsecuredLoginCallbackHandler();
        private static final String QUOTE = "\"";
        private static int numInvocations = 0;

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            DELEGATE.handle(callbacks);
            if (callbacks.length > 0) {
                for (Callback callback : callbacks) {
                    String claimsJson;
                    OAuthBearerTokenCallback oauthBearerTokenCallback;
                    OAuthBearerToken token;
                    if (!(callback instanceof OAuthBearerTokenCallback) || (token = (oauthBearerTokenCallback = (OAuthBearerTokenCallback)callback).token()) == null) continue;
                    String changedPrincipalNameToUse = token.principalName() + String.valueOf(++numInvocations);
                    String headerJson = "{" + AlternateLoginCallbackHandler.claimOrHeaderJsonText("alg", "none") + "}";
                    String lifetimeSecondsValueToUse = "1";
                    try {
                        claimsJson = String.format("{%s,%s,%s}", AlternateLoginCallbackHandler.expClaimText(Long.parseLong(lifetimeSecondsValueToUse)), AlternateLoginCallbackHandler.claimOrHeaderJsonText("iat", (double)time.milliseconds() / 1000.0), AlternateLoginCallbackHandler.claimOrHeaderJsonText("sub", changedPrincipalNameToUse));
                    }
                    catch (NumberFormatException e) {
                        throw new OAuthBearerConfigException(e.getMessage());
                    }
                    try {
                        Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
                        OAuthBearerUnsecuredJws jws = new OAuthBearerUnsecuredJws(String.format("%s.%s.", urlEncoderNoPadding.encodeToString(headerJson.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(claimsJson.getBytes(StandardCharsets.UTF_8))), "sub", "scope");
                        oauthBearerTokenCallback.token((OAuthBearerToken)jws);
                    }
                    catch (OAuthBearerIllegalTokenException e) {
                        throw new OAuthBearerConfigException(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }

        private static String claimOrHeaderJsonText(String claimName, String claimValue) {
            return QUOTE + claimName + QUOTE + ":" + QUOTE + claimValue + QUOTE;
        }

        private static String claimOrHeaderJsonText(String claimName, Number claimValue) {
            return QUOTE + claimName + QUOTE + ":" + claimValue;
        }

        private static String expClaimText(long lifetimeSeconds) {
            return AlternateLoginCallbackHandler.claimOrHeaderJsonText("exp", (double)time.milliseconds() / 1000.0 + (double)lifetimeSeconds);
        }

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            DELEGATE.configure(configs, saslMechanism, jaasConfigEntries);
        }

        public void close() {
            DELEGATE.close();
        }
    }

    public static final class TestPlainLoginModule
    extends PlainLoginModule {
        public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
            try {
                NameCallback nameCallback = new NameCallback("name:");
                PasswordCallback passwordCallback = new PasswordCallback("password:", false);
                callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
                subject.getPublicCredentials().add(nameCallback.getName());
                subject.getPrivateCredentials().add(new String(passwordCallback.getPassword()));
            }
            catch (Exception e) {
                throw new SaslAuthenticationException("Login initialization failed", (Throwable)e);
            }
        }
    }

    public static class TestLoginCallbackHandler
    implements AuthenticateCallbackHandler {
        private volatile boolean configured = false;

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            if (this.configured) {
                throw new IllegalStateException("Login callback handler configured twice");
            }
            this.configured = true;
        }

        public void handle(Callback[] callbacks) {
            if (!this.configured) {
                throw new IllegalStateException("Login callback handler not configured");
            }
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName("myuser");
                    continue;
                }
                if (!(callback instanceof PasswordCallback)) continue;
                ((PasswordCallback)callback).setPassword("mypassword".toCharArray());
            }
        }

        public void close() {
        }
    }

    public static class TestLogin
    implements Login {
        static AtomicInteger loginCount = new AtomicInteger();
        private String contextName;
        private Configuration configuration;
        private Subject subject;

        public void configure(Map<String, ?> configs, String contextName, Configuration configuration, AuthenticateCallbackHandler callbackHandler) {
            Assertions.assertEquals((int)1, (int)configuration.getAppConfigurationEntry(contextName).length);
            this.contextName = contextName;
            this.configuration = configuration;
        }

        public LoginContext login() throws LoginException {
            LoginContext context = new LoginContext(this.contextName, null, (CallbackHandler)new AbstractLogin.DefaultLoginCallbackHandler(), this.configuration);
            context.login();
            this.subject = context.getSubject();
            this.subject.getPublicCredentials().clear();
            this.subject.getPrivateCredentials().clear();
            this.subject.getPublicCredentials().add("myuser");
            this.subject.getPrivateCredentials().add("mypassword");
            loginCount.incrementAndGet();
            return context;
        }

        public Subject subject() {
            return this.subject;
        }

        public String serviceName() {
            return "kafka";
        }

        public void close() {
        }
    }

    private static class SaslAuthenticateRequestCallback
    implements RequestCallback {
        AtomicInteger callCount = new AtomicInteger();

        private SaslAuthenticateRequestCallback() {
        }

        public void onRequest(KafkaPrincipal principal, AbstractRequest request, Optional<String> clientID, Optional<String> listenerName) {
            if (request instanceof SaslAuthenticateRequest) {
                this.callCount.incrementAndGet();
            }
        }
    }

    public static class TestClientCallbackHandler
    implements AuthenticateCallbackHandler {
        static final String USERNAME = "TestClientCallbackHandler-user";
        static final String PASSWORD = "TestClientCallbackHandler-password";
        private volatile boolean configured;

        public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            if (this.configured) {
                throw new IllegalStateException("Client callback handler configured twice");
            }
            this.configured = true;
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            if (!this.configured) {
                throw new IllegalStateException("Client callback handler not configured");
            }
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(USERNAME);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(PASSWORD.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }

        public void close() {
        }
    }

    public static class TestServerCallbackHandler
    extends PlainServerCallbackHandler {
        static final String USERNAME = "TestServerCallbackHandler-user";
        static final String PASSWORD = "TestServerCallbackHandler-password";
        private volatile boolean configured;
        public static Semaphore sem = new Semaphore(1);

        public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
            if (this.configured) {
                throw new IllegalStateException("Server callback handler configured twice");
            }
            this.configured = true;
            super.configure(configs, mechanism, jaasConfigEntries);
        }

        protected boolean authenticate(String username, char[] password) {
            if (!this.configured) {
                throw new IllegalStateException("Server callback handler not configured");
            }
            try {
                sem.acquire();
                boolean bl = USERNAME.equals(username) && new String(password).equals(PASSWORD);
                return bl;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                sem.release();
            }
        }
    }

    public static class InvalidScramServerCallbackHandler
    implements AuthenticateCallbackHandler {
        static volatile IOException sensitiveException;
        static volatile SaslAuthenticationException clientFriendlyException;

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        }

        public void handle(Callback[] callbacks) throws IOException {
            if (sensitiveException != null) {
                throw sensitiveException;
            }
            if (clientFriendlyException != null) {
                throw clientFriendlyException;
            }
        }

        public void close() {
            InvalidScramServerCallbackHandler.reset();
        }

        static void reset() {
            sensitiveException = null;
            clientFriendlyException = null;
        }
    }
}

