/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.IllegalSaslStateException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslHandshakeRequestData;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.MockAsyncAuthExecutor;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.TransportLayer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslAuthenticateRequest;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.SaslServerAuthenticator;
import org.apache.kafka.common.security.authenticator.SaslServerCallbackHandler;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class SaslServerAuthenticatorTest {
    private final String clientId = "clientId";

    @Test
    public void testOversizeRequest() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)new DefaultChannelMetadataRegistry());
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(524289);
            return 4;
        });
        Assertions.assertThrows(SaslAuthenticationException.class, () -> ((SaslServerAuthenticator)authenticator).authenticate());
        ((TransportLayer)Mockito.verify((Object)transportLayer)).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private ApiVersionsResponse sendApiVersionsRequestAndReceiveResponse(TransportLayer transportLayer, SaslServerAuthenticator authenticator) throws IOException {
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, 0, "clientId", 13243);
        SocketChannel socketChannel = (SocketChannel)Mockito.mock(SocketChannel.class);
        Mockito.when((Object)transportLayer.socketChannel()).thenReturn((Object)socketChannel);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socketChannel.socket()).thenReturn((Object)socket);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getLocalHost());
        RequestHeaderData headerData = header.data();
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        int headerSize = headerData.size(serializationCache, header.headerVersion());
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerSize);
            return 4;
        }).then(invocation -> {
            ByteBufferAccessor writable = new ByteBufferAccessor((ByteBuffer)invocation.getArgument(0));
            headerData.write((Writable)writable, serializationCache, header.headerVersion());
            return headerSize;
        });
        ArgumentCaptor responseBuffersCaptor = ArgumentCaptor.forClass(ByteBuffer[].class);
        ByteBuffer responseBuffer = ByteBuffer.allocate(1024);
        Mockito.when((Object)transportLayer.write((ByteBuffer[])responseBuffersCaptor.capture())).then(invocation -> {
            for (ByteBuffer buffer : (ByteBuffer[])responseBuffersCaptor.getValue()) {
                responseBuffer.put(buffer);
            }
            return (long)responseBuffer.position();
        });
        authenticator.authenticate();
        responseBuffer.flip();
        int size = responseBuffer.getInt();
        Assertions.assertTrue((size < responseBuffer.capacity() ? 1 : 0) != 0);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer, (short)ApiKeys.API_VERSIONS.responseHeaderVersion(header.apiVersion()));
        Assertions.assertEquals((int)13243, (int)responseHeader.correlationId());
        return ApiVersionsResponse.parse((ByteBuffer)responseBuffer, (short)0, (MessageContext)MessageContext.IDENTITY);
    }

    private Set<ApiKeys> fetchSupportedApis() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)new DefaultChannelMetadataRegistry());
        ApiVersionsResponse response = this.sendApiVersionsRequestAndReceiveResponse(transportLayer, authenticator);
        return response.apiVersions().stream().map(version -> ApiKeys.forId((int)version.apiKey())).collect(Collectors.toSet());
    }

    @Test
    public void testExternalApiVersionRequestContainsNoInternalApis() throws IOException {
        Set<ApiKeys> supportedApis = this.fetchSupportedApis();
        Assertions.assertEquals(new HashSet(ApiKeys.zkBrokerApis()), supportedApis);
        Assertions.assertTrue((boolean)supportedApis.stream().anyMatch(key -> key.name.equals("ReplicaStatus")));
    }

    @Test
    public void testUnexpectedRequestType() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class);
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)new DefaultChannelMetadataRegistry());
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, 0, "clientId", 13243);
        ByteBuffer headerBuffer = RequestTestUtils.serializeRequestHeader(header);
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerBuffer.remaining());
            return 4;
        }).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).put(headerBuffer.duplicate());
            return headerBuffer.remaining();
        });
        try {
            authenticator.authenticate();
            Assertions.fail((String)"Expected authenticate() to raise an exception");
        }
        catch (IllegalSaslStateException illegalSaslStateException) {
            // empty catch block
        }
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    @Test
    public void testOldestApiVersionsRequest() throws IOException {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.oldestVersion(), "unknown", "unknown");
    }

    @Test
    public void testLatestApiVersionsRequest() throws IOException {
        this.testApiVersionsRequest(ApiKeys.API_VERSIONS.latestVersion(), "apache-kafka-java", AppInfoParser.getVersion());
    }

    @Test
    public void testSessionExpiresAtTokenExpiryDespiteNoReauthIsSet() throws IOException {
        String mechanism = "OAUTHBEARER";
        Duration tokenExpirationDuration = Duration.ofSeconds(1L);
        SaslServer saslServer = (SaslServer)Mockito.mock(SaslServer.class);
        MockTime time = new MockTime();
        try (MockedStatic<?> ignored = this.mockSaslServer(saslServer, mechanism, time, tokenExpirationDuration);
             MockedStatic<?> ignored2 = this.mockKafkaPrincipal("[principal-type]", "[principal-name");
             TransportLayer transportLayer = this.mockTransportLayer();){
            SaslServerAuthenticator authenticator = this.getSaslServerAuthenticatorForOAuth(mechanism, transportLayer, time, 0L);
            this.mockRequest((AbstractRequest)this.saslHandshakeRequest(mechanism), transportLayer);
            authenticator.authenticate();
            Mockito.when((Object)saslServer.isComplete()).thenReturn((Object)true);
            this.mockRequest((AbstractRequest)this.saslAuthenticateRequest(), transportLayer);
            authenticator.authenticate();
            long atTokenExpiryNanos = time.nanoseconds() + tokenExpirationDuration.toNanos();
            Assertions.assertEquals((long)atTokenExpiryNanos, (Long)authenticator.serverSessionExpirationTimeNanos());
            ByteBuffer secondResponseSent = this.getResponses(transportLayer).get(1);
            this.consumeSizeAndHeader(secondResponseSent);
            SaslAuthenticateResponse response = SaslAuthenticateResponse.parse((ByteBuffer)secondResponseSent, (short)2, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((long)tokenExpirationDuration.toMillis(), (long)response.sessionLifetimeMs());
        }
    }

    @Test
    public void testSessionExpiresAtMaxReauthTime() throws IOException {
        String mechanism = "OAUTHBEARER";
        SaslServer saslServer = (SaslServer)Mockito.mock(SaslServer.class);
        MockTime time = new MockTime(0L, 1L, 1000L);
        long maxReauthMs = 100L;
        Duration tokenExpiryGreaterThanMaxReauth = Duration.ofMillis(maxReauthMs).multipliedBy(10L);
        try (MockedStatic<?> ignored = this.mockSaslServer(saslServer, mechanism, time, tokenExpiryGreaterThanMaxReauth);
             MockedStatic<?> ignored2 = this.mockKafkaPrincipal("[principal-type]", "[principal-name");
             TransportLayer transportLayer = this.mockTransportLayer();){
            SaslServerAuthenticator authenticator = this.getSaslServerAuthenticatorForOAuth(mechanism, transportLayer, time, maxReauthMs);
            this.mockRequest((AbstractRequest)this.saslHandshakeRequest(mechanism), transportLayer);
            authenticator.authenticate();
            Mockito.when((Object)saslServer.isComplete()).thenReturn((Object)true);
            this.mockRequest((AbstractRequest)this.saslAuthenticateRequest(), transportLayer);
            authenticator.authenticate();
            long atMaxReauthNanos = time.nanoseconds() + Duration.ofMillis(maxReauthMs).toNanos();
            Assertions.assertEquals((long)atMaxReauthNanos, (Long)authenticator.serverSessionExpirationTimeNanos());
            ByteBuffer secondResponseSent = this.getResponses(transportLayer).get(1);
            this.consumeSizeAndHeader(secondResponseSent);
            SaslAuthenticateResponse response = SaslAuthenticateResponse.parse((ByteBuffer)secondResponseSent, (short)2, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((long)maxReauthMs, (long)response.sessionLifetimeMs());
        }
    }

    @Test
    public void testSessionExpiresAtTokenExpiry() throws IOException {
        String mechanism = "OAUTHBEARER";
        SaslServer saslServer = (SaslServer)Mockito.mock(SaslServer.class);
        MockTime time = new MockTime(0L, 1L, 1000L);
        Duration tokenExpiryShorterThanMaxReauth = Duration.ofSeconds(2L);
        long maxReauthMs = tokenExpiryShorterThanMaxReauth.multipliedBy(2L).toMillis();
        try (MockedStatic<?> ignored = this.mockSaslServer(saslServer, mechanism, time, tokenExpiryShorterThanMaxReauth);
             MockedStatic<?> ignored2 = this.mockKafkaPrincipal("[principal-type]", "[principal-name");
             TransportLayer transportLayer = this.mockTransportLayer();){
            SaslServerAuthenticator authenticator = this.getSaslServerAuthenticatorForOAuth(mechanism, transportLayer, time, maxReauthMs);
            this.mockRequest((AbstractRequest)this.saslHandshakeRequest(mechanism), transportLayer);
            authenticator.authenticate();
            Mockito.when((Object)saslServer.isComplete()).thenReturn((Object)true);
            this.mockRequest((AbstractRequest)this.saslAuthenticateRequest(), transportLayer);
            authenticator.authenticate();
            long atTokenExpiryNanos = time.nanoseconds() + tokenExpiryShorterThanMaxReauth.toNanos();
            Assertions.assertEquals((long)atTokenExpiryNanos, (Long)authenticator.serverSessionExpirationTimeNanos());
            ByteBuffer secondResponseSent = this.getResponses(transportLayer).get(1);
            this.consumeSizeAndHeader(secondResponseSent);
            SaslAuthenticateResponse response = SaslAuthenticateResponse.parse((ByteBuffer)secondResponseSent, (short)2, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals((long)tokenExpiryShorterThanMaxReauth.toMillis(), (long)response.sessionLifetimeMs());
        }
    }

    private SaslServerAuthenticator getSaslServerAuthenticatorForOAuth(String mechanism, TransportLayer transportLayer, Time time, Long maxReauth) {
        HashMap<String, List<String>> configs = new HashMap<String, List<String>>(Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(mechanism)));
        DefaultChannelMetadataRegistry metadataRegistry = new DefaultChannelMetadataRegistry();
        return this.setupAuthenticator(configs, transportLayer, mechanism, (ChannelMetadataRegistry)metadataRegistry, time, maxReauth, false);
    }

    private MockedStatic<?> mockSaslServer(SaslServer saslServer, String mechanism, Time time, Duration tokenExpirationDuration) throws SaslException {
        Mockito.when((Object)saslServer.getMechanismName()).thenReturn((Object)mechanism);
        Mockito.when((Object)saslServer.evaluateResponse((byte[])ArgumentMatchers.any())).thenReturn((Object)new byte[0]);
        long millisToExpiration = tokenExpirationDuration.toMillis();
        Mockito.when((Object)saslServer.getNegotiatedProperty((String)ArgumentMatchers.eq((Object)"CREDENTIAL.LIFETIME.MS"))).thenReturn((Object)(time.milliseconds() + millisToExpiration));
        return Mockito.mockStatic(Sasl.class, invocation -> saslServer);
    }

    private MockedStatic<?> mockKafkaPrincipal(String principalType, String name) {
        KafkaPrincipalBuilder kafkaPrincipalBuilder = (KafkaPrincipalBuilder)Mockito.mock(KafkaPrincipalBuilder.class);
        Mockito.when((Object)kafkaPrincipalBuilder.build((AuthenticationContext)ArgumentMatchers.any())).thenReturn((Object)new KafkaPrincipal(principalType, name));
        MockedStatic channelBuilders = Mockito.mockStatic(ChannelBuilders.class, (Answer)Answers.RETURNS_MOCKS);
        channelBuilders.when(() -> ChannelBuilders.createPrincipalBuilder((Map)ArgumentMatchers.anyMap(), (KerberosShortNamer)((KerberosShortNamer)ArgumentMatchers.any(KerberosShortNamer.class)), (SslPrincipalMapper)((SslPrincipalMapper)ArgumentMatchers.any(SslPrincipalMapper.class)))).thenReturn((Object)kafkaPrincipalBuilder);
        return channelBuilders;
    }

    private void consumeSizeAndHeader(ByteBuffer responseBuffer) {
        responseBuffer.getInt();
        ResponseHeader.parse((ByteBuffer)responseBuffer, (short)1);
    }

    private List<ByteBuffer> getResponses(TransportLayer transportLayer) throws IOException {
        ArgumentCaptor buffersCaptor = ArgumentCaptor.forClass(ByteBuffer[].class);
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).write((ByteBuffer[])buffersCaptor.capture());
        return buffersCaptor.getAllValues().stream().map(this::concatBuffers).collect(Collectors.toList());
    }

    private ByteBuffer concatBuffers(ByteBuffer[] buffers) {
        int combinedCapacity = 0;
        for (ByteBuffer buffer : buffers) {
            combinedCapacity += buffer.capacity();
        }
        if (combinedCapacity > 0) {
            ByteBuffer concat = ByteBuffer.allocate(combinedCapacity);
            for (ByteBuffer buffer : buffers) {
                concat.put(buffer);
            }
            return this.safeFlip(concat);
        }
        return ByteBuffer.allocate(0);
    }

    private ByteBuffer safeFlip(ByteBuffer buffer) {
        return (ByteBuffer)((Buffer)buffer).flip();
    }

    private SaslAuthenticateRequest saslAuthenticateRequest() {
        SaslAuthenticateRequestData authenticateRequestData = new SaslAuthenticateRequestData();
        return new SaslAuthenticateRequest.Builder(authenticateRequestData).build(ApiKeys.SASL_AUTHENTICATE.latestVersion());
    }

    private SaslHandshakeRequest saslHandshakeRequest(String mechanism) {
        SaslHandshakeRequestData handshakeRequestData = new SaslHandshakeRequestData();
        handshakeRequestData.setMechanism(mechanism);
        return new SaslHandshakeRequest.Builder(handshakeRequestData).build(ApiKeys.SASL_HANDSHAKE.latestVersion());
    }

    private TransportLayer mockTransportLayer() throws IOException {
        TransportLayer transportLayer = (TransportLayer)Mockito.mock(TransportLayer.class, (Answer)Answers.RETURNS_DEEP_STUBS);
        Mockito.when((Object)transportLayer.socketChannel().socket().getInetAddress()).thenReturn((Object)InetAddress.getLoopbackAddress());
        Mockito.when((Object)transportLayer.write((ByteBuffer[])ArgumentMatchers.any(ByteBuffer[].class))).thenReturn((Object)Long.MAX_VALUE);
        return transportLayer;
    }

    private void mockRequest(AbstractRequest request, TransportLayer transportLayer) throws IOException {
        this.mockRequest(new RequestHeader(request.apiKey(), request.apiKey().latestVersion(), "clientId", 0), request, transportLayer);
    }

    private void mockRequest(RequestHeader header, AbstractRequest request, TransportLayer transportLayer) throws IOException {
        ByteBuffer headerBuffer = RequestTestUtils.serializeRequestHeader(header);
        ByteBuffer requestBuffer = request.serialize();
        requestBuffer.rewind();
        Mockito.when((Object)transportLayer.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).putInt(headerBuffer.remaining() + requestBuffer.remaining());
            return 4;
        }).then(invocation -> {
            ((ByteBuffer)invocation.getArgument(0)).put(headerBuffer.duplicate()).put(requestBuffer.duplicate());
            return headerBuffer.remaining() + requestBuffer.remaining();
        });
    }

    private void testApiVersionsRequest(short version, String expectedSoftwareName, String expectedSoftwareVersion) throws IOException {
        TransportLayer transportLayer = this.mockTransportLayer();
        Map<String, List<String>> configs = Collections.singletonMap("sasl.enabled.mechanisms", Collections.singletonList(ScramMechanism.SCRAM_SHA_256.mechanismName()));
        DefaultChannelMetadataRegistry metadataRegistry = new DefaultChannelMetadataRegistry();
        SaslServerAuthenticator authenticator = this.setupAuthenticator(configs, transportLayer, ScramMechanism.SCRAM_SHA_256.mechanismName(), (ChannelMetadataRegistry)metadataRegistry);
        RequestHeader header = new RequestHeader(ApiKeys.API_VERSIONS, version, "clientId", 0);
        ApiVersionsRequest request = new ApiVersionsRequest.Builder().build(version);
        this.mockRequest(header, (AbstractRequest)request, transportLayer);
        authenticator.authenticate();
        Assertions.assertEquals((Object)expectedSoftwareName, (Object)metadataRegistry.clientInformation().softwareName());
        Assertions.assertEquals((Object)expectedSoftwareVersion, (Object)metadataRegistry.clientInformation().softwareVersion());
        ((TransportLayer)Mockito.verify((Object)transportLayer, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism, ChannelMetadataRegistry metadataRegistry) {
        return this.setupAuthenticator(configs, transportLayer, mechanism, metadataRegistry, new MockTime(), null, false);
    }

    private SaslServerAuthenticator setupAuthenticator(Map<String, ?> configs, TransportLayer transportLayer, String mechanism, ChannelMetadataRegistry metadataRegistry, Time time, Long maxReauth, boolean isInterBrokerListener) {
        TestJaasConfig jaasConfig = new TestJaasConfig();
        jaasConfig.addEntry("jaasContext", PlainLoginModule.class.getName(), new HashMap<String, Object>());
        Map<String, Subject> subjects = Collections.singletonMap(mechanism, new Subject());
        Map<String, SaslServerCallbackHandler> callbackHandlers = Collections.singletonMap(mechanism, new SaslServerCallbackHandler());
        ApiVersionsResponse apiVersionsResponse = TestUtils.confluentCloudApiVersionsResponse(ApiMessageType.ListenerType.ZK_BROKER);
        Map connectionsMaxReauthMsByMechanism = maxReauth != null ? Collections.singletonMap(mechanism, maxReauth) : Collections.emptyMap();
        return new SaslServerAuthenticator(configs, callbackHandlers, "node", -1L, subjects, null, new ListenerName("ssl"), isInterBrokerListener, SecurityProtocol.SASL_SSL, transportLayer, connectionsMaxReauthMsByMechanism, Collections.emptyMap(), Collections.emptyMap(), Collections.singletonMap(mechanism, Integer.MAX_VALUE), (AsyncAuthExecutor)new MockAsyncAuthExecutor(), metadataRegistry, time, () -> apiVersionsResponse, (RequestCallback)new DefaultRequestCallbackManager());
    }
}

