/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.json.Json;
import io.github.jopenlibs.vault.json.JsonObject;
import io.github.jopenlibs.vault.json.JsonValue;
import io.github.jopenlibs.vault.json.ParseException;
import io.github.jopenlibs.vault.response.VaultResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.nio.charset.StandardCharsets;

public class WrapResponse
extends VaultResponse {
    private Boolean renewable;
    private String token;
    private String accessor;
    private int ttl;
    private String creationTime;
    private String creationPath;

    public WrapResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries);
        try {
            String responseJson = new String(restResponse.getBody(), StandardCharsets.UTF_8);
            JsonObject jsonResponse = Json.parse(responseJson).asObject();
            JsonValue wrapInfoJsonVal = jsonResponse.get("wrap_info");
            if (wrapInfoJsonVal != null && !wrapInfoJsonVal.isNull()) {
                JsonObject wrapInfoJsonObject = wrapInfoJsonVal.asObject();
                this.token = wrapInfoJsonObject.getString("token", null);
                this.accessor = wrapInfoJsonObject.getString("accessor", null);
                this.ttl = wrapInfoJsonObject.getInt("ttl", 0);
                this.creationTime = wrapInfoJsonObject.getString("creation_time", null);
                this.creationPath = wrapInfoJsonObject.getString("creation_path", null);
            }
            this.renewable = jsonResponse.get("renewable").asBoolean();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Boolean getRenewable() {
        return this.renewable;
    }

    public String getToken() {
        return this.token;
    }

    public String getAccessor() {
        return this.accessor;
    }

    public int getTtl() {
        return this.ttl;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public String getCreationPath() {
        return this.creationPath;
    }
}

