/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.functions.DeclaredFunction;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.BooleanUtils;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;

public class StringFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$string");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$string");

    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        TextNode result = null;
        Object arg = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = StringFunction.getArgumentCount(ctx);
        if (useContext) {
            arg = FunctionUtils.getContextVariable(expressionVisitor);
            if (arg != null && argCount == 0) {
                ++argCount;
            } else {
                useContext = false;
            }
        }
        if (argCount >= 1 && argCount <= 2) {
            String asString;
            if (!useContext) {
                MappingExpressionParser.ExprContext exprCtx = ctx.exprValues().exprList().expr(0);
                arg = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
                if (arg == null) {
                    if (exprCtx instanceof MappingExpressionParser.Function_callContext || exprCtx instanceof MappingExpressionParser.Function_declContext) {
                        arg = new TextNode("");
                    }
                    if (exprCtx instanceof MappingExpressionParser.Var_recallContext) {
                        FunctionBase fct;
                        String varName = ((MappingExpressionParser.Var_recallContext)exprCtx).VAR_ID().getText();
                        DeclaredFunction declFct = expressionVisitor.getDeclaredFunction(varName);
                        arg = declFct != null ? new TextNode("") : ((fct = expressionVisitor.getJsonataFunction(varName)) != null ? new TextNode("") : null);
                    }
                }
            }
            if (arg == null || arg.isNull() && useContext) {
                return null;
            }
            boolean prettify = false;
            if (argCount == 2) {
                JsonNode arg2 = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
                if (arg2 != null && arg2.isBoolean()) {
                    prettify = BooleanUtils.convertJsonNodeToBoolean(arg2);
                } else {
                    throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
                }
            }
            result = (asString = ExpressionsVisitor.castString((JsonNode)arg, prettify)) == null ? null : new TextNode(asString);
        } else {
            if (argCount == 0) {
                return null;
            }
            throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        }
        return result;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 0;
    }

    @Override
    public String getSignature() {
        return "<x-b?:s>";
    }
}

