/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.function.udaf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class VariadicArgs<T>
implements Iterable<T> {
    private final List<T> values;

    public VariadicArgs(List<T> values) {
        this.values = Collections.unmodifiableList(new ArrayList<T>(values));
    }

    public T get(int index) {
        if (index < 0 || index >= this.values.size()) {
            throw new IndexOutOfBoundsException(String.format("Attempted to access variadic argument at index %s when only %s arguments are available", index, this.values.size()));
        }
        return this.values.get(index);
    }

    public int size() {
        return this.values.size();
    }

    public Stream<T> stream() {
        return this.values.stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }
}

