/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.schema.utils.SchemaException;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class SqlPrimitiveType
extends SqlType {
    private static final String INT = "INT";
    private static final String VARCHAR = "VARCHAR";
    private static final ImmutableMap<SqlBaseType, SqlPrimitiveType> TYPES = ImmutableMap.builder().put((Object)SqlBaseType.BOOLEAN, (Object)new SqlPrimitiveType(SqlBaseType.BOOLEAN)).put((Object)SqlBaseType.INTEGER, (Object)new SqlPrimitiveType(SqlBaseType.INTEGER)).put((Object)SqlBaseType.BIGINT, (Object)new SqlPrimitiveType(SqlBaseType.BIGINT)).put((Object)SqlBaseType.DOUBLE, (Object)new SqlPrimitiveType(SqlBaseType.DOUBLE)).put((Object)SqlBaseType.STRING, (Object)new SqlPrimitiveType(SqlBaseType.STRING)).put((Object)SqlBaseType.TIME, (Object)new SqlPrimitiveType(SqlBaseType.TIME)).put((Object)SqlBaseType.DATE, (Object)new SqlPrimitiveType(SqlBaseType.DATE)).put((Object)SqlBaseType.TIMESTAMP, (Object)new SqlPrimitiveType(SqlBaseType.TIMESTAMP)).put((Object)SqlBaseType.BYTES, (Object)new SqlPrimitiveType(SqlBaseType.BYTES)).build();
    private static final ImmutableSet<String> PRIMITIVE_TYPE_NAMES = ImmutableSet.builder().addAll((Iterable)TYPES.keySet().stream().map(Enum::name).collect(Collectors.toList())).add((Object)"INT").add((Object)"VARCHAR").build();

    public static boolean isPrimitiveTypeName(String name) {
        return PRIMITIVE_TYPE_NAMES.contains((Object)name.toUpperCase());
    }

    public static SqlPrimitiveType of(String typeName) {
        switch (typeName.toUpperCase()) {
            case "INT": {
                return SqlPrimitiveType.of(SqlBaseType.INTEGER);
            }
            case "VARCHAR": {
                return SqlPrimitiveType.of(SqlBaseType.STRING);
            }
        }
        try {
            SqlBaseType sqlType = SqlBaseType.valueOf(typeName.toUpperCase());
            return SqlPrimitiveType.of(sqlType);
        }
        catch (IllegalArgumentException e) {
            throw new SchemaException("Unknown primitive type: " + typeName, e);
        }
    }

    public static SqlPrimitiveType of(SqlBaseType sqlType) {
        SqlPrimitiveType primitive = (SqlPrimitiveType)TYPES.get((Object)Objects.requireNonNull(sqlType, "sqlType"));
        if (primitive == null) {
            throw new SchemaException("Invalid primitive type: " + (Object)((Object)sqlType));
        }
        return primitive;
    }

    private SqlPrimitiveType(SqlBaseType baseType) {
        super(baseType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlPrimitiveType)) {
            return false;
        }
        SqlPrimitiveType that = (SqlPrimitiveType)o;
        return Objects.equals((Object)this.baseType(), (Object)that.baseType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseType()});
    }

    public String toString() {
        return this.baseType().toString();
    }

    @Override
    public String toString(FormatOptions formatOptions) {
        return this.toString();
    }
}

