/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.avro;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import io.confluent.kafka.schemaregistry.utils.BoundedConcurrentHashMap;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.kafka.common.errors.SerializationException;

public class AvroSchemaUtils {
    private static final GenericData GENERIC_DATA_INSTANCE = new NameAwareGenericData(GenericData.get());
    private static final GenericData GENERIC_DATA_INSTANCE_WITH_LOGICAL = new NameAwareGenericData();
    private static final ReflectData REFLECT_DATA_INSTANCE_WITH_LOGICAL = new ReflectData();
    private static final ReflectData REFLECT_DATA_ALLOW_NULL_INSTANCE_WITH_LOGICAL = new ReflectData.AllowNull();
    private static final SpecificData SPECIFIC_DATA_INSTANCE_WITH_LOGICAL = new SpecificData();
    private static final ThreadLocal<GenericData> genericData;
    private static final ThreadLocal<ReflectData> reflectData;
    private static final ThreadLocal<SpecificData> specificData;
    private static final EncoderFactory encoderFactory;
    private static final DecoderFactory decoderFactory;
    private static final ObjectMapper jsonMapper;
    private static final ObjectMapper jsonMapperWithOrderedProps;
    private static int DEFAULT_CACHE_CAPACITY;
    private static final Map<String, Schema> primitiveSchemas;
    private static final Map<Schema, Schema> transformedSchemas;

    public static void setThreadLocalData(Schema schema, boolean useLogicaltypes, boolean allowNull) {
        genericData.set(AvroSchemaUtils.getGenericData(useLogicaltypes));
        reflectData.set(AvroSchemaUtils.getReflectData(useLogicaltypes, allowNull));
        specificData.set(AvroSchemaUtils.getSpecificDataForSchema(schema, useLogicaltypes));
    }

    public static GenericData getThreadLocalGenericData() {
        return genericData.get();
    }

    public static ReflectData getThreadLocalReflectData() {
        return reflectData.get();
    }

    public static SpecificData getThreadLocalSpecificData() {
        return specificData.get();
    }

    public static void clearThreadLocalData() {
        genericData.remove();
        reflectData.remove();
        specificData.remove();
    }

    public static GenericData getGenericData(boolean useLogicalTypes) {
        return useLogicalTypes ? AvroSchemaUtils.getGenericData() : GENERIC_DATA_INSTANCE;
    }

    public static GenericData getGenericData() {
        return GENERIC_DATA_INSTANCE_WITH_LOGICAL;
    }

    public static ReflectData getReflectData(boolean useLogicalTypes, boolean allowNull) {
        return allowNull ? (useLogicalTypes ? AvroSchemaUtils.getReflectDataAllowNull() : ReflectData.AllowNull.get()) : (useLogicalTypes ? AvroSchemaUtils.getReflectData() : ReflectData.get());
    }

    public static ReflectData getReflectData() {
        return REFLECT_DATA_INSTANCE_WITH_LOGICAL;
    }

    public static ReflectData getReflectDataAllowNull() {
        return REFLECT_DATA_ALLOW_NULL_INSTANCE_WITH_LOGICAL;
    }

    public static SpecificData getSpecificDataForSchema(Schema reader, boolean useLogicalTypes) {
        return useLogicalTypes ? AvroSchemaUtils.getSpecificDataForSchema(reader) : SpecificData.getForSchema((Schema)reader);
    }

    public static SpecificData getSpecificDataForSchema(Schema reader) {
        Class clazz;
        if (reader != null && (reader.getType() == Schema.Type.RECORD || reader.getType() == Schema.Type.UNION) && (clazz = AvroSchemaUtils.getSpecificData().getClass(reader)) != null) {
            return AvroSchemaUtils.getSpecificDataForClass(clazz);
        }
        return AvroSchemaUtils.getSpecificData();
    }

    public static <T> SpecificData getSpecificDataForClass(Class<T> c) {
        return SpecificRecordBase.class.isAssignableFrom(c) ? SpecificData.getForClass(c) : AvroSchemaUtils.getSpecificData();
    }

    public static SpecificData getSpecificData() {
        return SPECIFIC_DATA_INSTANCE_WITH_LOGICAL;
    }

    public static void addLogicalTypeConversion(GenericData avroData) {
        avroData.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
        avroData.addLogicalTypeConversion((Conversion)new Conversions.UUIDConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMillisConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMicrosConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMillisConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMillisConversion());
        avroData.addLogicalTypeConversion((Conversion)new TimeConversions.LocalTimestampMicrosConversion());
    }

    private static Schema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(schemaString).rawSchema();
    }

    public static AvroSchema copyOf(AvroSchema schema) {
        return schema.copy();
    }

    public static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    public static Schema getSchema(Object object) {
        return AvroSchemaUtils.getSchema(object, false, false, false, true);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean removeJavaProperties) {
        return AvroSchemaUtils.getSchema(object, useReflection, reflectionAllowNull, removeJavaProperties, true);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean removeJavaProperties, boolean throwError) {
        return AvroSchemaUtils.getSchema(object, useReflection, reflectionAllowNull, false, removeJavaProperties, throwError);
    }

    public static Schema getSchema(Object object, boolean useReflection, boolean reflectionAllowNull, boolean useLogicalTypeConverters, boolean removeJavaProperties, boolean throwError) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[] || object instanceof ByteBuffer) {
            return primitiveSchemas.get("Bytes");
        }
        if (useReflection) {
            ReflectData reflectData = AvroSchemaUtils.getReflectData(useLogicalTypeConverters, reflectionAllowNull);
            Schema schema = reflectData.getSchema(object.getClass());
            if (schema == null) {
                throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
            }
            return schema;
        }
        if (object instanceof GenericContainer) {
            Schema schema = ((GenericContainer)object).getSchema();
            if (removeJavaProperties) {
                Schema s = schema;
                schema = transformedSchemas.computeIfAbsent(s, k -> AvroSchemaUtils.removeJavaProperties(s));
            }
            return schema;
        }
        if (object instanceof Map) {
            Map mapValue = (Map)object;
            if (mapValue.isEmpty()) {
                return Schema.createMap((Schema)primitiveSchemas.get("Null"));
            }
            Schema valueSchema = AvroSchemaUtils.getSchema(mapValue.values().iterator().next(), useReflection, reflectionAllowNull, removeJavaProperties, throwError);
            return Schema.createMap((Schema)valueSchema);
        }
        if (throwError) {
            throw new IllegalArgumentException("Unsupported Avro type '" + object.getClass().getSimpleName() + "'. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
        }
        ReflectData reflectData = AvroSchemaUtils.getReflectData(useLogicalTypeConverters, reflectionAllowNull);
        Schema schema = reflectData.getSchema(object.getClass());
        if (schema == null) {
            throw new SerializationException("Schema is null for object of class " + object.getClass().getCanonicalName());
        }
        return schema;
    }

    private static Schema removeJavaProperties(Schema schema) {
        try {
            JsonNode node = jsonMapper.readTree(schema.toString());
            AvroSchemaUtils.removeProperty(node, "avro.java.string");
            AvroSchema avroSchema = new AvroSchema(node.toString());
            return avroSchema.rawSchema();
        }
        catch (IOException e) {
            throw new SerializationException("Could not parse schema: " + schema.toString());
        }
    }

    private static void removeProperty(JsonNode node, String propertyName) {
        block3: {
            block2: {
                if (!node.isObject()) break block2;
                ObjectNode objectNode = (ObjectNode)node;
                objectNode.remove(propertyName);
                Iterator elements = objectNode.elements();
                while (elements.hasNext()) {
                    AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
                }
                break block3;
            }
            if (!node.isArray()) break block3;
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator elements = arrayNode.elements();
            while (elements.hasNext()) {
                AvroSchemaUtils.removeProperty((JsonNode)elements.next(), propertyName);
            }
        }
    }

    public static Object toObject(JsonNode value, AvroSchema schema) throws IOException {
        GenericData data = AvroSchemaUtils.getData(schema.rawSchema(), null, false, false);
        return AvroSchemaUtils.toObject(value, schema, (DatumReader<Object>)new GenericDatumReader(schema.rawSchema(), schema.rawSchema(), data));
    }

    public static Object toObject(JsonNode value, AvroSchema schema, DatumReader<Object> reader) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            Schema rawSchema = schema.rawSchema();
            jsonMapper.writeValue((OutputStream)out, (Object)value);
            Object object2 = object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, (InputStream)new ByteArrayInputStream(out.toByteArray())));
            return object2;
        }
    }

    public static Object toObject(String value, AvroSchema schema) throws IOException {
        GenericData data = AvroSchemaUtils.getData(schema.rawSchema(), null, false, false);
        return AvroSchemaUtils.toObject(value, schema, (DatumReader<Object>)new GenericDatumReader(schema.rawSchema(), schema.rawSchema(), data));
    }

    public static Object toObject(String value, AvroSchema schema, DatumReader<Object> reader) throws IOException {
        Schema rawSchema = schema.rawSchema();
        Object object = reader.read(null, (Decoder)decoderFactory.jsonDecoder(rawSchema, value));
        return object;
    }

    public static byte[] toJson(Object value) throws IOException {
        if (value == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            AvroSchemaUtils.toJson(value, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void toJson(Object value, OutputStream out) throws IOException {
        Schema schema = AvroSchemaUtils.getSchema(value, false, false, false, false);
        JsonEncoder encoder = encoderFactory.jsonEncoder(schema, out);
        DatumWriter<?> writer = AvroSchemaUtils.getDatumWriter(value, schema, false, false);
        Object wrappedValue = value;
        if (value instanceof byte[]) {
            wrappedValue = ByteBuffer.wrap((byte[])value);
        }
        writer.write(wrappedValue, (Encoder)encoder);
        encoder.flush();
    }

    public static GenericData getData(Schema schema, Object message, boolean useLogicalTypes, boolean allowNull) {
        if (message instanceof SpecificRecord) {
            SpecificData data = AvroSchemaUtils.getThreadLocalSpecificData();
            return data != null ? data : AvroSchemaUtils.getSpecificDataForSchema(schema, useLogicalTypes);
        }
        if (message instanceof GenericRecord) {
            GenericData data = AvroSchemaUtils.getThreadLocalGenericData();
            return data != null ? data : AvroSchemaUtils.getGenericData(useLogicalTypes);
        }
        if (message != null) {
            ReflectData data = AvroSchemaUtils.getThreadLocalReflectData();
            return data != null ? data : AvroSchemaUtils.getReflectData(useLogicalTypes, allowNull);
        }
        GenericData data = AvroSchemaUtils.getThreadLocalGenericData();
        return data != null ? data : AvroSchemaUtils.getGenericData(useLogicalTypes);
    }

    public static DatumWriter<?> getDatumWriter(Object value, Schema schema, boolean avroUseLogicalTypeConverters) {
        return AvroSchemaUtils.getDatumWriter(value, schema, avroUseLogicalTypeConverters, false);
    }

    public static DatumWriter<?> getDatumWriter(Object value, Schema schema, boolean useLogicalTypes, boolean allowNull) {
        GenericData data = AvroSchemaUtils.getData(schema, value, useLogicalTypes, allowNull);
        if (value instanceof SpecificRecord) {
            return new SpecificDatumWriter(schema, (SpecificData)data);
        }
        if (value instanceof GenericRecord) {
            return new GenericDatumWriter(schema, data);
        }
        return new ReflectDatumWriter(schema, (ReflectData)data);
    }

    public static JsonNode findMatchingEntity(JsonNode node, SchemaEntity entity) {
        String recordName;
        String nameSpace;
        String[] identifiers = entity.getEntityPath().split("\\.");
        SchemaEntity.EntityType type = entity.getEntityType();
        String fieldName = null;
        if (SchemaEntity.EntityType.SR_RECORD == type) {
            nameSpace = String.join((CharSequence)".", Arrays.copyOfRange(identifiers, 0, identifiers.length - 1));
            recordName = identifiers[identifiers.length - 1];
        } else {
            nameSpace = String.join((CharSequence)".", Arrays.copyOfRange(identifiers, 0, identifiers.length - 2));
            recordName = identifiers[identifiers.length - 2];
            fieldName = identifiers[identifiers.length - 1];
        }
        LinkedList<JsonNodeWithNS> toVisit = new LinkedList<JsonNodeWithNS>();
        JsonNode currNameSpace = node.get("namespace");
        toVisit.add(new JsonNodeWithNS(node, currNameSpace == null ? null : currNameSpace.asText()));
        block10: while (toVisit.size() > 0) {
            String schemaType;
            JsonNodeWithNS curr = (JsonNodeWithNS)toVisit.removeFirst();
            JsonNode currNode = curr.jsonNode();
            if (!currNode.has("type")) {
                currNode.elements().forEachRemaining(e -> toVisit.add(new JsonNodeWithNS((JsonNode)e, curr.namespace())));
                continue;
            }
            switch (schemaType = currNode.get("type").asText()) {
                case "record": {
                    if ((nameSpace.isEmpty() || nameSpace.equals(curr.namespace())) && recordName.equals(currNode.get("name").asText())) {
                        if (SchemaEntity.EntityType.SR_RECORD == type) {
                            return currNode;
                        }
                        Iterator fieldsIter = currNode.get("fields").elements();
                        while (fieldsIter.hasNext()) {
                            JsonNode currField = (JsonNode)fieldsIter.next();
                            if (!fieldName.equals(currField.get("name").asText())) continue;
                            return currField;
                        }
                        continue block10;
                    }
                    currNode.get("fields").elements().forEachRemaining(e -> toVisit.add(new JsonNodeWithNS((JsonNode)e, curr.namespace())));
                    break;
                }
                case "array": {
                    toVisit.add(new JsonNodeWithNS(currNode.get("items"), curr.namespace()));
                    break;
                }
                case "map": {
                    toVisit.add(new JsonNodeWithNS(currNode.get("values"), curr.namespace()));
                    break;
                }
                default: {
                    toVisit.add(new JsonNodeWithNS(currNode.get("type"), curr.namespace()));
                }
            }
        }
        throw new IllegalArgumentException(String.format("No matching path '%s' found in the schema", entity.getEntityPath()));
    }

    protected static String toNormalizedString(AvroSchema schema) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            Schema.Parser parser = schema.getParser();
            for (String resolvedRef : schema.resolvedReferences().values()) {
                Schema schemaRef = parser.parse(resolvedRef);
                String fullName = schemaRef.getFullName();
                env.put(fullName, "\"" + fullName + "\"");
            }
            return AvroSchemaUtils.build(env, schema.rawSchema(), new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Appendable build(Map<String, String> env, Schema s, Appendable o) throws IOException {
        boolean firstTime = true;
        Schema.Type st = s.getType();
        LogicalType lt = s.getLogicalType();
        switch (st) {
            case UNION: {
                o.append('[');
                for (Schema b : s.getTypes()) {
                    if (!firstTime) {
                        o.append(',');
                    } else {
                        firstTime = false;
                    }
                    AvroSchemaUtils.build(env, b, o);
                }
                return o.append(']');
            }
            case ARRAY: 
            case MAP: {
                o.append("{\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ARRAY) {
                    AvroSchemaUtils.build(env, s.getElementType(), o.append(",\"items\":"));
                } else {
                    AvroSchemaUtils.build(env, s.getValueType(), o.append(",\"values\":"));
                }
                AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
                return o.append("}");
            }
            case ENUM: 
            case FIXED: 
            case RECORD: {
                String name = s.getFullName();
                if (env.get(name) != null) {
                    return o.append(env.get(name));
                }
                String qname = "\"" + name + "\"";
                env.put(name, qname);
                o.append("{\"name\":").append(qname);
                o.append(",\"type\":\"").append(st.getName()).append("\"");
                if (st == Schema.Type.ENUM) {
                    o.append(",\"symbols\":[");
                    for (String enumSymbol : s.getEnumSymbols()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append('\"').append(enumSymbol).append('\"');
                    }
                    o.append("]");
                } else if (st == Schema.Type.FIXED) {
                    o.append(",\"size\":").append(Integer.toString(s.getFixedSize()));
                    lt = s.getLogicalType();
                    if (lt != null) {
                        AvroSchemaUtils.setLogicalProps(o, lt);
                    }
                } else {
                    o.append(",\"fields\":[");
                    for (Schema.Field f : s.getFields()) {
                        if (!firstTime) {
                            o.append(',');
                        } else {
                            firstTime = false;
                        }
                        o.append("{\"name\":\"").append(f.name()).append("\"");
                        AvroSchemaUtils.build(env, f.schema(), o.append(",\"type\":"));
                        AvroSchemaUtils.setFieldProps(o, f);
                        o.append("}");
                    }
                    o.append("]");
                }
                AvroSchemaUtils.setComplexProps(o, s);
                AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
                return o.append("}");
            }
        }
        if (lt != null) {
            return AvroSchemaUtils.writeLogicalType(s, lt, o);
        }
        if (s.hasProps()) {
            o.append("{\"type\":\"").append(st.getName()).append('\"');
            AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
            o.append("}");
        } else {
            o.append('\"').append(st.getName()).append('\"');
        }
        return o;
    }

    private static Appendable writeLogicalType(Schema s, LogicalType lt, Appendable o) throws IOException {
        o.append("{\"type\":\"").append(s.getType().getName()).append("\"");
        AvroSchemaUtils.setLogicalProps(o, lt);
        AvroSchemaUtils.setSimpleProps(o, s.getObjectProps());
        return o.append("}");
    }

    private static void setLogicalProps(Appendable o, LogicalType lt) throws IOException {
        o.append(",\"").append("logicalType").append("\":\"").append(lt.getName()).append("\"");
        if (lt.getName().equals("decimal")) {
            LogicalTypes.Decimal dlt = (LogicalTypes.Decimal)lt;
            o.append(",\"precision\":").append(Integer.toString(dlt.getPrecision()));
            if (dlt.getScale() != 0) {
                o.append(",\"scale\":").append(Integer.toString(dlt.getScale()));
            }
        }
    }

    private static void setSimpleProps(Appendable o, Map<String, Object> schemaProps) throws IOException {
        TreeMap<String, Object> sortedProps = new TreeMap<String, Object>(schemaProps);
        for (Map.Entry entry : sortedProps.entrySet()) {
            String propKey = (String)entry.getKey();
            String propValue = AvroSchemaUtils.toJsonNode(entry.getValue()).toString();
            o.append(",\"").append(propKey).append("\":").append(propValue);
        }
    }

    private static void setComplexProps(Appendable o, Schema s) throws IOException {
        Set aliases;
        if (s.getDoc() != null && !s.getDoc().isEmpty()) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(s.getDoc()).toString());
        }
        if (!(aliases = s.getAliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet(aliases)).toString());
        }
        if (s.getType() == Schema.Type.ENUM && s.getEnumDefault() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(s.getEnumDefault()).toString());
        }
    }

    private static void setFieldProps(Appendable o, Schema.Field f) throws IOException {
        Set aliases;
        if (f.order() != null) {
            o.append(",\"order\":\"").append(f.order().toString()).append("\"");
        }
        if (f.doc() != null) {
            o.append(",\"doc\":").append(AvroSchemaUtils.toJsonNode(f.doc()).toString());
        }
        if (!(aliases = f.aliases()).isEmpty()) {
            o.append(",\"aliases\":").append(AvroSchemaUtils.toJsonNode(new TreeSet(aliases)).toString());
        }
        if (f.defaultVal() != null) {
            o.append(",\"default\":").append(AvroSchemaUtils.toJsonNode(f.defaultVal()).toString());
        }
        AvroSchemaUtils.setSimpleProps(o, f.getObjectProps());
    }

    static JsonNode toJsonNode(Object datum) {
        if (datum == null) {
            return null;
        }
        try {
            TokenBuffer generator = new TokenBuffer((ObjectCodec)jsonMapperWithOrderedProps, false);
            AvroSchemaUtils.genJson(datum, (JsonGenerator)generator);
            return (JsonNode)jsonMapperWithOrderedProps.readTree(generator.asParser());
        }
        catch (IOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    static void genJson(Object datum, JsonGenerator generator) throws IOException {
        if (datum == JsonProperties.NULL_VALUE) {
            generator.writeNull();
        } else if (datum instanceof Map) {
            generator.writeStartObject();
            for (Map.Entry entry : ((Map)datum).entrySet()) {
                generator.writeFieldName(entry.getKey().toString());
                AvroSchemaUtils.genJson(entry.getValue(), generator);
            }
            generator.writeEndObject();
        } else if (datum instanceof Collection) {
            generator.writeStartArray();
            for (Object element : (Collection)datum) {
                AvroSchemaUtils.genJson(element, generator);
            }
            generator.writeEndArray();
        } else if (datum instanceof byte[]) {
            generator.writeString(new String((byte[])datum, StandardCharsets.ISO_8859_1));
        } else if (datum instanceof CharSequence || datum instanceof Enum) {
            generator.writeString(datum.toString());
        } else if (datum instanceof Double) {
            generator.writeNumber(((Double)datum).doubleValue());
        } else if (datum instanceof Float) {
            generator.writeNumber(((Float)datum).floatValue());
        } else if (datum instanceof Long) {
            generator.writeNumber(((Long)datum).longValue());
        } else if (datum instanceof Integer) {
            generator.writeNumber(((Integer)datum).intValue());
        } else if (datum instanceof Boolean) {
            generator.writeBoolean(((Boolean)datum).booleanValue());
        } else if (datum instanceof BigInteger) {
            generator.writeNumber((BigInteger)datum);
        } else if (datum instanceof BigDecimal) {
            generator.writeNumber((BigDecimal)datum);
        } else {
            throw new AvroRuntimeException("Unknown datum class: " + datum.getClass());
        }
    }

    static {
        AvroSchemaUtils.addLogicalTypeConversion(GENERIC_DATA_INSTANCE_WITH_LOGICAL);
        AvroSchemaUtils.addLogicalTypeConversion((GenericData)REFLECT_DATA_INSTANCE_WITH_LOGICAL);
        AvroSchemaUtils.addLogicalTypeConversion((GenericData)REFLECT_DATA_ALLOW_NULL_INSTANCE_WITH_LOGICAL);
        AvroSchemaUtils.addLogicalTypeConversion((GenericData)SPECIFIC_DATA_INSTANCE_WITH_LOGICAL);
        genericData = new ThreadLocal();
        reflectData = new ThreadLocal();
        specificData = new ThreadLocal();
        encoderFactory = EncoderFactory.get();
        decoderFactory = DecoderFactory.get();
        jsonMapper = JacksonMapper.INSTANCE;
        jsonMapperWithOrderedProps = ((JsonMapper.Builder)JsonMapper.builder().nodeFactory((JsonNodeFactory)new SortingNodeFactory(false))).build();
        DEFAULT_CACHE_CAPACITY = 1000;
        transformedSchemas = new BoundedConcurrentHashMap<Schema, Schema>(DEFAULT_CACHE_CAPACITY);
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AvroSchemaUtils.createPrimitiveSchema("null"));
        primitiveSchemas.put("Boolean", AvroSchemaUtils.createPrimitiveSchema("boolean"));
        primitiveSchemas.put("Integer", AvroSchemaUtils.createPrimitiveSchema("int"));
        primitiveSchemas.put("Long", AvroSchemaUtils.createPrimitiveSchema("long"));
        primitiveSchemas.put("Float", AvroSchemaUtils.createPrimitiveSchema("float"));
        primitiveSchemas.put("Double", AvroSchemaUtils.createPrimitiveSchema("double"));
        primitiveSchemas.put("String", AvroSchemaUtils.createPrimitiveSchema("string"));
        primitiveSchemas.put("Bytes", AvroSchemaUtils.createPrimitiveSchema("bytes"));
    }

    static class JsonNodeWithNS {
        private final JsonNode node;
        private final String namespace;

        public JsonNodeWithNS(JsonNode node, String parentNamespace) {
            this.node = node;
            JsonNode namespaceNode = node.get("namespace");
            this.namespace = namespaceNode == null ? parentNamespace : namespaceNode.asText();
        }

        public JsonNode jsonNode() {
            return this.node;
        }

        public String namespace() {
            return this.namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonNodeWithNS other = (JsonNodeWithNS)o;
            return Objects.equals(this.namespace, other.namespace()) && Objects.equals(this.node, other.jsonNode());
        }

        public int hashCode() {
            int result = Objects.hashCode(this.node);
            result = 31 * result + Objects.hashCode(this.namespace);
            return result;
        }
    }

    static class NameAwareGenericData
    extends GenericData {
        private final GenericData delegate;

        public NameAwareGenericData() {
            this(null);
        }

        public NameAwareGenericData(GenericData delegate) {
            this.delegate = delegate;
        }

        public void setField(Object record, String name, int position, Object value) {
            if (record instanceof GenericRecord) {
                ((GenericRecord)record).put(name, value);
            } else {
                ((IndexedRecord)record).put(position, value);
            }
        }

        public Object getField(Object record, String name, int position) {
            if (record instanceof GenericRecord) {
                return ((GenericRecord)record).get(name);
            }
            return ((IndexedRecord)record).get(position);
        }

        public Collection<Conversion<?>> getConversions() {
            if (this.delegate != null) {
                return this.delegate.getConversions();
            }
            return super.getConversions();
        }

        public void addLogicalTypeConversion(Conversion<?> conversion) {
            if (this.delegate != null) {
                this.delegate.addLogicalTypeConversion(conversion);
            } else {
                super.addLogicalTypeConversion(conversion);
            }
        }

        public <T> Conversion<T> getConversionByClass(Class<T> datumClass) {
            if (this.delegate != null) {
                return this.delegate.getConversionByClass(datumClass);
            }
            return super.getConversionByClass(datumClass);
        }

        public <T> Conversion<T> getConversionByClass(Class<T> datumClass, LogicalType logicalType) {
            if (this.delegate != null) {
                return this.delegate.getConversionByClass(datumClass, logicalType);
            }
            return super.getConversionByClass(datumClass, logicalType);
        }

        public <T> Conversion<T> getConversionFor(LogicalType logicalType) {
            if (this.delegate != null) {
                return this.delegate.getConversionFor(logicalType);
            }
            return super.getConversionFor(logicalType);
        }

        public int resolveUnion(Schema union, Object datum) {
            if (this.delegate != null) {
                return this.delegate.resolveUnion(union, datum);
            }
            return super.resolveUnion(union, datum);
        }
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        public SortingNodeFactory(boolean bigDecimalExact) {
            super(bigDecimalExact);
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

