/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.function.udaf.KudafAggregator;
import io.confluent.ksql.execution.function.udaf.KudafInitializer;
import io.confluent.ksql.execution.function.udaf.KudafUndoAggregator;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import java.util.Optional;

public final class AggregateParams {
    private final KudafInitializer initializer;
    private final KudafAggregator aggregator;
    private final Optional<KudafUndoAggregator> undoAggregator;
    private final LogicalSchema aggregateSchema;
    private final LogicalSchema schema;

    AggregateParams(KudafInitializer initializer, KudafAggregator aggregator, Optional<KudafUndoAggregator> undoAggregator, LogicalSchema aggregateSchema, LogicalSchema schema) {
        this.initializer = Objects.requireNonNull(initializer, "initializer");
        this.aggregator = Objects.requireNonNull(aggregator, "aggregator");
        this.undoAggregator = Objects.requireNonNull(undoAggregator, "undoAggregator");
        this.aggregateSchema = Objects.requireNonNull(aggregateSchema, "aggregateSchema");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    KudafInitializer getInitializer() {
        return this.initializer;
    }

    <K> KudafAggregator<K> getAggregator() {
        return this.aggregator;
    }

    Optional<KudafUndoAggregator> getUndoAggregator() {
        return this.undoAggregator;
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public LogicalSchema getAggregateSchema() {
        return this.aggregateSchema;
    }
}

