/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.streams.GroupByParams;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.ColumnNames;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

final class GroupByParamsV1Factory {
    private static final String GROUP_BY_VALUE_SEPARATOR = "|+|";
    private static final Object EVAL_FAILED = new Object();

    private GroupByParamsV1Factory() {
    }

    public static LogicalSchema buildSchema(LogicalSchema sourceSchema, List<CompiledExpression> groupBys) {
        ProcessingLogger logger = NoopProcessingLogContext.NOOP_LOGGER;
        return GroupByParamsV1Factory.buildGrouper(sourceSchema, groupBys, logger).getSchema();
    }

    public static GroupByParams build(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
        if (groupBys.isEmpty()) {
            throw new IllegalArgumentException("No GROUP BY groupBys");
        }
        Grouper grouper = GroupByParamsV1Factory.buildGrouper(sourceSchema, groupBys, logger);
        return new GroupByParams(grouper.getSchema(), grouper::apply);
    }

    private static Grouper buildGrouper(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
        return groupBys.size() == 1 ? new SingleExpressionGrouper(sourceSchema, groupBys.get(0), logger) : new MultiExpressionGrouper(sourceSchema, groupBys, logger);
    }

    private static LogicalSchema buildSchemaWithKeyType(LogicalSchema sourceSchema, ColumnName keyName, SqlType keyType) {
        return LogicalSchema.builder().keyColumn(keyName, keyType).valueColumns((Iterable)sourceSchema.value()).build();
    }

    private static Object processColumn(int index, CompiledExpression exp, GenericRow row, ProcessingLogger logger) {
        Supplier<String> errorMsgSupplier = () -> "Error calculating group-by column with index " + index + ". The source row will be excluded from the table.";
        Object result = exp.evaluate(row, EVAL_FAILED, logger, errorMsgSupplier);
        if (result == EVAL_FAILED) {
            return null;
        }
        if (result == null) {
            logger.error(RecordProcessingError.recordProcessingError((String)("Group-by column with index " + index + " resolved to null. The source row will be excluded from the table."), (GenericRow)row));
            return null;
        }
        return result;
    }

    private static LogicalSchema multiExpressionSchema(LogicalSchema sourceSchema) {
        ColumnName keyName = ColumnNames.nextKsqlColAlias((LogicalSchema[])new LogicalSchema[]{sourceSchema});
        return GroupByParamsV1Factory.buildSchemaWithKeyType(sourceSchema, keyName, (SqlType)SqlTypes.STRING);
    }

    private static final class MultiExpressionGrouper
    implements Grouper {
        private final LogicalSchema schema;
        private final ImmutableList<CompiledExpression> groupBys;
        private final ProcessingLogger logger;

        MultiExpressionGrouper(LogicalSchema sourceSchema, List<CompiledExpression> groupBys, ProcessingLogger logger) {
            this.schema = GroupByParamsV1Factory.multiExpressionSchema(sourceSchema);
            this.groupBys = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupBys, "groupBys"));
            this.logger = Objects.requireNonNull(logger, "logger");
            if (this.groupBys.isEmpty()) {
                throw new IllegalArgumentException("Empty group by");
            }
        }

        @Override
        public LogicalSchema getSchema() {
            return this.schema;
        }

        @Override
        public GenericKey apply(GenericRow row) {
            StringBuilder key = new StringBuilder();
            for (int i = 0; i < this.groupBys.size(); ++i) {
                Object result = GroupByParamsV1Factory.processColumn(i, (CompiledExpression)this.groupBys.get(i), row, this.logger);
                if (result == null) {
                    return null;
                }
                if (key.length() > 0) {
                    key.append(GroupByParamsV1Factory.GROUP_BY_VALUE_SEPARATOR);
                }
                key.append(result);
            }
            return GenericKey.genericKey((Object[])new Object[]{key.toString()});
        }
    }

    private static final class SingleExpressionGrouper
    implements Grouper {
        private final LogicalSchema schema;
        private final CompiledExpression groupBy;
        private final ProcessingLogger logger;

        SingleExpressionGrouper(LogicalSchema sourceSchema, CompiledExpression groupBy, ProcessingLogger logger) {
            this.schema = SingleExpressionGrouper.singleExpressionSchema(sourceSchema, groupBy);
            this.groupBy = Objects.requireNonNull(groupBy, "groupBy");
            this.logger = Objects.requireNonNull(logger, "logger");
        }

        @Override
        public LogicalSchema getSchema() {
            return this.schema;
        }

        @Override
        public GenericKey apply(GenericRow row) {
            Object key = GroupByParamsV1Factory.processColumn(0, this.groupBy, row, this.logger);
            if (key == null) {
                return null;
            }
            return GenericKey.genericKey((Object[])new Object[]{key});
        }

        private static LogicalSchema singleExpressionSchema(LogicalSchema sourceSchema, CompiledExpression groupBy) {
            SqlType keyType = groupBy.getExpressionType();
            Expression groupByExp = groupBy.getExpression();
            ColumnName singleColumnName = groupByExp instanceof ColumnReferenceExp ? ((ColumnReferenceExp)groupByExp).getColumnName() : ColumnNames.uniqueAliasFor((Expression)groupByExp, (LogicalSchema[])new LogicalSchema[]{sourceSchema});
            return GroupByParamsV1Factory.buildSchemaWithKeyType(sourceSchema, singleColumnName, keyType);
        }
    }

    private static interface Grouper {
        public LogicalSchema getSchema();

        public GenericKey apply(GenericRow var1);
    }
}

