/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.base.Preconditions;
import io.confluent.ksql.GenericRow;
import java.util.Collection;
import java.util.Objects;
import org.apache.kafka.streams.kstream.ValueJoiner;

public final class KsqlValueJoiner
implements ValueJoiner<GenericRow, GenericRow, GenericRow> {
    private final int leftCount;
    private final int rightCount;
    private final int additionalCount;

    KsqlValueJoiner(int leftCount, int rightCount, int additionalCount) {
        Preconditions.checkArgument((leftCount >= 0 ? 1 : 0) != 0, (Object)("leftCount negative: " + leftCount));
        Preconditions.checkArgument((rightCount >= 0 ? 1 : 0) != 0, (Object)("rightCount negative: " + rightCount));
        Preconditions.checkArgument((additionalCount >= 0 ? 1 : 0) != 0, (Object)("additionalCount negative: " + additionalCount));
        this.leftCount = leftCount;
        this.rightCount = rightCount;
        this.additionalCount = additionalCount;
    }

    public GenericRow apply(GenericRow left, GenericRow right) {
        GenericRow row = new GenericRow(this.leftCount + this.rightCount + this.additionalCount);
        if (left != null) {
            row.appendAll((Collection)left.values());
        } else {
            KsqlValueJoiner.fillWithNulls(row, this.leftCount);
        }
        if (right != null) {
            row.appendAll((Collection)right.values());
        } else {
            KsqlValueJoiner.fillWithNulls(row, this.rightCount);
        }
        KsqlValueJoiner.fillWithNulls(row, this.additionalCount);
        return row;
    }

    private static void fillWithNulls(GenericRow row, int numToFill) {
        for (int i = 0; i < numToFill; ++i) {
            row.append(null);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlValueJoiner that = (KsqlValueJoiner)o;
        return Objects.equals(this.leftCount, that.leftCount) && Objects.equals(this.rightCount, that.rightCount) && Objects.equals(this.additionalCount, that.additionalCount);
    }

    public int hashCode() {
        return Objects.hash(this.leftCount, this.rightCount, this.additionalCount);
    }

    public String toString() {
        return "KsqlValueJoiner{leftCount=" + this.leftCount + ", rightCount=" + this.rightCount + ", additionalCount=" + this.additionalCount + '}';
    }
}

