/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ForeignKeyTableTableJoin;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.plan.SourceStep;
import io.confluent.ksql.execution.plan.StreamAggregate;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.plan.StreamFlatMap;
import io.confluent.ksql.execution.plan.StreamGroupBy;
import io.confluent.ksql.execution.plan.StreamGroupByKey;
import io.confluent.ksql.execution.plan.StreamGroupByV1;
import io.confluent.ksql.execution.plan.StreamSelect;
import io.confluent.ksql.execution.plan.StreamSelectKey;
import io.confluent.ksql.execution.plan.StreamSelectKeyV1;
import io.confluent.ksql.execution.plan.StreamSink;
import io.confluent.ksql.execution.plan.StreamSource;
import io.confluent.ksql.execution.plan.StreamStreamJoin;
import io.confluent.ksql.execution.plan.StreamTableJoin;
import io.confluent.ksql.execution.plan.StreamWindowedAggregate;
import io.confluent.ksql.execution.plan.TableAggregate;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.plan.TableGroupBy;
import io.confluent.ksql.execution.plan.TableGroupByV1;
import io.confluent.ksql.execution.plan.TableSelect;
import io.confluent.ksql.execution.plan.TableSelectKey;
import io.confluent.ksql.execution.plan.TableSink;
import io.confluent.ksql.execution.plan.TableSource;
import io.confluent.ksql.execution.plan.TableSourceV1;
import io.confluent.ksql.execution.plan.TableSuppress;
import io.confluent.ksql.execution.plan.TableTableJoin;
import io.confluent.ksql.execution.plan.WindowedStreamSource;
import io.confluent.ksql.execution.plan.WindowedTableSource;
import io.confluent.ksql.execution.streams.AggregateParamsFactory;
import io.confluent.ksql.execution.streams.ForeignKeyJoinParamsFactory;
import io.confluent.ksql.execution.streams.GroupByParamsFactory;
import io.confluent.ksql.execution.streams.GroupByParamsV1Factory;
import io.confluent.ksql.execution.streams.JoinParamsFactory;
import io.confluent.ksql.execution.streams.PartitionByParamsFactory;
import io.confluent.ksql.execution.streams.StreamFlatMapBuilder;
import io.confluent.ksql.execution.transform.select.Selection;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.HandlerMaps;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class StepSchemaResolver {
    private static final HandlerMaps.ClassHandlerMapR2<ExecutionStep, StepSchemaResolver, LogicalSchema, LogicalSchema> HANDLERS = HandlerMaps.forClass(ExecutionStep.class).withArgTypes(StepSchemaResolver.class, LogicalSchema.class).withReturnType(LogicalSchema.class).put(StreamAggregate.class, StepSchemaResolver::handleStreamAggregate).put(StreamWindowedAggregate.class, StepSchemaResolver::handleStreamWindowedAggregate).put(StreamFilter.class, StepSchemaResolver::sameSchema).put(StreamFlatMap.class, StepSchemaResolver::handleStreamFlatMap).put(StreamGroupByV1.class, StepSchemaResolver::handleStreamGroupByV1).put(StreamGroupBy.class, StepSchemaResolver::handleStreamGroupBy).put(StreamGroupByKey.class, StepSchemaResolver::sameSchema).put(StreamSelect.class, StepSchemaResolver::handleStreamSelect).put(StreamSelectKeyV1.class, StepSchemaResolver::handleStreamSelectKeyV1).put(StreamSelectKey.class, StepSchemaResolver::handleStreamSelectKey).put(StreamSink.class, StepSchemaResolver::sameSchema).put(StreamSource.class, StepSchemaResolver::handleSource).put(WindowedStreamSource.class, StepSchemaResolver::handleWindowedSource).put(TableAggregate.class, StepSchemaResolver::handleTableAggregate).put(TableFilter.class, StepSchemaResolver::sameSchema).put(TableGroupByV1.class, StepSchemaResolver::handleTableGroupByV1).put(TableGroupBy.class, StepSchemaResolver::handleTableGroupBy).put(TableSelect.class, StepSchemaResolver::handleTableSelect).put(TableSelectKey.class, StepSchemaResolver::handleTableSelectKey).put(TableSuppress.class, StepSchemaResolver::sameSchema).put(TableSink.class, StepSchemaResolver::sameSchema).put(TableSourceV1.class, StepSchemaResolver::handleSource).put(TableSource.class, StepSchemaResolver::handleSource).put(WindowedTableSource.class, StepSchemaResolver::handleWindowedSource).build();
    private static final HandlerMaps.ClassHandlerMapR2<ExecutionStep, StepSchemaResolver, JoinSchemas, LogicalSchema> JOIN_HANDLERS = HandlerMaps.forClass(ExecutionStep.class).withArgTypes(StepSchemaResolver.class, JoinSchemas.class).withReturnType(LogicalSchema.class).put(StreamTableJoin.class, StepSchemaResolver::handleStreamTableJoin).put(StreamStreamJoin.class, StepSchemaResolver::handleStreamStreamJoin).put(TableTableJoin.class, StepSchemaResolver::handleTableTableJoin).put(ForeignKeyTableTableJoin.class, StepSchemaResolver::handleForeignKeyTableTableJoin).build();
    private final KsqlConfig ksqlConfig;
    private final FunctionRegistry functionRegistry;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public StepSchemaResolver(KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig);
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
    }

    public LogicalSchema resolve(ExecutionStep<?> step, LogicalSchema schema) {
        return Optional.ofNullable(HANDLERS.get(step.getClass())).map(h -> (LogicalSchema)h.handle((Object)this, (Object)schema, (Object)step)).orElseThrow(() -> new IllegalStateException("Unhandled step class: " + step.getClass()));
    }

    public LogicalSchema resolve(ExecutionStep<?> step, LogicalSchema left, LogicalSchema right) {
        return Optional.ofNullable(JOIN_HANDLERS.get(step.getClass())).map(h -> (LogicalSchema)h.handle((Object)this, (Object)new JoinSchemas(left, right), (Object)step)).orElseThrow(() -> new IllegalStateException("Unhandled step class: " + step.getClass()));
    }

    private LogicalSchema handleStreamAggregate(LogicalSchema schema, StreamAggregate step) {
        return this.buildAggregateSchema(schema, step.getNonAggregateColumns(), step.getAggregationFunctions(), false);
    }

    private LogicalSchema handleStreamWindowedAggregate(LogicalSchema schema, StreamWindowedAggregate step) {
        return this.buildAggregateSchema(schema, step.getNonAggregateColumns(), step.getAggregationFunctions(), true);
    }

    private LogicalSchema handleStreamFlatMap(LogicalSchema schema, StreamFlatMap<?> streamFlatMap) {
        return StreamFlatMapBuilder.buildSchema(schema, streamFlatMap.getTableFunctions(), this.functionRegistry);
    }

    private LogicalSchema handleStreamGroupByV1(LogicalSchema sourceSchema, StreamGroupByV1<?> streamGroupBy) {
        List compiledGroupBy = CodeGenRunner.compileExpressions(streamGroupBy.getGroupByExpressions().stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.ksqlConfig, (FunctionRegistry)this.functionRegistry);
        return GroupByParamsV1Factory.buildSchema(sourceSchema, compiledGroupBy);
    }

    private LogicalSchema handleStreamGroupBy(LogicalSchema sourceSchema, StreamGroupBy<?> streamGroupBy) {
        List compiledGroupBy = CodeGenRunner.compileExpressions(streamGroupBy.getGroupByExpressions().stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.ksqlConfig, (FunctionRegistry)this.functionRegistry);
        return GroupByParamsFactory.buildSchema(sourceSchema, compiledGroupBy);
    }

    private LogicalSchema handleTableGroupByV1(LogicalSchema sourceSchema, TableGroupByV1<?> tableGroupBy) {
        List compiledGroupBy = CodeGenRunner.compileExpressions(tableGroupBy.getGroupByExpressions().stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.ksqlConfig, (FunctionRegistry)this.functionRegistry);
        return GroupByParamsV1Factory.buildSchema(sourceSchema, compiledGroupBy);
    }

    private LogicalSchema handleTableGroupBy(LogicalSchema sourceSchema, TableGroupBy<?> tableGroupBy) {
        List compiledGroupBy = CodeGenRunner.compileExpressions(tableGroupBy.getGroupByExpressions().stream(), (String)"Group By", (LogicalSchema)sourceSchema, (KsqlConfig)this.ksqlConfig, (FunctionRegistry)this.functionRegistry);
        return GroupByParamsFactory.buildSchema(sourceSchema, compiledGroupBy);
    }

    private LogicalSchema handleStreamSelect(LogicalSchema schema, StreamSelect<?> step) {
        return this.buildSelectSchema(schema, step.getKeyColumnNames(), step.getSelectedKeys(), step.getSelectExpressions());
    }

    private LogicalSchema handleStreamSelectKeyV1(LogicalSchema sourceSchema, StreamSelectKeyV1 step) {
        ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(sourceSchema, this.functionRegistry);
        SqlType keyType = expressionTypeManager.getExpressionSqlType(step.getKeyExpression());
        return LogicalSchema.builder().keyColumn(SystemColumns.ROWKEY_NAME, keyType).valueColumns((Iterable)sourceSchema.value()).build();
    }

    private LogicalSchema handleStreamSelectKey(LogicalSchema sourceSchema, StreamSelectKey<?> step) {
        return PartitionByParamsFactory.buildSchema(sourceSchema, step.getKeyExpressions(), this.functionRegistry);
    }

    private LogicalSchema handleSource(LogicalSchema schema, SourceStep<?> step) {
        return this.buildSourceSchema(schema, false, step.getPseudoColumnVersion());
    }

    private LogicalSchema handleWindowedSource(LogicalSchema schema, SourceStep<?> step) {
        return this.buildSourceSchema(schema, true, step.getPseudoColumnVersion());
    }

    private LogicalSchema handleStreamStreamJoin(JoinSchemas schemas, StreamStreamJoin<?> step) {
        return this.handleJoin(schemas, step.getKeyColName());
    }

    private LogicalSchema handleStreamTableJoin(JoinSchemas schemas, StreamTableJoin<?> step) {
        return this.handleJoin(schemas, step.getKeyColName());
    }

    private LogicalSchema handleTableTableJoin(JoinSchemas schemas, TableTableJoin<?> step) {
        return this.handleJoin(schemas, step.getKeyColName());
    }

    private LogicalSchema handleForeignKeyTableTableJoin(JoinSchemas schemas, ForeignKeyTableTableJoin<?, ?> step) {
        return ForeignKeyJoinParamsFactory.createSchema(schemas.left, schemas.right);
    }

    private LogicalSchema handleJoin(JoinSchemas schemas, ColumnName keyColName) {
        return JoinParamsFactory.createSchema(keyColName, schemas.left, schemas.right);
    }

    private LogicalSchema handleTableAggregate(LogicalSchema schema, TableAggregate step) {
        return this.buildAggregateSchema(schema, step.getNonAggregateColumns(), step.getAggregationFunctions(), false);
    }

    private LogicalSchema handleTableSelect(LogicalSchema schema, TableSelect<?> step) {
        return this.buildSelectSchema(schema, step.getKeyColumnNames(), Optional.empty(), step.getSelectExpressions());
    }

    private LogicalSchema handleTableSelectKey(LogicalSchema sourceSchema, TableSelectKey<?> step) {
        return PartitionByParamsFactory.buildSchema(sourceSchema, step.getKeyExpressions(), this.functionRegistry);
    }

    private LogicalSchema sameSchema(LogicalSchema schema, ExecutionStep<?> step) {
        return schema;
    }

    private LogicalSchema buildSourceSchema(LogicalSchema schema, boolean windowed, int pseudoColumnVersion) {
        return schema.withPseudoAndKeyColsInValue(windowed, pseudoColumnVersion);
    }

    private LogicalSchema buildSelectSchema(LogicalSchema schema, List<ColumnName> keyColumnNames, Optional<ImmutableList<ColumnName>> selectedKeys, List<SelectExpression> selectExpressions) {
        return Selection.of((LogicalSchema)schema, keyColumnNames, selectedKeys, selectExpressions, (KsqlConfig)this.ksqlConfig, (FunctionRegistry)this.functionRegistry).getSchema();
    }

    private LogicalSchema buildAggregateSchema(LogicalSchema schema, List<ColumnName> nonAggregateColumns, List<FunctionCall> aggregationFunctions, boolean windowedAggregation) {
        return new AggregateParamsFactory().create(schema, nonAggregateColumns, this.functionRegistry, aggregationFunctions, windowedAggregation, this.ksqlConfig).getSchema();
    }

    private static final class JoinSchemas {
        private final LogicalSchema left;
        private final LogicalSchema right;

        private JoinSchemas(LogicalSchema left, LogicalSchema right) {
            this.left = Objects.requireNonNull(left, "left");
            this.right = Objects.requireNonNull(right, "right");
        }
    }
}

