/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.StreamFilter;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.SqlPredicateFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.execution.transform.sqlpredicate.SqlPredicate;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.processor.ProcessorContext;

public final class StreamFilterBuilder {
    private StreamFilterBuilder() {
    }

    public static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamFilter<K> step, RuntimeBuildContext buildContext) {
        return StreamFilterBuilder.build(stream, step, buildContext, SqlPredicate::new);
    }

    static <K> KStreamHolder<K> build(KStreamHolder<K> stream, StreamFilter<K> step, RuntimeBuildContext buildContext, SqlPredicateFactory predicateFactory) {
        SqlPredicate predicate = predicateFactory.create(step.getFilterExpression(), stream.getSchema(), buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        ProcessingLogger processingLogger = buildContext.getProcessingLogger(step.getProperties().getQueryContext());
        KStream filtered = stream.getStream().flatTransformValues(() -> StreamFilterBuilder.toFlatMapTransformer(predicate.getTransformer(processingLogger)), Named.as((String)StreamsUtil.buildOpName(step.getProperties().getQueryContext())), new String[0]);
        return stream.withStream(filtered, stream.getSchema());
    }

    private static <K> ValueTransformerWithKey<K, GenericRow, Iterable<GenericRow>> toFlatMapTransformer(KsqlTransformer<K, Optional<GenericRow>> transformer) {
        final KsValueTransformer<K, Optional<GenericRow>> delegate = new KsValueTransformer<K, Optional<GenericRow>>(transformer);
        return new ValueTransformerWithKey<K, GenericRow, Iterable<GenericRow>>(){

            public void init(ProcessorContext context) {
                delegate.init(context);
            }

            public Iterable<GenericRow> transform(K readOnlyKey, GenericRow value) {
                Optional result = (Optional)delegate.transform(readOnlyKey, (Object)value);
                return result.map(Collections::singletonList).orElse(Collections.emptyList());
            }

            public void close() {
                delegate.close();
            }
        };
    }
}

