/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams;

import io.confluent.ksql.execution.context.QueryContext;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.TableFilter;
import io.confluent.ksql.execution.runtime.RuntimeBuildContext;
import io.confluent.ksql.execution.streams.SqlPredicateFactory;
import io.confluent.ksql.execution.streams.StreamsUtil;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.sqlpredicate.SqlPredicate;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import java.util.Optional;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Named;

public final class TableFilterBuilder {
    private static final String PRE_PROCESS_OP = "ApplyPredicate";
    private static final String FILTER_OP = "Filter";
    private static final String POST_PROCESS_OP = "PostProcess";

    private TableFilterBuilder() {
    }

    public static <K> KTableHolder<K> build(KTableHolder<K> table, TableFilter<K> step, RuntimeBuildContext buildContext) {
        return TableFilterBuilder.build(table, step, buildContext, SqlPredicate::new);
    }

    static <K> KTableHolder<K> build(KTableHolder<K> table, TableFilter<K> step, RuntimeBuildContext buildContext, SqlPredicateFactory sqlPredicateFactory) {
        SqlPredicate predicate = sqlPredicateFactory.create(step.getFilterExpression(), table.getSchema(), buildContext.getKsqlConfig(), buildContext.getFunctionRegistry());
        ProcessingLogger processingLogger = buildContext.getProcessingLogger(step.getProperties().getQueryContext());
        QueryContext.Stacker stacker = QueryContext.Stacker.of((QueryContext)step.getProperties().getQueryContext());
        KTable filtered = table.getTable().transformValues(() -> new KsValueTransformer(predicate.getTransformer(processingLogger)), Named.as((String)StreamsUtil.buildOpName(stacker.push(new String[]{PRE_PROCESS_OP}).getQueryContext())), new String[0]).filter((k, v) -> v.isPresent(), Named.as((String)StreamsUtil.buildOpName(stacker.push(new String[]{FILTER_OP}).getQueryContext()))).mapValues(Optional::get, Named.as((String)StreamsUtil.buildOpName(stacker.push(new String[]{POST_PROCESS_OP}).getQueryContext())));
        return table.withTable(filtered, table.getSchema()).withMaterialization(table.getMaterializationBuilder().map(b -> b.filter(arg_0 -> ((SqlPredicate)predicate).getTransformer(arg_0), step.getProperties().getQueryContext())));
    }
}

