/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.Window;
import io.confluent.ksql.execution.streams.materialization.TableRow;
import io.confluent.ksql.execution.streams.materialization.TableRowValidation;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import java.util.Optional;

public final class Row
implements TableRow {
    private final LogicalSchema schema;
    private final GenericKey key;
    private final GenericRow value;
    private final long rowTime;
    private final TableRowValidation.Validator validator;

    public static Row of(LogicalSchema schema, GenericKey key, GenericRow value, long rowTime) {
        return new Row(schema, key, value, rowTime, TableRowValidation::validate);
    }

    @VisibleForTesting
    Row(LogicalSchema schema, GenericKey key, GenericRow value, long rowTime, TableRowValidation.Validator validator) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.rowTime = rowTime;
        this.validator = Objects.requireNonNull(validator, "validator");
        validator.validate(schema, key, value);
    }

    @Override
    public LogicalSchema schema() {
        return this.schema;
    }

    @Override
    public long rowTime() {
        return this.rowTime;
    }

    @Override
    public GenericKey key() {
        return this.key;
    }

    @Override
    public Optional<Window> window() {
        return Optional.empty();
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public GenericRow value() {
        return this.value;
    }

    @Override
    public Row withValue(GenericRow newValue, LogicalSchema newSchema) {
        return new Row(newSchema, this.key, newValue, this.rowTime, this.validator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row that = (Row)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.rowTime, that.rowTime);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.key, this.value, this.rowTime);
    }

    public String toString() {
        return "Row{key=" + this.key + ", value=" + this.value + ", rowTime=" + this.rowTime + ", schema=" + this.schema + '}';
    }
}

