/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.Window;
import io.confluent.ksql.execution.streams.materialization.TableRow;
import io.confluent.ksql.execution.streams.materialization.TableRowValidation;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.kstream.Windowed;

public final class WindowedRow
implements TableRow {
    private final LogicalSchema schema;
    private final Windowed<GenericKey> key;
    private final GenericRow value;
    private final long rowTime;
    private final TableRowValidation.Validator validator;

    public static WindowedRow of(LogicalSchema schema, Windowed<GenericKey> key, GenericRow value, long rowTime) {
        return new WindowedRow(schema, key, value, rowTime, TableRowValidation::validate);
    }

    @VisibleForTesting
    WindowedRow(LogicalSchema schema, Windowed<GenericKey> key, GenericRow value, long rowTime, TableRowValidation.Validator validator) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
        this.rowTime = rowTime;
        this.validator = Objects.requireNonNull(validator, "validator");
        validator.validate(schema, (GenericKey)key.key(), value);
    }

    @Override
    public LogicalSchema schema() {
        return this.schema;
    }

    @Override
    public long rowTime() {
        return this.rowTime;
    }

    @Override
    public GenericKey key() {
        return (GenericKey)this.key.key();
    }

    public Windowed<GenericKey> windowedKey() {
        return this.key;
    }

    @Override
    public Optional<Window> window() {
        return Optional.of(Window.of((Instant)this.key.window().startTime(), (Instant)this.key.window().endTime()));
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public GenericRow value() {
        return this.value;
    }

    @Override
    public WindowedRow withValue(GenericRow newValue, LogicalSchema newSchema) {
        return new WindowedRow(newSchema, this.key, newValue, this.rowTime, this.validator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedRow that = (WindowedRow)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.rowTime, that.rowTime);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.schema, this.rowTime);
    }

    public String toString() {
        return "WindowedRow{key=" + this.key + ", value=" + this.value + ", rowTime=" + this.rowTime + ", schema=" + this.schema + '}';
    }
}

