/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterialization;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedTable;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedSessionTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedWindowTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.SessionStoreCacheBypass;
import io.confluent.ksql.execution.streams.materialization.ks.WindowStoreCacheBypass;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.WindowInfo;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public final class KsMaterialization
implements StreamsMaterialization {
    private final Optional<WindowInfo> windowInfo;
    private final KsStateStore stateStore;
    private final Locator locator;

    KsMaterialization(Optional<WindowInfo> windowInfo, Locator locator, KsStateStore stateStore) {
        this.windowInfo = Objects.requireNonNull(windowInfo, "windowInfo");
        this.stateStore = Objects.requireNonNull(stateStore, "stateStore");
        this.locator = Objects.requireNonNull(locator, "locator");
    }

    @Override
    public LogicalSchema schema() {
        return this.stateStore.schema();
    }

    @Override
    public Locator locator() {
        return this.locator;
    }

    @Override
    public Optional<WindowType> windowType() {
        return this.windowInfo.map(WindowInfo::getType);
    }

    @Override
    public StreamsMaterializedTable nonWindowed() {
        if (this.windowInfo.isPresent()) {
            throw new UnsupportedOperationException("Table has windowed key");
        }
        return new KsMaterializedTable(this.stateStore);
    }

    @Override
    public StreamsMaterializedWindowedTable windowed() {
        if (!this.windowInfo.isPresent()) {
            throw new UnsupportedOperationException("Table has non-windowed key");
        }
        WindowInfo wndInfo = this.windowInfo.get();
        WindowType wndType = wndInfo.getType();
        switch (wndType) {
            case SESSION: {
                return new KsMaterializedSessionTable(this.stateStore, SessionStoreCacheBypass::fetch, SessionStoreCacheBypass::fetchRange);
            }
            case HOPPING: 
            case TUMBLING: {
                return new KsMaterializedWindowTable(this.stateStore, (Duration)wndInfo.getSize().get(), WindowStoreCacheBypass::fetch, WindowStoreCacheBypass::fetchAll, WindowStoreCacheBypass::fetchRange);
            }
        }
        throw new UnsupportedOperationException("Unknown window type: " + wndInfo);
    }
}

