/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.execution.streams.materialization.Locator;
import io.confluent.ksql.execution.streams.materialization.ks.KsLocator;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterialization;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.WindowInfo;
import io.confluent.ksql.util.KsqlConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.Topology;

public final class KsMaterializationFactory {
    private final LocatorFactory locatorFactory;
    private final StateStoreFactory storeFactory;
    private final MaterializationFactory materializationFactory;

    public KsMaterializationFactory() {
        this(KsLocator::new, KsStateStore::new, KsMaterialization::new);
    }

    @VisibleForTesting
    KsMaterializationFactory(LocatorFactory locatorFactory, StateStoreFactory storeFactory, MaterializationFactory materializationFactory) {
        this.locatorFactory = Objects.requireNonNull(locatorFactory, "locatorFactory");
        this.storeFactory = Objects.requireNonNull(storeFactory, "storeFactory");
        this.materializationFactory = Objects.requireNonNull(materializationFactory, "materializationFactory");
    }

    public Optional<KsMaterialization> create(String stateStoreName, KafkaStreams kafkaStreams, Topology topology, LogicalSchema schema, Serializer<GenericKey> keySerializer, Optional<WindowInfo> windowInfo, Map<String, ?> streamsProperties, KsqlConfig ksqlConfig, String applicationId, String queryId) {
        Object appServer = streamsProperties.get("application.server");
        if (appServer == null) {
            return Optional.empty();
        }
        URL localHost = KsMaterializationFactory.buildLocalHost(appServer);
        KsLocator locator = this.locatorFactory.create(stateStoreName, kafkaStreams, topology, keySerializer, localHost, ksqlConfig.getBoolean("ksql.runtime.feature.shared.enabled"), queryId);
        KsStateStore stateStore = this.storeFactory.create(stateStoreName, kafkaStreams, schema, ksqlConfig, queryId);
        KsMaterialization materialization = this.materializationFactory.create(windowInfo, locator, stateStore);
        return Optional.of(materialization);
    }

    private static URL buildLocalHost(Object appServer) {
        if (!(appServer instanceof String)) {
            throw new IllegalArgumentException("application.server not String");
        }
        try {
            return new URL((String)appServer);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("application.server malformed: '" + appServer + "'");
        }
    }

    static interface MaterializationFactory {
        public KsMaterialization create(Optional<WindowInfo> var1, Locator var2, KsStateStore var3);
    }

    static interface StateStoreFactory {
        public KsStateStore create(String var1, KafkaStreams var2, LogicalSchema var3, KsqlConfig var4, String var5);
    }

    static interface LocatorFactory {
        public KsLocator create(String var1, KafkaStreams var2, Topology var3, Serializer<GenericKey> var4, URL var5, boolean var6, String var7);
    }
}

