/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedWindowedTable;
import io.confluent.ksql.execution.streams.materialization.WindowedRow;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.SessionStoreCacheBypass;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlySessionStore;

class KsMaterializedSessionTable
implements StreamsMaterializedWindowedTable {
    private final KsStateStore stateStore;
    private final SessionStoreCacheBypass.SessionStoreCacheBypassFetcher cacheBypassFetcher;
    private final SessionStoreCacheBypass.SessionStoreCacheBypassFetcherRange cacheBypassFetcherRange;

    KsMaterializedSessionTable(KsStateStore store, SessionStoreCacheBypass.SessionStoreCacheBypassFetcher cacheBypassFetcher, SessionStoreCacheBypass.SessionStoreCacheBypassFetcherRange cacheBypassFetcherRange) {
        this.stateStore = Objects.requireNonNull(store, "store");
        this.cacheBypassFetcher = Objects.requireNonNull(cacheBypassFetcher, "cacheBypassFetcher");
        this.cacheBypassFetcherRange = Objects.requireNonNull(cacheBypassFetcherRange, "cacheBypassFetcherRange");
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(GenericKey key, int partition, Range<Instant> windowStart, Range<Instant> windowEnd, Optional<Position> position) {
        try {
            ReadOnlySessionStore store = (ReadOnlySessionStore)this.stateStore.store(QueryableStoreTypes.sessionStore(), partition);
            return KsMaterializedQueryResult.rowIterator(this.findSession((ReadOnlySessionStore<GenericKey, GenericRow>)store, key, windowStart, windowEnd).iterator());
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to get value from materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<WindowedRow> get(int partition, Range<Instant> windowStartBounds, Range<Instant> windowEndBounds, Optional<Position> position) {
        throw new MaterializationException("Table scan unsupported on session tables");
    }

    private List<WindowedRow> findSession(ReadOnlySessionStore<GenericKey, GenericRow> store, GenericKey key, Range<Instant> windowStart, Range<Instant> windowEnd) {
        try (KeyValueIterator<Windowed<GenericKey>, GenericRow> it = this.cacheBypassFetcher.fetch(store, key);){
            ImmutableList.Builder builder = ImmutableList.builder();
            while (it.hasNext()) {
                KeyValue next = (KeyValue)it.next();
                Window wnd = ((Windowed)next.key).window();
                if (!windowStart.contains((Comparable)wnd.startTime()) || !windowEnd.contains((Comparable)wnd.endTime())) continue;
                long rowTime = wnd.end();
                WindowedRow row = WindowedRow.of(this.stateStore.schema(), (Windowed<GenericKey>)((Windowed)next.key), (GenericRow)next.value, rowTime);
                builder.add((Object)row);
            }
            ImmutableList immutableList = builder.build();
            return immutableList;
        }
    }
}

