/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.materialization.ks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.materialization.MaterializationException;
import io.confluent.ksql.execution.streams.materialization.Row;
import io.confluent.ksql.execution.streams.materialization.StreamsMaterializedTable;
import io.confluent.ksql.execution.streams.materialization.ks.KsMaterializedQueryResult;
import io.confluent.ksql.execution.streams.materialization.ks.KsStateStore;
import io.confluent.ksql.execution.streams.materialization.ks.NotUpToBoundException;
import io.confluent.ksql.util.IteratorUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.streams.query.FailureReason;
import org.apache.kafka.streams.query.KeyQuery;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.query.PositionBound;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.query.QueryResult;
import org.apache.kafka.streams.query.RangeQuery;
import org.apache.kafka.streams.query.StateQueryRequest;
import org.apache.kafka.streams.query.StateQueryResult;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ValueAndTimestamp;

class KsMaterializedTableIQv2
implements StreamsMaterializedTable {
    private final KsStateStore stateStore;

    KsMaterializedTableIQv2(KsStateStore store) {
        this.stateStore = Objects.requireNonNull(store, "store");
    }

    @Override
    public KsMaterializedQueryResult<Row> get(GenericKey key, int partition, Optional<Position> position) {
        try {
            StateQueryResult result;
            QueryResult queryResult;
            KeyQuery query = KeyQuery.withKey((Object)key);
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query).withPartitions((Set)ImmutableSet.of((Object)partition));
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = this.stateStore.getKafkaStreams().query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            if (queryResult.getResult() == null) {
                return KsMaterializedQueryResult.rowIteratorWithPosition(Collections.emptyIterator(), queryResult.getPosition());
            }
            ValueAndTimestamp row = (ValueAndTimestamp)queryResult.getResult();
            return KsMaterializedQueryResult.rowIteratorWithPosition(ImmutableList.of((Object)Row.of(this.stateStore.schema(), key, (GenericRow)row.value(), row.timestamp())).iterator(), queryResult.getPosition());
        }
        catch (MaterializationException | NotUpToBoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to get value from materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<Row> get(int partition, Optional<Position> position) {
        try {
            StateQueryResult result;
            QueryResult queryResult;
            RangeQuery query = RangeQuery.withNoBounds();
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query).withPartitions((Set)ImmutableSet.of((Object)partition));
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = this.stateStore.getKafkaStreams().query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            if (queryResult.getResult() == null) {
                return KsMaterializedQueryResult.rowIteratorWithPosition(Collections.emptyIterator(), queryResult.getPosition());
            }
            KeyValueIterator iterator = (KeyValueIterator)queryResult.getResult();
            return KsMaterializedQueryResult.rowIteratorWithPosition(Streams.stream((Iterator)IteratorUtil.onComplete((Iterator)iterator, () -> ((KeyValueIterator)iterator).close())).map(keyValue -> Row.of(this.stateStore.schema(), (GenericKey)keyValue.key, (GenericRow)((ValueAndTimestamp)keyValue.value).value(), ((ValueAndTimestamp)keyValue.value).timestamp())).iterator(), queryResult.getPosition());
        }
        catch (MaterializationException | NotUpToBoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to scan materialized table", e);
        }
    }

    @Override
    public KsMaterializedQueryResult<Row> get(int partition, GenericKey from, GenericKey to, Optional<Position> position) {
        try {
            StateQueryResult result;
            QueryResult queryResult;
            RangeQuery query = from != null && to != null ? RangeQuery.withRange((Object)from, (Object)to) : (from == null && to != null ? RangeQuery.withUpperBound((Object)to) : (from != null && to == null ? RangeQuery.withLowerBound((Object)from) : RangeQuery.withNoBounds()));
            StateQueryRequest request = StateQueryRequest.inStore((String)this.stateStore.getStateStoreName()).withQuery((Query)query).withPartitions((Set)ImmutableSet.of((Object)partition));
            if (position.isPresent()) {
                request = request.withPositionBound(PositionBound.at((Position)position.get()));
            }
            if ((queryResult = (QueryResult)(result = this.stateStore.getKafkaStreams().query(request)).getPartitionResults().get(partition)).isFailure()) {
                throw this.failedQueryException(queryResult);
            }
            if (queryResult.getResult() == null) {
                return KsMaterializedQueryResult.rowIteratorWithPosition(Collections.emptyIterator(), queryResult.getPosition());
            }
            KeyValueIterator iterator = (KeyValueIterator)queryResult.getResult();
            return KsMaterializedQueryResult.rowIteratorWithPosition(Streams.stream((Iterator)IteratorUtil.onComplete((Iterator)iterator, () -> ((KeyValueIterator)iterator).close())).map(keyValue -> Row.of(this.stateStore.schema(), (GenericKey)keyValue.key, (GenericRow)((ValueAndTimestamp)keyValue.value).value(), ((ValueAndTimestamp)keyValue.value).timestamp())).iterator(), queryResult.getPosition());
        }
        catch (MaterializationException | NotUpToBoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MaterializationException("Failed to range scan materialized table", e);
        }
    }

    private Exception failedQueryException(QueryResult<?> queryResult) {
        String message = "Failed to get value from materialized table: " + queryResult.getFailureReason() + ": " + queryResult.getFailureMessage();
        if (queryResult.getFailureReason().equals((Object)FailureReason.NOT_UP_TO_BOUND)) {
            return new NotUpToBoundException(message);
        }
        return new MaterializationException(message);
    }
}

