/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.timestamp.KsqlTimestampExtractor;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.streams.processor.TimestampExtractor;

public class LoggingTimestampExtractor
implements KsqlTimestampExtractor {
    private final KsqlTimestampExtractor delegate;
    private final ProcessingLogger logger;
    private final boolean failOnError;

    public LoggingTimestampExtractor(KsqlTimestampExtractor delegate, ProcessingLogger logger, boolean failOnError) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.failOnError = failOnError;
    }

    @Override
    public long extract(ConsumerRecord<Object, Object> record, long previousTimestamp) {
        try {
            return this.delegate.extract(record, previousTimestamp);
        }
        catch (RuntimeException e) {
            return this.handleFailure(record.key(), record.value(), e);
        }
    }

    @Override
    public long extract(Object key, GenericRow value) {
        try {
            return this.delegate.extract(key, value);
        }
        catch (RuntimeException e) {
            return this.handleFailure(key, value, e);
        }
    }

    @VisibleForTesting
    TimestampExtractor getDelegate() {
        return this.delegate;
    }

    private long handleFailure(Object key, Object value, RuntimeException e) {
        this.logger.error(RecordProcessingError.recordProcessingError((String)"Failed to extract timestamp from row", (Throwable)e, () -> "key:" + key + ", value:" + value));
        if (this.failOnError) {
            throw e;
        }
        return -1L;
    }
}

