/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.timestamp;

import io.confluent.ksql.execution.streams.timestamp.LongColumnTimestampExtractionPolicy;
import io.confluent.ksql.execution.streams.timestamp.MetadataTimestampExtractionPolicy;
import io.confluent.ksql.execution.streams.timestamp.StringTimestampExtractionPolicy;
import io.confluent.ksql.execution.streams.timestamp.TimestampColumnTimestampExtractionPolicy;
import io.confluent.ksql.execution.streams.timestamp.TimestampExtractionPolicy;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Optional;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.TimestampExtractor;

public final class TimestampExtractionPolicyFactory {
    private TimestampExtractionPolicyFactory() {
    }

    public static void validateTimestampColumn(KsqlConfig ksqlConfig, LogicalSchema schema, Optional<TimestampColumn> timestampColumn) {
        TimestampExtractionPolicyFactory.create(ksqlConfig, schema, timestampColumn);
    }

    public static TimestampExtractionPolicy create(KsqlConfig ksqlConfig, LogicalSchema schema, Optional<TimestampColumn> timestampColumn) {
        if (!timestampColumn.isPresent()) {
            return new MetadataTimestampExtractionPolicy(TimestampExtractionPolicyFactory.getDefaultTimestampExtractor(ksqlConfig));
        }
        ColumnName col = timestampColumn.get().getColumn();
        Optional timestampFormat = timestampColumn.get().getFormat();
        Column column = (Column)schema.findColumn(col).orElseThrow(() -> new KsqlException("The TIMESTAMP column set in the WITH clause does not exist in the schema: '" + col.toString(FormatOptions.noEscape()) + "'"));
        SqlBaseType tsColumnType = column.type().baseType();
        if (tsColumnType == SqlBaseType.STRING) {
            String format = (String)timestampFormat.orElseThrow(() -> new KsqlException("A String timestamp field has been specified without also specifying the " + "TIMESTAMP_FORMAT".toLowerCase()));
            return new StringTimestampExtractionPolicy(col, format);
        }
        if (timestampFormat.isPresent()) {
            throw new KsqlException("'TIMESTAMP_FORMAT' set in the WITH clause can only be used when the timestamp column is of type STRING.");
        }
        if (tsColumnType == SqlBaseType.BIGINT) {
            return new LongColumnTimestampExtractionPolicy(col);
        }
        if (tsColumnType == SqlBaseType.TIMESTAMP) {
            return new TimestampColumnTimestampExtractionPolicy(col);
        }
        throw new KsqlException("Timestamp column, " + col + ", should be LONG(INT64), TIMESTAMP, or a String with a " + "TIMESTAMP_FORMAT".toLowerCase() + " specified.");
    }

    private static TimestampExtractor getDefaultTimestampExtractor(KsqlConfig ksqlConfig) {
        try {
            Class<FailOnInvalidTimestamp> timestampExtractorClass = ksqlConfig.getKsqlStreamConfigProps().getOrDefault("default.timestamp.extractor", FailOnInvalidTimestamp.class);
            return (TimestampExtractor)timestampExtractorClass.newInstance();
        }
        catch (Exception e) {
            throw new KsqlException("Cannot override default timestamp extractor: " + e.getMessage(), (Throwable)e);
        }
    }
}

