/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.transform;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.streams.transform.KsValueTransformer;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.ProcessorContext;

public class KsTransformer<KInT, KOutT>
implements Transformer<KInT, GenericRow, KeyValue<KOutT, GenericRow>> {
    private final KsqlTransformer<KInT, KOutT> keyDelegate;
    private final KsqlTransformer<KInT, GenericRow> valueDelegate;
    private Optional<KsValueTransformer.KsProcessingContext> context;

    public KsTransformer(KsqlTransformer<KInT, KOutT> keyDelegate, KsqlTransformer<KInT, GenericRow> valueDelegate) {
        this.keyDelegate = Objects.requireNonNull(keyDelegate, "keyDelegate");
        this.valueDelegate = Objects.requireNonNull(valueDelegate, "valueDelegate");
        this.context = Optional.empty();
    }

    public void init(ProcessorContext processorContext) {
        this.context = Optional.of(new KsValueTransformer.KsProcessingContext(processorContext));
    }

    public KeyValue<KOutT, GenericRow> transform(KInT key, GenericRow value) {
        return KeyValue.pair((Object)this.keyDelegate.transform(key, value, (KsqlProcessingContext)this.context.orElseThrow(() -> new IllegalStateException("Not initialized"))), (Object)this.valueDelegate.transform(key, value, (KsqlProcessingContext)this.context.orElseThrow(() -> new IllegalStateException("Not initialized"))));
    }

    public void close() {
    }
}

