/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.streams.transform;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.transform.KsqlProcessingContext;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.processor.ProcessorContext;

public class KsValueTransformer<K, R>
implements ValueTransformerWithKey<K, GenericRow, R> {
    private final KsqlTransformer<K, R> delegate;
    private Optional<KsProcessingContext> context;

    public KsValueTransformer(KsqlTransformer<K, R> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.context = Optional.empty();
    }

    public void init(ProcessorContext processorContext) {
        this.context = Optional.of(new KsProcessingContext(processorContext));
    }

    public R transform(K readOnlyKey, GenericRow value) {
        return (R)this.delegate.transform(readOnlyKey, value, (KsqlProcessingContext)this.context.orElseThrow(() -> new IllegalStateException("Not initialized")));
    }

    public void close() {
    }

    public static final class KsProcessingContext
    implements KsqlProcessingContext {
        private final ProcessorContext processingContext;

        public KsProcessingContext(ProcessorContext processorContext) {
            this.processingContext = Objects.requireNonNull(processorContext, "processorContext");
        }

        public long getRowTime() {
            return this.processingContext.timestamp();
        }
    }
}

