/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.command.record.Command;
import io.confluent.license.LicenseManagerPurpose;
import io.confluent.license.LicenseStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LicenseStoreFactory {
    public static LicenseStore createAddOnLicenseStore(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, LicenseManagerPurpose purpose) {
        switch (purpose) {
            case CSFLE: {
                return LicenseStoreFactory.createCSFLELicenseStore(topic, producerConfig, consumerConfig, topicConfig);
            }
        }
        throw new IllegalArgumentException("Unknown license purpose: " + (Object)((Object)purpose));
    }

    private static LicenseStore createCSFLELicenseStore(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig) {
        List<Command.CommandKey> commandKey = Collections.singletonList(Command.CommandKey.newBuilder().setConfigType(Command.CommandConfigType.CSFLE_LICENSE_INFO).setGuid("CONFLUENT_CSFLE_LICENSE").build());
        return new LicenseStore(topic, producerConfig, consumerConfig, topicConfig, commandKey);
    }

    public static LicenseStore createTrialOnlyLicenseStore(String topic, Map<String, Object> producerConfig, Map<String, Object> consumerConfig, Map<String, Object> topicConfig, String licenseGuid) {
        List<Command.CommandKey> commandKey = Collections.singletonList(Command.CommandKey.newBuilder().setConfigType(Command.CommandConfigType.TRIAL_ONLY_LICENSE_INFO).setGuid(licenseGuid).build());
        return new LicenseStore(topic, producerConfig, consumerConfig, topicConfig, commandKey);
    }
}

