/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.printers;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class UsagePrinter {
    private final PrintWriter out;
    private final int maxSize;
    private final int indent;
    private final int hangingIndent;
    private final AtomicInteger currentPosition;

    public UsagePrinter(PrintWriter out) {
        this(out, 79);
    }

    public UsagePrinter(PrintWriter out, int maxSize) {
        this(out, maxSize, 0, 0, new AtomicInteger());
    }

    public UsagePrinter(PrintWriter out, int maxSize, int indent, int hangingIndent, AtomicInteger currentPosition) {
        if (out == null) {
            throw new NullPointerException("Writer cannot be null");
        }
        this.out = out;
        this.maxSize = maxSize;
        this.indent = indent;
        this.hangingIndent = hangingIndent;
        this.currentPosition = currentPosition;
    }

    public UsagePrinter newIndentedPrinter(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent + size, this.hangingIndent, this.currentPosition);
    }

    public UsagePrinter newPrinterWithHangingIndent(int size) {
        return new UsagePrinter(this.out, this.maxSize, this.indent, this.hangingIndent + size, this.currentPosition);
    }

    public UsagePrinter newline() {
        this.out.append("\n");
        this.currentPosition.set(0);
        return this;
    }

    public UsagePrinter appendTable(Iterable<? extends Iterable<String>> table, int rowSpacing) {
        int column;
        ArrayList<Integer> columnSizes = new ArrayList<Integer>();
        for (Iterable<String> iterable : table) {
            column = 0;
            for (String value : iterable) {
                while (column >= columnSizes.size()) {
                    columnSizes.add(0);
                }
                int valueLength = value != null ? value.length() : 0;
                columnSizes.set(column, Math.max(valueLength, (Integer)columnSizes.get(column)));
                ++column;
            }
        }
        if (this.currentPosition.get() != 0) {
            this.currentPosition.set(0);
            this.out.append("\n");
        }
        for (Iterable<String> iterable : table) {
            column = 0;
            StringBuilder line = new StringBuilder();
            for (String value : iterable) {
                int columnSize = (Integer)columnSizes.get(column);
                if (value != null) {
                    line.append(value);
                    line.append(UsagePrinter.spaces(columnSize - value.length()));
                } else {
                    line.append(UsagePrinter.spaces(columnSize));
                }
                line.append("   ");
                ++column;
            }
            this.out.append(UsagePrinter.spaces(this.indent)).append(UsagePrinter.trimEnd(line.toString())).append("\n");
            int i = 0;
            while (i < rowSpacing) {
                this.out.append('\n');
                ++i;
            }
        }
        return this;
    }

    public static String trimEnd(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        int end = str.length();
        while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
            --end;
        }
        return str.substring(0, end);
    }

    public UsagePrinter append(String value) {
        return this.append(value, false);
    }

    public UsagePrinter appendOnOneLine(String value) {
        return this.append(value, true);
    }

    public UsagePrinter appendWords(String[] words) {
        return this.appendWords(words, false);
    }

    public UsagePrinter appendWords(Iterable<String> words) {
        return this.appendWords(words, false);
    }

    public UsagePrinter append(String value, boolean avoidNewlines) {
        if (value == null) {
            return this;
        }
        if (avoidNewlines) {
            return this.appendWords(Arrays.asList(value.split("\\s+")), avoidNewlines);
        }
        return this.appendLines(Arrays.asList(StringUtils.split((String)value, (char)'\n')), avoidNewlines);
    }

    public UsagePrinter appendLines(Iterable<String> lines) {
        return this.appendLines(lines, false);
    }

    public UsagePrinter appendLines(Iterable<String> lines, boolean avoidNewlines) {
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            String line = iter.next();
            if (line == null || line.isEmpty()) continue;
            this.appendWords(Arrays.asList(line.split("\\s+")), avoidNewlines);
            if (!iter.hasNext()) continue;
            this.newline();
        }
        return this;
    }

    public UsagePrinter appendWords(String[] words, boolean avoidNewlines) {
        return this.appendWords(Arrays.asList(words), avoidNewlines);
    }

    public UsagePrinter appendWords(Iterable<String> words, boolean avoidNewlines) {
        int bracketCount = 0;
        for (String word : words) {
            if (StringUtils.isEmpty((CharSequence)word)) continue;
            if (this.currentPosition.get() == 0) {
                this.out.append(UsagePrinter.spaces(this.indent));
                this.currentPosition.getAndAdd(this.indent);
            } else if (word.length() > this.maxSize || this.currentPosition.get() + word.length() + 1 <= this.maxSize || bracketCount > 0 || avoidNewlines) {
                this.out.append(" ");
                this.currentPosition.getAndIncrement();
            } else {
                this.out.append("\n").append(UsagePrinter.spaces(this.indent)).append(UsagePrinter.spaces(this.hangingIndent));
                this.currentPosition.set(this.indent + this.hangingIndent);
            }
            this.out.append(word);
            this.currentPosition.getAndAdd(word.length());
            if (word.contains("{") || word.contains("[") || word.contains("<")) {
                ++bracketCount;
            }
            if (!word.contains("}") && !word.contains("]") && !word.contains(">")) continue;
            --bracketCount;
        }
        return this;
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    private static String spaces(int count) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < count) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }
}

