/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public final class ConnectSchemas {
    private ConnectSchemas() {
    }

    public static ConnectSchema columnsToConnectSchema(List<? extends SimpleColumn> columns) {
        SchemaConverters.SqlToConnectTypeConverter converter = SchemaConverters.sqlToConnectConverter();
        SchemaBuilder builder = SchemaBuilder.struct();
        for (SimpleColumn simpleColumn : columns) {
            Schema colSchema = converter.toConnectSchema(simpleColumn.type());
            builder.field(simpleColumn.name().text(), colSchema);
        }
        return (ConnectSchema)builder.build();
    }

    public static Object withCompatibleSchema(Schema schema, Object object) {
        if (object == null) {
            return null;
        }
        switch (schema.type()) {
            case ARRAY: {
                ArrayList ksqlArray = new ArrayList(((List)object).size());
                ((List)object).forEach(e -> ksqlArray.add(ConnectSchemas.withCompatibleSchema(schema.valueSchema(), e)));
                return ksqlArray;
            }
            case MAP: {
                HashMap ksqlMap = new HashMap();
                ((Map)object).forEach((key, value) -> ksqlMap.put(ConnectSchemas.withCompatibleSchema(schema.keySchema(), key), ConnectSchemas.withCompatibleSchema(schema.valueSchema(), value)));
                return ksqlMap;
            }
            case STRUCT: {
                return ConnectSchemas.withCompatibleRowSchema((Struct)object, schema);
            }
            case BYTES: {
                if (DecimalUtil.isDecimal((Schema)schema)) {
                    return DecimalUtil.ensureFit((BigDecimal)((BigDecimal)object), (Schema)schema);
                }
                return object;
            }
        }
        return object;
    }

    public static Struct withCompatibleRowSchema(Struct source, Schema targetSchema) {
        Struct struct = new Struct(targetSchema);
        Schema originalSchema = source.schema();
        Iterator sourceIt = originalSchema.fields().iterator();
        for (Field targetField : targetSchema.fields()) {
            Field sourceField = (Field)sourceIt.next();
            Object value = source.get(sourceField);
            Object adjusted = ConnectSchemas.withCompatibleSchema(targetField.schema(), value);
            struct.put(targetField, adjusted);
        }
        return struct;
    }
}

