/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.serializers.protobuf.ProtobufSchemaAndValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;

public class ProtobufNoSRConverter
implements Converter {
    private static final Serializer serializer = new Serializer();
    private static final Deserializer deserializer = new Deserializer();
    private final Schema schema;
    private ProtobufData protobufData;

    public ProtobufNoSRConverter() {
        this(null);
    }

    public ProtobufNoSRConverter(Schema schema) {
        this.schema = schema;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.protobufData = new ProtobufData(new ProtobufDataConfig(configs));
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (this.schema == null) {
            throw new UnsupportedOperationException("ProtobufNoSRConverter is an internal converter to ksqldb. It should not be instantiated via reflection through a no-arg constructor.");
        }
        try {
            ProtobufSchemaAndValue schemaAndValue = this.protobufData.fromConnectData(schema, value);
            Object v = schemaAndValue.getValue();
            if (v == null) {
                return null;
            }
            if (v instanceof Message) {
                return serializer.serialize((Message)v);
            }
            throw new DataException("Unsupported object of class " + v.getClass().getName());
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to serialize Protobuf data from topic %s :", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access Protobuf data from topic %s : %s", topic, e.getMessage()));
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        if (this.schema == null) {
            throw new UnsupportedOperationException("ProtobufNoSRConverter is an internal converter to ksqldb. It should not be instantiated via reflection through a no-arg constructor.");
        }
        try {
            ProtobufSchema protobufSchema = this.protobufData.fromConnectSchema(this.schema);
            Object deserialized = deserializer.deserialize(value, protobufSchema);
            if (deserialized == null) {
                return SchemaAndValue.NULL;
            }
            if (deserialized instanceof Message) {
                return this.protobufData.toConnectData(protobufSchema, (Message)deserialized);
            }
            throw new DataException(String.format("Unsupported type %s returned during deserialization of topic %s ", deserialized.getClass().getName(), topic));
        }
        catch (SerializationException e) {
            throw new DataException(String.format("Failed to deserialize data for topic %s to Protobuf: ", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access Protobuf data from topic %s : %s", topic, e.getMessage()));
        }
    }

    @VisibleForTesting
    public static class Deserializer {
        public Object deserialize(byte[] payload, ProtobufSchema schema) {
            if (payload == null) {
                return null;
            }
            try {
                ByteBuffer buffer = ByteBuffer.wrap(payload);
                Descriptors.Descriptor descriptor = schema.toDescriptor();
                if (descriptor == null) {
                    throw new SerializationException("Could not find descriptor with name " + schema.name());
                }
                int length = buffer.limit();
                int start = buffer.position() + buffer.arrayOffset();
                return DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (InputStream)new ByteArrayInputStream(buffer.array(), start, length));
            }
            catch (IOException | RuntimeException e) {
                throw new SerializationException("Error deserializing Protobuf message for schema " + schema, (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public static class Serializer {
        public byte[] serialize(Message value) {
            if (value == null) {
                return null;
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                value.writeTo((OutputStream)out);
                byte[] bytes = out.toByteArray();
                out.close();
                return bytes;
            }
            catch (IOException | RuntimeException e) {
                throw new SerializationException("Error serializing Protobuf message", (Throwable)e);
            }
        }
    }
}

