/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.confluent.connect.protobuf.ProtobufConverter;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.connect.SchemaWalker;
import io.confluent.ksql.serde.SerdeFactory;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.DataTranslator;
import io.confluent.ksql.serde.connect.KsqlConnectDeserializer;
import io.confluent.ksql.serde.connect.KsqlConnectSerializer;
import io.confluent.ksql.serde.protobuf.ProtobufDataTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufFormat;
import io.confluent.ksql.serde.protobuf.ProtobufProperties;
import io.confluent.ksql.serde.protobuf.ProtobufSRSchemaDataTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufSchemaTranslator;
import io.confluent.ksql.serde.tls.ThreadLocalDeserializer;
import io.confluent.ksql.serde.tls.ThreadLocalSerializer;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.storage.Converter;

final class ProtobufSerdeFactory
implements SerdeFactory {
    private final ProtobufProperties properties;
    private final Optional<String> fullSchemaName;

    ProtobufSerdeFactory(ProtobufProperties properties) {
        this.properties = Objects.requireNonNull(properties, "properties");
        this.fullSchemaName = Optional.ofNullable(properties.getFullSchemaName());
    }

    ProtobufSerdeFactory(ImmutableMap<String, String> formatProperties) {
        this(new ProtobufProperties((Map<String, String>)formatProperties));
    }

    private Optional<SchemaAndId> getSchemaFromSR(Supplier<SchemaRegistryClient> srFactory) {
        if (this.properties.getSchemaId().isPresent()) {
            return Optional.of(new SchemaAndId(this.properties.getSchemaId().get(), SerdeUtils.getParsedSchemaById(srFactory, this.properties.getSchemaId().get())));
        }
        if (this.properties.getSubjectName().isPresent()) {
            int schemaId = SerdeUtils.getLatestSchemaId(srFactory, this.properties.getSubjectName().get());
            return Optional.of(new SchemaAndId(schemaId, SerdeUtils.getParsedSchemaById(srFactory, schemaId)));
        }
        return Optional.empty();
    }

    @Override
    public <T> Serde<T> createSerde(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, boolean isKey) {
        ProtobufSerdeFactory.validate(schema);
        Optional<SchemaAndId> schemaAndId = this.getSchemaFromSR(srFactory);
        Optional<Schema> physicalSchema = schemaAndId.map(SchemaAndId::toConnectSchema);
        Optional<Integer> schemaId = schemaAndId.map(SchemaAndId::hasMultipleDefinitions).orElse(false) != false ? Optional.of(schemaAndId.get().getId()) : this.properties.getSchemaId();
        Supplier serializer = () -> this.createSerializer(schema, ksqlConfig, srFactory, targetType, schemaId, physicalSchema, isKey);
        Supplier deserializer = () -> this.createDeserializer(schema, ksqlConfig, srFactory, targetType, physicalSchema, isKey);
        serializer.get();
        deserializer.get();
        return Serdes.serdeFrom(new ThreadLocalSerializer(serializer), new ThreadLocalDeserializer(deserializer));
    }

    private static void validate(Schema schema) {
        SchemaWalker.visit((Schema)schema, (SchemaWalker.Visitor)new SchemaValidator());
    }

    private <T> KsqlConnectSerializer<T> createSerializer(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, Optional<Integer> schemaId, Optional<Schema> physicalSchema, boolean isKey) {
        ProtobufConverter converter = this.getConverter(srFactory.get(), ksqlConfig, schemaId, isKey);
        DataTranslator translator = this.getDataTranslator(schema, physicalSchema, false);
        Schema compatibleSchema = translator instanceof ProtobufDataTranslator ? ((ProtobufDataTranslator)translator).getSchema() : ((ConnectDataTranslator)translator).getSchema();
        return new KsqlConnectSerializer<T>(physicalSchema.orElse(compatibleSchema), translator, (Converter)converter, targetType);
    }

    private <T> KsqlConnectDeserializer<T> createDeserializer(Schema schema, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srFactory, Class<T> targetType, Optional<Schema> physicalSchema, boolean isKey) {
        ProtobufConverter converter = this.getConverter(srFactory.get(), ksqlConfig, Optional.empty(), isKey);
        return new KsqlConnectDeserializer<T>((Converter)converter, this.getDataTranslator(schema, physicalSchema, true), targetType);
    }

    private DataTranslator getDataTranslator(Schema schema, Optional<Schema> physicalSchema, boolean isDeserializer) {
        if (isDeserializer) {
            return new ConnectDataTranslator(schema);
        }
        if (physicalSchema.isPresent()) {
            return new ProtobufSRSchemaDataTranslator(physicalSchema.get());
        }
        if (this.fullSchemaName.isPresent()) {
            return new ProtobufDataTranslator(schema, this.fullSchemaName.get());
        }
        return new ConnectDataTranslator(schema);
    }

    private ProtobufConverter getConverter(SchemaRegistryClient schemaRegistryClient, KsqlConfig ksqlConfig, Optional<Integer> schemaId, boolean isKey) {
        Map protobufConfig = ksqlConfig.originalsWithPrefix("ksql.schema.registry.");
        protobufConfig.put("schema.registry.url", ksqlConfig.getString("ksql.schema.registry.url"));
        if (schemaId.isPresent()) {
            protobufConfig.put("auto.register.schemas", false);
            protobufConfig.put("use.schema.id", schemaId.get());
            protobufConfig.put("id.compatibility.strict", false);
        }
        protobufConfig.putAll(ImmutableMap.of((Object)"wrapper.for.raw.primitives", (Object)this.properties.getUnwrapPrimitives(), (Object)"optional.for.nullables", (Object)this.properties.isNullableAsOptional(), (Object)"wrapper.for.nullables", (Object)this.properties.isNullableAsWrapper()));
        ProtobufConverter converter = new ProtobufConverter(schemaRegistryClient);
        converter.configure(protobufConfig, isKey);
        return converter;
    }

    private static class SchemaValidator
    implements SchemaWalker.Visitor<Void, Void> {
        private SchemaValidator() {
        }

        public Void visitMap(Schema schema, Void key, Void value) {
            if (schema.keySchema().type() != Schema.Type.STRING) {
                throw new KsqlException("PROTOBUF format only supports MAP types with STRING keys. See https://github.com/confluentinc/ksql/issues/6177.");
            }
            return null;
        }

        public Void visitSchema(Schema schema) {
            return null;
        }
    }

    class SchemaAndId {
        private int schemaId;
        private ParsedSchema parsedSchema;

        SchemaAndId(int schemaId, ParsedSchema parsedSchema) {
            this.schemaId = schemaId;
            this.parsedSchema = parsedSchema;
        }

        int getId() {
            return this.schemaId;
        }

        boolean hasMultipleDefinitions() {
            return new ProtobufFormat().schemaFullNames(this.parsedSchema).size() > 1;
        }

        Schema toConnectSchema() {
            ProtobufProperties protobufProperties = Strings.isNullOrEmpty((String)ProtobufSerdeFactory.this.properties.getFullSchemaName()) ? ProtobufSerdeFactory.this.properties.withFullSchemaName(this.parsedSchema.name()) : ProtobufSerdeFactory.this.properties;
            return new ProtobufSchemaTranslator(protobufProperties).toConnectSchema(this.parsedSchema);
        }
    }
}

