/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.tracked;

import io.confluent.ksql.serde.tracked.TrackedCallback;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

final class TrackedSerializer<T>
implements Serializer<T> {
    private final Serializer<T> inner;
    private final TrackedCallback callback;
    private Boolean key;

    TrackedSerializer(Serializer<T> inner, TrackedCallback callback) {
        this.inner = Objects.requireNonNull(inner, "inner");
        this.callback = Objects.requireNonNull(callback, "callback");
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
        this.key = isKey;
    }

    public byte[] serialize(String topic, T data) {
        this.track(topic);
        return this.inner.serialize(topic, data);
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        this.track(topic);
        return this.inner.serialize(topic, headers, data);
    }

    public void close() {
        this.inner.close();
    }

    private void track(String topicName) {
        if (this.key == null) {
            throw new IllegalStateException("Configure not called");
        }
        this.callback.accept(topicName, this.key);
    }
}

