/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.rbac;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.resource.PatternType;

public class AccessPolicy {
    private final String bindingScope;
    private final boolean bindWithResource;
    private final Map<ResourceType, Collection<Operation>> allowedOperations;
    private final List<ResourcePattern> wildcardResourcePatterns;

    @JsonCreator
    public AccessPolicy(@JsonProperty(value="bindingScope") String bindingScope, @JsonProperty(value="bindWithResource") Boolean bindWithResource, @JsonProperty(value="allowedOperations") Collection<ResourceOperations> allowedOperations) {
        this.bindingScope = Objects.requireNonNull(bindingScope);
        this.bindWithResource = Objects.requireNonNull(bindWithResource);
        this.allowedOperations = allowedOperations.stream().collect(Collectors.toMap(op -> ResourceType.resourceType((String)((ResourceOperations)op).resourceType), op -> ((ResourceOperations)op).operations.stream().map(Operation::new).collect(Collectors.toList())));
        this.wildcardResourcePatterns = this.bindWithResource ? Collections.emptyList() : Collections.unmodifiableList(allowedOperations.stream().map(resourceOperation -> new ResourcePattern(((ResourceOperations)resourceOperation).resourceType, "*", PatternType.LITERAL)).collect(Collectors.toList()));
    }

    static AccessPolicy merge(AccessPolicy accessPolicy1, AccessPolicy accessPolicy2) {
        if (!Objects.equals(accessPolicy1.bindingScope, accessPolicy2.bindingScope)) {
            throw new IllegalArgumentException("Scope does not match");
        }
        if (!Objects.equals(accessPolicy1.bindWithResource, accessPolicy2.bindWithResource)) {
            throw new IllegalArgumentException("bindWithResource property does not match");
        }
        HashMap<ResourceType, Collection<Operation>> mergedOperations = new HashMap<ResourceType, Collection<Operation>>(accessPolicy1.allowedOperations);
        accessPolicy2.allowedOperations.forEach((key, value) -> mergedOperations.merge((ResourceType)key, (Collection<Operation>)value, (v1, v2) -> {
            if (v1.stream().anyMatch(v2::contains)) {
                throw new IllegalArgumentException("There are duplicate operations in the AccessPolicy merge. Operation List1 :" + v1 + " , Operation List2 :" + v2);
            }
            return Stream.concat(v1.stream(), v2.stream()).collect(Collectors.toList());
        }));
        ArrayList<ResourceOperations> allowedOperations = new ArrayList<ResourceOperations>();
        for (Map.Entry entry : mergedOperations.entrySet()) {
            Collection operations = ((Collection)entry.getValue()).stream().map(Operation::name).collect(Collectors.toList());
            allowedOperations.add(new ResourceOperations(((ResourceType)entry.getKey()).name(), operations));
        }
        return new AccessPolicy(accessPolicy1.bindingScope, accessPolicy1.bindWithResource, allowedOperations);
    }

    @JsonProperty
    public String bindingScope() {
        return this.bindingScope;
    }

    @JsonProperty
    public boolean bindWithResource() {
        return this.bindWithResource;
    }

    @JsonProperty
    public Collection<ResourceOperations> allowedOperations() {
        return this.allowedOperations.entrySet().stream().map(e -> new ResourceOperations(((ResourceType)e.getKey()).name(), ((Collection)e.getValue()).stream().map(Operation::name).collect(Collectors.toSet()))).collect(Collectors.toSet());
    }

    public Collection<Operation> allowedOperations(ResourceType resourceType) {
        Collection<Operation> ops = this.allowedOperations.get(resourceType);
        return ops == null ? Collections.emptySet() : ops;
    }

    public List<ResourcePattern> wildcardResourcePatterns() {
        return this.wildcardResourcePatterns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessPolicy)) {
            return false;
        }
        AccessPolicy that = (AccessPolicy)o;
        return Objects.equals(this.bindWithResource, that.bindWithResource) && Objects.equals(this.bindingScope, that.bindingScope) && Objects.equals(this.allowedOperations, that.allowedOperations);
    }

    public int hashCode() {
        return Objects.hash(this.bindingScope, this.allowedOperations);
    }

    public String toString() {
        return "AccessPolicy{bindingScope='" + this.bindingScope + '\'' + ", bindWithResource=" + this.bindWithResource + ", allowedOperations=" + this.allowedOperations + ", wildcardResourcePatterns=" + this.wildcardResourcePatterns + '}';
    }

    public static class ResourceOperations {
        private final String resourceType;
        private final Collection<String> operations;

        @JsonCreator
        public ResourceOperations(@JsonProperty(value="resourceType") String resourceType, @JsonProperty(value="operations") Collection<String> operations) {
            this.resourceType = resourceType;
            this.operations = operations;
        }

        @JsonProperty
        public String resourceType() {
            return this.resourceType;
        }

        @JsonProperty
        public Collection<String> operations() {
            return this.operations;
        }
    }
}

