/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.utils;

import io.confluent.kafka.common.utils.Interner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InternerTest {
    InternerTest() {
    }

    @Test
    public void testIntern() {
        Interner interner = new Interner();
        Internable internable1 = new Internable("foo");
        Internable internable2 = new Internable("foo");
        Assertions.assertEquals((int)internable1.hashCode(), (int)internable2.hashCode());
        Assertions.assertNotSame((Object)internable1, (Object)internable2);
        Internable interned1 = (Internable)interner.intern((Object)internable1);
        Internable interned2 = (Internable)interner.intern((Object)internable2);
        Assertions.assertSame((Object)interned1, (Object)interned2);
        Internable interned3 = (Internable)interner.intern((Object)new Internable("bar"));
        Assertions.assertNotSame((Object)interned3, (Object)interned2);
        Assertions.assertEquals((Object)interned1.data, (Object)"foo");
        Assertions.assertEquals((Object)interned2.data, (Object)"foo");
        Assertions.assertEquals((Object)interned3.data, (Object)"bar");
    }

    private static class Internable {
        String data;

        private Internable(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Internable that = (Internable)o;
            return this.data != null ? this.data.equals(that.data) : that.data == null;
        }

        public int hashCode() {
            return this.data != null ? this.data.hashCode() : 0;
        }
    }
}

