/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.server.common.AlterReplicaExclusionOp;
import org.apache.kafka.server.common.BrokerReplicaExclusionModificationResult;
import org.apache.kafka.server.common.BrokerReplicaExclusionResult;
import org.apache.kafka.server.util.BrokerReplicaExclusionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BrokerExclusionRequestUtilsTest {
    private final Map<Integer, String> presentExclusions = new HashMap<Integer, String>();

    @BeforeEach
    public void setUp() {
        this.presentExclusions.put(1, "1");
        this.presentExclusions.put(2, "2");
    }

    @Test
    public void testExclusionExists() {
        Assertions.assertTrue((boolean)BrokerReplicaExclusionUtils.exclusionExists(this.presentExclusions, (int)1), (String)"Expected exclusion to exist");
        Assertions.assertTrue((boolean)BrokerReplicaExclusionUtils.exclusionExists(this.presentExclusions, (int)1, (String)"1"), (String)"Expected exclusion to exist");
    }

    @Test
    public void testExclusionExistsReturnsFalseIfDifferentReason() {
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionExists(this.presentExclusions, (int)1, (String)"2"), (String)"Expected exclusion to not exist due to a different reason");
    }

    @Test
    public void testExclusionExistsReturnsFalseIfBrokerIdNotPresent() {
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionExists(this.presentExclusions, (int)3), (String)"Expected exclusion to not exist due to the broker id not existing");
    }

    @Test
    public void testExclusionExistsWithNullReasons() {
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionExists(this.presentExclusions, (int)1, null), (String)"Expected exclusion to not exist due to the reason not matching");
        Map<Integer, Object> exclusionsWithNull = Collections.singletonMap(1, null);
        Assertions.assertTrue((boolean)BrokerReplicaExclusionUtils.exclusionExists(exclusionsWithNull, (int)1, null), (String)"Expected exclusion to exist due to the the null reason matching");
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionExists(exclusionsWithNull, (int)1, (String)"something"), (String)"Expected exclusion to not exist due to the reasons not matching");
    }

    @Test
    public void testPrepareReplicaExclusions() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.SET)));
        HashSet<BrokerReplicaExclusionResult> expectedExclusionResults = new HashSet<BrokerReplicaExclusionResult>(Arrays.asList(new BrokerReplicaExclusionResult(1, Optional.empty(), ExclusionOp.OpType.DELETE, "1"), new BrokerReplicaExclusionResult(3, Optional.empty(), ExclusionOp.OpType.SET, "3")));
        HashMap<Integer, String> expectedExclusions = new HashMap<Integer, String>(this.presentExclusions);
        expectedExclusions.remove(1);
        expectedExclusions.put(3, "3");
        HashMap<Integer, String> originalExclusions = new HashMap<Integer, String>(this.presentExclusions);
        BrokerReplicaExclusionModificationResult result = BrokerReplicaExclusionUtils.prepareReplicaExclusions(this.presentExclusions, requestedExclusions);
        Assertions.assertEquals(originalExclusions, this.presentExclusions, (String)"Expected the original reference map to not have changed");
        Assertions.assertTrue((boolean)result.shouldApply(), (String)"Expected the exclusion result to have applied successfully");
        Assertions.assertTrue((boolean)result.reply().wasSuccessful(), (String)"Expected the exclusion result to have applied successfully");
        Assertions.assertFalse((boolean)result.reply().wasSuccessfulNoOp(), (String)"Expected exclusion result to not be a no-op");
        Assertions.assertEquals(expectedExclusionResults, (Object)result.reply().exclusionResults());
        Assertions.assertEquals(expectedExclusions, (Object)result.modifiedExclusions());
    }

    @Test
    public void testPrepareReplicaExclusionsDoesntApplyWithUnknownType() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.UNKNOWN), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.SET)));
        BrokerReplicaExclusionModificationResult result = BrokerReplicaExclusionUtils.prepareReplicaExclusions(this.presentExclusions, requestedExclusions);
        Assertions.assertFalse((boolean)result.shouldApply(), (String)"Expected the exclusion result to NOT have applied due to an error");
        Assertions.assertFalse((boolean)result.reply().wasSuccessful(), (String)"Expected the exclusion result to NOT have applied due to an error");
        Assertions.assertFalse((boolean)result.reply().wasSuccessfulNoOp(), (String)"Expected exclusion result to not be a no-op");
        Assertions.assertEquals((int)2, (int)result.reply().exclusionResults().size());
        Assertions.assertTrue((boolean)result.reply().exclusionResults().stream().anyMatch(r -> r.opType() == ExclusionOp.OpType.UNKNOWN && r.apiErrorOptional().isPresent()), (String)String.format("The result should have an unknown exclusion result with an error attached but instead it didn't (results %s)", result.reply().exclusionResults()));
        Assertions.assertEquals(this.presentExclusions, (Object)result.modifiedExclusions(), (String)"The exclusions should not have changed");
    }

    @Test
    public void testPrepareReplicaExclusionsDoesntApplyWhenDeletingNonExistentExclusion() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.DELETE), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.DELETE)));
        BrokerReplicaExclusionModificationResult result = BrokerReplicaExclusionUtils.prepareReplicaExclusions(this.presentExclusions, requestedExclusions);
        Assertions.assertFalse((boolean)result.shouldApply(), (String)"Expected the exclusion result to NOT have applied due to an error");
        Assertions.assertFalse((boolean)result.reply().wasSuccessful(), (String)"Expected the exclusion result to NOT have applied due to an error");
        Assertions.assertFalse((boolean)result.reply().wasSuccessfulNoOp(), (String)"Expected exclusion result to not be a no-op");
        Assertions.assertEquals((int)2, (int)result.reply().exclusionResults().size());
        Assertions.assertTrue((boolean)result.reply().exclusionResults().stream().anyMatch(r -> r.brokerId() == 3 && r.apiErrorOptional().isPresent()), (String)String.format("The result should have an exclusion result with an error attached but instead it didn't (results %s)", result.reply().exclusionResults()));
        Assertions.assertEquals(this.presentExclusions, (Object)result.modifiedExclusions(), (String)"The exclusions should not have changed");
    }

    @Test
    public void testExclusionsMatchCurrentState() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.DELETE)));
        Assertions.assertTrue((boolean)BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.presentExclusions, requestedExclusions), (String)"Expected the requested exclusions to match the current state");
    }

    @Test
    public void testExclusionsDoesntMatchCurrentStateIfUnrecognizedOpTypeGiven() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.UNKNOWN)));
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.presentExclusions, requestedExclusions), (String)"Expected the requested exclusions to NOT match the current state due to the unknown type");
    }

    @Test
    public void testExclusionsDoesntMatchCurrentStateIfExclusionToBeDeletedIsPresent() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(2, "2", ExclusionOp.OpType.DELETE)));
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.presentExclusions, requestedExclusions), (String)"Expected the requested exclusions to NOT match the current state due to broker 2 not having been deleted already");
    }

    @Test
    public void testExclusionsDoesntMatchCurrentStateIfExclusionToBeSetDoesntExist() {
        HashSet<AlterReplicaExclusionOp> requestedExclusions = new HashSet<AlterReplicaExclusionOp>(Arrays.asList(new AlterReplicaExclusionOp(1, "1", ExclusionOp.OpType.SET), new AlterReplicaExclusionOp(3, "3", ExclusionOp.OpType.SET)));
        Assertions.assertFalse((boolean)BrokerReplicaExclusionUtils.exclusionsMatchCurrentState(this.presentExclusions, requestedExclusions), (String)"Expected the requested exclusions to NOT match the current state due to broker 3 not having been set already");
    }
}

