/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.GroupProvider;
import io.confluent.security.authorizer.provider.MetadataProvider;
import io.confluent.security.authorizer.provider.Provider;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;

public class ConfluentAuthorizerConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG;
    public static final String ACCESS_RULE_PROVIDERS_PROP = "confluent.authorizer.access.rule.providers";
    private static final String ACCESS_RULE_PROVIDERS_DEFAULT;
    private static final String ACCESS_RULE_PROVIDERS_DOC;
    public static final String INIT_TIMEOUT_PROP = "confluent.authorizer.init.timeout.ms";
    private static final int INIT_TIMEOUT_DEFAULT = 600000;
    private static final String INIT_TIMEOUT_DOC = "The number of milliseconds to wait for authorizer to start up and initialize any metadata from Kafka topics. On brokers of the cluster hosting metadata topics, inter-broker listeners will be started prior to initialization of authorizer metadata from Kafka topics.";
    public static final String ALLOW_IF_NO_ACLS_PROP = "allow.everyone.if.no.acl.found";
    private static final boolean ALLOW_IF_NO_ACLS_DEFAULT = false;
    private static final String ALLOW_IF_NO_ACLS_DOC = "Boolean flag that indicates if everyone is allowed access to a resource if no ACL is found.";
    public static final String SUPER_USERS_PROP = "super.users";
    private static final String SUPER_USERS_DEFAULT = "";
    private static final String SUPER_USERS_DOC = "Semicolon-separated list of principals of super users who are allowed access to all resources.";
    public static final String BROKER_USERS_PROP = "broker.users";
    private static final String BROKER_USERS_DEFAULT = "";
    private static final String BROKER_USERS_DOC = "Semicolon-separated list of principals of users who are allowed access to all resources on inter broker listener.";
    public static final String MIGRATE_ACLS_FROM_ZK_PROP = "confluent.authorizer.migrate.acls.from.zk";
    private static final boolean MIGRATE_ACLS_FROM_ZK_DEFAULT = false;
    private static final String MIGRATE_ACLS_FROM_ZK_DOC = "(depreciated)This boolean flag is used when we want to migrate ZK ACLs to metadata service. For migration, configure both ACL and RBAC providers and do a rolling restart of the cluster. Also enable this flag on last broker of rolling restart. Based on this flag, last broker will copy the ACLs to metadata service. After migration, remove ACL provider and remove this flag from broker and do a rolling restart. Please check migration docs for more details.";
    public static final String MIGRATE_ACLS_FROM_CLUSTER_PROP = "confluent.authorizer.migrate.acls.from.cluster";
    private static final boolean MIGRATE_ACLS_FROM_CLUSTER_DEFAULT = false;
    private static final String MIGRATE_ACLS_FROM_CLUSTER_DOC = "This boolean flag is used when we want to migrate ZK/KRAFT ACLs to metadata service. For migration, configure both ACL and RBAC providers and do a rolling restart of the cluster. Also enable this flag on last broker of rolling restart. Based on this flag, last broker will copy the ACLs to metadata service. After migration, remove ACL provider and remove this flag from broker and do a rolling restart. Please check migration docs for more details.";
    public static final String ACL_MIGRATION_BATCH_SIZE_PROP = "confluent.authorizer.acl.migration.batch.size";
    private static final int ACL_MIGRATION_BATCH_SIZE_DEFAULT = 1000;
    private static final String ACL_MIGRATION_BATCH_SIZE_DOC = "Batch size used while migrating ACLs from zk to metadata service.";
    public static final String OAUTH_GROUPS_CLAIM_NAME = "confluent.oauth.groups.claim.name";
    private static final String OAUTH_GROUPS_CLAIM_NAME_DEFAULT = "";
    private static final String OAUTH_GROUPS_CLAIM_NAME_DEFAULT_DOC = "Claim to be used for groups rbac support ";
    public final boolean allowEveryoneIfNoAcl = this.getBoolean("allow.everyone.if.no.acl.found");
    public final boolean migrateAclsFromCluster;
    public Set<KafkaPrincipal> superUsers;
    public Set<KafkaPrincipal> brokerUsers;
    public final Duration initTimeout;

    public ConfluentAuthorizerConfig(Map<?, ?> props) {
        super(CONFIG, props);
        List providerNames = this.getList(ACCESS_RULE_PROVIDERS_PROP);
        if (providerNames.isEmpty()) {
            throw new ConfigException("No access rule providers specified");
        }
        if (providerNames.contains(ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name())) {
            String processRoles = (String)props.get("process.roles");
            if (processRoles == null || processRoles.isEmpty()) {
                throw new ConfigException("The KRAFT_ACL provider can only be used on a KRaft cluster");
            }
            if (providerNames.contains(ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name())) {
                throw new ConfigException("Only one of ZK_ACL and KRAFT_ACL can be enabled for `confluent.authorizer.access.rule.providers`");
            }
        }
        this.superUsers = ConfluentAuthorizerConfig.parseUsers(this.getString(SUPER_USERS_PROP));
        this.brokerUsers = ConfluentAuthorizerConfig.parseUsers(this.getString(BROKER_USERS_PROP));
        this.initTimeout = Duration.ofMillis(this.getInt(INIT_TIMEOUT_PROP).intValue());
        this.migrateAclsFromCluster = this.getBoolean(MIGRATE_ACLS_FROM_ZK_PROP) != false || this.getBoolean(MIGRATE_ACLS_FROM_CLUSTER_PROP) != false;
    }

    public static Set<KafkaPrincipal> parseUsers(String su) {
        if (su != null && !su.trim().isEmpty()) {
            String[] users = su.split(";");
            return Arrays.stream(users).map(user -> SecurityUtils.parseKafkaPrincipal((String)user.trim())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public List<String> authProviderNames() {
        ArrayList<String> authProviderNames = new ArrayList<String>(this.getList(ACCESS_RULE_PROVIDERS_PROP));
        if (authProviderNames.contains(ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name())) {
            authProviderNames.remove(ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name());
            authProviderNames.remove(ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name());
        }
        return authProviderNames;
    }

    public final Providers createProviders(String clusterId) {
        return this.createProviders(clusterId, Collections.emptySet());
    }

    public final Providers createProviders(String clusterId, Set<Provider> existing) {
        List<String> authProviderNames = this.authProviderNames();
        if (authProviderNames.isEmpty()) {
            throw new ConfigException("No access rule providers specified");
        }
        List<AccessRuleProvider> accessRuleProviders = ConfluentBuiltInProviders.loadAccessRuleProviders(authProviderNames);
        HashSet<AccessRuleProvider> providers = new HashSet<AccessRuleProvider>(accessRuleProviders);
        if (existing != null && existing.size() > 0) {
            Set existingNames = existing.stream().map(Provider::providerName).collect(Collectors.toSet());
            providers.removeIf(p -> existingNames.contains(p.providerName()));
            providers.addAll(existing);
            accessRuleProviders = providers.stream().map(prov -> (AccessRuleProvider)prov).collect(Collectors.toList());
        }
        GroupProvider groupProvider = this.createProvider(GroupProvider.class, ConfluentBuiltInProviders::loadGroupProvider, providers);
        providers.add((AccessRuleProvider)((Object)groupProvider));
        MetadataProvider metadataProvider = this.createProvider(MetadataProvider.class, ConfluentBuiltInProviders::loadMetadataProvider, providers);
        providers.add((AccessRuleProvider)((Object)metadataProvider));
        if (clusterId != null) {
            ClusterResource clusterResource = new ClusterResource(clusterId);
            providers.forEach(provider -> {
                if (provider instanceof ClusterResourceListener) {
                    ((ClusterResourceListener)provider).onUpdate(clusterResource);
                }
            });
        }
        providers.forEach(provider -> provider.configure(this.originals()));
        return new Providers(accessRuleProviders, groupProvider, metadataProvider);
    }

    private <T extends Provider> T createProvider(Class<T> providerClass, Function<Map<String, ?>, T> creator, Collection<? extends Provider> otherProviders) {
        Set otherProviderNames = otherProviders.stream().map(Provider::providerName).collect(Collectors.toSet());
        for (Provider provider : otherProviders) {
            if (!otherProviderNames.contains(provider.providerName()) || !providerClass.isInstance(provider)) continue;
            return (T)provider;
        }
        return (T)((Provider)((Object)creator.apply(this.originals())));
    }

    public static Set<String> accessRuleProviders(Map<String, ?> configs) {
        String accessProviders = (String)configs.get(ACCESS_RULE_PROVIDERS_PROP);
        if (accessProviders == null || accessProviders.isEmpty()) {
            return Collections.emptySet();
        }
        return Utils.mkSet((Object[])accessProviders.trim().split("\\s*,\\s*"));
    }

    public String toString() {
        return Utils.mkString((Map)this.values(), (String)"", (String)"", (String)"=", (String)"%n\t");
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }

    static {
        ACCESS_RULE_PROVIDERS_DEFAULT = ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name();
        ACCESS_RULE_PROVIDERS_DOC = "List of access rule providers enabled.  Access rule providers supported are " + ConfluentBuiltInProviders.builtInAccessRuleProviders() + ". ACL-based provider is enabled by default.";
        CONFIG = new ConfigDef().define(ALLOW_IF_NO_ACLS_PROP, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, ALLOW_IF_NO_ACLS_DOC).define(SUPER_USERS_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, SUPER_USERS_DOC).define(BROKER_USERS_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, BROKER_USERS_DOC).define(ACCESS_RULE_PROVIDERS_PROP, ConfigDef.Type.LIST, (Object)ACCESS_RULE_PROVIDERS_DEFAULT, ConfigDef.Importance.MEDIUM, ACCESS_RULE_PROVIDERS_DOC).define(INIT_TIMEOUT_PROP, ConfigDef.Type.INT, (Object)600000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, INIT_TIMEOUT_DOC).define(MIGRATE_ACLS_FROM_ZK_PROP, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, MIGRATE_ACLS_FROM_ZK_DOC).define(MIGRATE_ACLS_FROM_CLUSTER_PROP, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, MIGRATE_ACLS_FROM_CLUSTER_DOC).define(ACL_MIGRATION_BATCH_SIZE_PROP, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.MEDIUM, ACL_MIGRATION_BATCH_SIZE_DOC).define(OAUTH_GROUPS_CLAIM_NAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, OAUTH_GROUPS_CLAIM_NAME_DEFAULT_DOC);
    }

    public static class Providers {
        public final List<AccessRuleProvider> accessRuleProviders;
        public final GroupProvider groupProvider;
        public final MetadataProvider metadataProvider;

        private Providers(List<AccessRuleProvider> accessRuleProviders, GroupProvider groupProvider, MetadataProvider metadataProvider) {
            this.accessRuleProviders = accessRuleProviders;
            this.groupProvider = groupProvider;
            this.metadataProvider = metadataProvider;
        }
    }
}

